<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.10
 */

// Logo
if (grab_taxi_is_on(grab_taxi_get_theme_option('logo_in_footer'))) {
	$grab_taxi_logo_image = '';
	if (grab_taxi_get_retina_multiplier(2) > 1)
		$grab_taxi_logo_image = grab_taxi_get_theme_option( 'logo_footer_retina' );
	if (empty($grab_taxi_logo_image)) 
		$grab_taxi_logo_image = grab_taxi_get_theme_option( 'logo_footer' );
	$grab_taxi_logo_text   = get_bloginfo( 'name' );
	if (!empty($grab_taxi_logo_image) || !empty($grab_taxi_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($grab_taxi_logo_image)) {
					$grab_taxi_attr = grab_taxi_getimagesize($grab_taxi_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($grab_taxi_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'grab-taxi').'"'.(!empty($grab_taxi_attr[3]) ? sprintf(' %s', $grab_taxi_attr[3]) : '').'></a>' ;
				} else if (!empty($grab_taxi_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($grab_taxi_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>