<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.10
 */

// Copyright area
$grab_taxi_footer_scheme =  grab_taxi_is_inherit(grab_taxi_get_theme_option('footer_scheme')) ? grab_taxi_get_theme_option('color_scheme') : grab_taxi_get_theme_option('footer_scheme');
$grab_taxi_copyright_scheme = grab_taxi_is_inherit(grab_taxi_get_theme_option('copyright_scheme')) ? $grab_taxi_footer_scheme : grab_taxi_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($grab_taxi_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php

				$grab_taxi_copyright = grab_taxi_prepare_macros(grab_taxi_get_theme_option('copyright'));
				if (!empty($grab_taxi_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $grab_taxi_copyright, $grab_taxi_matches)) {
						$grab_taxi_copyright = str_replace($grab_taxi_matches[1], date(str_replace(array('{', '}'), '', $grab_taxi_matches[1])), $grab_taxi_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($grab_taxi_copyright));
				}
			?></div>
		</div>
	</div>
</div>
