<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_sidebar_position = grab_taxi_get_theme_option('sidebar_position');
if (grab_taxi_sidebar_present()) {
	ob_start();
	$grab_taxi_sidebar_name = grab_taxi_get_theme_option('sidebar_widgets');
	grab_taxi_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($grab_taxi_sidebar_name) ) {
		dynamic_sidebar($grab_taxi_sidebar_name);
	}
	$grab_taxi_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($grab_taxi_out)) {
		?>
		<div class="sidebar <?php echo esc_attr($grab_taxi_sidebar_position); ?> widget_area<?php if (!grab_taxi_is_inherit(grab_taxi_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(grab_taxi_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'grab_taxi_action_before_sidebar' );
				grab_taxi_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $grab_taxi_out));
				do_action( 'grab_taxi_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>