<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'grab_taxi_trx_updater_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'grab_taxi_trx_updater_theme_setup9', 9 );
	function grab_taxi_trx_updater_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'grab_taxi_filter_tgmpa_required_plugins', 'grab_taxi_trx_updater_tgmpa_required_plugins', 8 );
		}
	}
}

// Filter to add in the required plugins list
// Priority 8 is used to add this plugin before all other plugins
if ( ! function_exists( 'grab_taxi_trx_updater_tgmpa_required_plugins' ) ) {
	function grab_taxi_trx_updater_tgmpa_required_plugins( $list = array() ) {
		if (in_array('trx_updater', grab_taxi_storage_get('required_plugins'))){
			$path = grab_taxi_get_file_dir( 'plugins/trx_updater/trx_updater.zip' );
			if ( ! empty( $path ) || grab_taxi_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => esc_html__('TRX Updater', 'grab-taxi'),
					'slug'     => 'trx_updater',
					'source'   => ! empty( $path ) ? $path : 'upload://trx_updater.zip',
					'version'  => '1.4.1',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'grab_taxi_exists_trx_updater' ) ) {
	function grab_taxi_exists_trx_updater() {
		return defined( 'TRX_UPDATER_VERSION' );
	}
}
