<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('grab_taxi_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'grab_taxi_revslider_theme_setup9', 9 );
	function grab_taxi_revslider_theme_setup9() {
		if (grab_taxi_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'grab_taxi_revslider_frontend_scripts', 1100 );
			add_filter( 'grab_taxi_filter_merge_styles',			'grab_taxi_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'grab_taxi_filter_tgmpa_required_plugins','grab_taxi_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'grab_taxi_exists_revslider' ) ) {
	function grab_taxi_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'grab_taxi_revslider_tgmpa_required_plugins' ) ) {
	function grab_taxi_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', grab_taxi_storage_get('required_plugins'))) {
			$path = grab_taxi_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'grab-taxi'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
                    'version'  => '6.2.2',
					'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'grab_taxi_revslider_frontend_scripts' ) ) {
	function grab_taxi_revslider_frontend_scripts() {
		if (grab_taxi_is_on(grab_taxi_get_theme_option('debug_mode')) && grab_taxi_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'grab-taxi-revslider',  grab_taxi_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'grab_taxi_revslider_merge_styles' ) ) {
	function grab_taxi_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>