<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

grab_taxi_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'classie', grab_taxi_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'grab-taxi-gallery-script', grab_taxi_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$grab_taxi_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$grab_taxi_sticky_out = grab_taxi_get_theme_option('sticky_style')=='columns' 
							&& is_array($grab_taxi_stickies) && count($grab_taxi_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$grab_taxi_cat = grab_taxi_get_theme_option('parent_cat');
	$grab_taxi_post_type = grab_taxi_get_theme_option('post_type');
	$grab_taxi_taxonomy = grab_taxi_get_post_type_taxonomy($grab_taxi_post_type);
	$grab_taxi_show_filters = grab_taxi_get_theme_option('show_filters');
	$grab_taxi_tabs = array();
	if (!grab_taxi_is_off($grab_taxi_show_filters)) {
		$grab_taxi_args = array(
			'type'			=> $grab_taxi_post_type,
			'child_of'		=> $grab_taxi_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $grab_taxi_taxonomy,
			'pad_counts'	=> false
		);
		$grab_taxi_portfolio_list = get_terms($grab_taxi_args);
		if (is_array($grab_taxi_portfolio_list) && count($grab_taxi_portfolio_list) > 0) {
			$grab_taxi_tabs[$grab_taxi_cat] = esc_html__('All', 'grab-taxi');
			foreach ($grab_taxi_portfolio_list as $grab_taxi_term) {
				if (isset($grab_taxi_term->term_id)) $grab_taxi_tabs[$grab_taxi_term->term_id] = $grab_taxi_term->name;
			}
		}
	}
	if (count($grab_taxi_tabs) > 0) {
		$grab_taxi_portfolio_filters_ajax = true;
		$grab_taxi_portfolio_filters_active = $grab_taxi_cat;
		$grab_taxi_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters grab_taxi_tabs grab_taxi_tabs_ajax">
			<ul class="portfolio_titles grab_taxi_tabs_titles">
				<?php
				foreach ($grab_taxi_tabs as $grab_taxi_id=>$grab_taxi_title) {
					?><li><a href="<?php echo esc_url(grab_taxi_get_hash_link(sprintf('#%s_%s_content', $grab_taxi_portfolio_filters_id, $grab_taxi_id))); ?>" data-tab="<?php echo esc_attr($grab_taxi_id); ?>"><?php echo esc_html($grab_taxi_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$grab_taxi_ppp = grab_taxi_get_theme_option('posts_per_page');
			if (grab_taxi_is_inherit($grab_taxi_ppp)) $grab_taxi_ppp = '';
			foreach ($grab_taxi_tabs as $grab_taxi_id=>$grab_taxi_title) {
				$grab_taxi_portfolio_need_content = $grab_taxi_id==$grab_taxi_portfolio_filters_active || !$grab_taxi_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $grab_taxi_portfolio_filters_id, $grab_taxi_id)); ?>"
					class="portfolio_content grab_taxi_tabs_content"
					data-blog-template="<?php echo esc_attr(grab_taxi_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(grab_taxi_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($grab_taxi_ppp); ?>"
					data-post-type="<?php echo esc_attr($grab_taxi_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($grab_taxi_taxonomy); ?>"
					data-cat="<?php echo esc_attr($grab_taxi_id); ?>"
					data-parent-cat="<?php echo esc_attr($grab_taxi_cat); ?>"
					data-need-content="<?php echo (false===$grab_taxi_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($grab_taxi_portfolio_need_content) 
						grab_taxi_show_portfolio_posts(array(
							'cat' => $grab_taxi_id,
							'parent_cat' => $grab_taxi_cat,
							'taxonomy' => $grab_taxi_taxonomy,
							'post_type' => $grab_taxi_post_type,
							'page' => 1,
							'sticky' => $grab_taxi_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		grab_taxi_show_portfolio_posts(array(
			'cat' => $grab_taxi_cat,
			'parent_cat' => $grab_taxi_cat,
			'taxonomy' => $grab_taxi_taxonomy,
			'post_type' => $grab_taxi_post_type,
			'page' => 1,
			'sticky' => $grab_taxi_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>