<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

grab_taxi_storage_set('blog_archive', true);

// Load scripts for 'Masonry' layout
if (substr(grab_taxi_get_theme_option('blog_style'), 0, 7) == 'masonry') {
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'classie', grab_taxi_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
	wp_enqueue_script( 'grab-taxi-gallery-script', grab_taxi_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );
}

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$grab_taxi_classes = 'posts_container '
						. (substr(grab_taxi_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap' : 'masonry_wrap');
	$grab_taxi_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$grab_taxi_sticky_out = grab_taxi_get_theme_option('sticky_style')=='columns' 
							&& is_array($grab_taxi_stickies) && count($grab_taxi_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($grab_taxi_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$grab_taxi_sticky_out) {
		if (grab_taxi_get_theme_option('first_post_large') && !is_paged() && !in_array(grab_taxi_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($grab_taxi_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($grab_taxi_sticky_out && !is_sticky()) {
			$grab_taxi_sticky_out = false;
			?></div><div class="<?php echo esc_attr($grab_taxi_classes); ?>"><?php
		}
		get_template_part( 'content', $grab_taxi_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	grab_taxi_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>