<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_blog_style = explode('_', grab_taxi_get_theme_option('blog_style'));
$grab_taxi_columns = empty($grab_taxi_blog_style[1]) ? 2 : max(2, $grab_taxi_blog_style[1]);
$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($grab_taxi_columns).' post_format_'.esc_attr($grab_taxi_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$grab_taxi_image_hover = grab_taxi_get_theme_option('image_hover');
	// Featured image
	grab_taxi_show_post_featured(array(
		'thumb_size' => grab_taxi_get_thumb_size(strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false || $grab_taxi_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $grab_taxi_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $grab_taxi_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>