<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_blog_style = explode('_', grab_taxi_get_theme_option('blog_style'));
$grab_taxi_columns = empty($grab_taxi_blog_style[1]) ? 2 : max(2, $grab_taxi_blog_style[1]);
$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');
$grab_taxi_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($grab_taxi_columns).' post_format_'.esc_attr($grab_taxi_post_format) ); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($grab_taxi_image[1]) && !empty($grab_taxi_image[2])) echo intval($grab_taxi_image[1]) .'x' . intval($grab_taxi_image[2]); ?>"
	data-src="<?php if (!empty($grab_taxi_image[0])) echo esc_url($grab_taxi_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$grab_taxi_image_hover = 'icon';
	if (in_array($grab_taxi_image_hover, array('icons', 'zoom'))) $grab_taxi_image_hover = 'dots';
	grab_taxi_show_post_featured(array(
		'hover' => $grab_taxi_image_hover,
		'thumb_size' => grab_taxi_get_thumb_size( strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false || $grab_taxi_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
									'components' => 'categories,date,counters,share',
									'counters' => 'comments',
									'seo' => false,
									'echo' => false
									), $grab_taxi_blog_style[0], $grab_taxi_columns))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'grab-taxi') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>