<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($grab_taxi_post_format) ); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>
	><?php

	echo "<div class='post_excerpt_inner'>";

	echo "<div class='post_meta_above'>";
	grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
			'components' => 'date',
			'counters' => '',
			'seo' => false
		), 'excerpt', 0)
	);
	echo "</div>";

	// Featured image
	grab_taxi_show_post_featured(array( 'thumb_size' => grab_taxi_get_thumb_size( strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));
	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('grab_taxi_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('grab_taxi_action_before_post_meta'); 

			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (grab_taxi_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'grab-taxi' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'grab-taxi' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$grab_taxi_show_learn_more = !in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($grab_taxi_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($grab_taxi_post_format == 'quote') {
					if (($quote = grab_taxi_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						grab_taxi_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
		}
	?></div><!-- .entry-content -->
	<?php
	// Post meta
	grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
			'components' => 'categories,counters',
			'counters' => 'comments,likes',
			'seo' => false
		), 'excerpt', 1)
	);
	echo "</div>";
	?>
</article>
