<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_blog_style = explode('_', grab_taxi_get_theme_option('blog_style'));
$grab_taxi_columns = empty($grab_taxi_blog_style[1]) ? 2 : max(2, $grab_taxi_blog_style[1]);
$grab_taxi_expanded = !grab_taxi_sidebar_present() && grab_taxi_is_on(grab_taxi_get_theme_option('expand_content'));
$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');

?><div class="<?php grab_taxi_show_layout($grab_taxi_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($grab_taxi_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($grab_taxi_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($grab_taxi_columns)
					. ' post_layout_'.esc_attr($grab_taxi_blog_style[0]) 
					. ' post_layout_'.esc_attr($grab_taxi_blog_style[0]).'_'.esc_attr($grab_taxi_columns)
					); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	grab_taxi_show_post_featured( array(
													'hover' => 'none',
													'thumb_size' => grab_taxi_get_thumb_size($grab_taxi_blog_style[0] == 'classic'
													? (strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false 
															? ( $grab_taxi_columns > 2 ? 'big' : 'huge' )
															: (	$grab_taxi_columns > 2
																? ($grab_taxi_expanded ? 'med' : 'small')
																: ($grab_taxi_expanded ? 'big' : 'med')
																)
														)
													: (strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false 
															? ( $grab_taxi_columns > 2 ? 'masonry-big' : 'full' )
															: (	$grab_taxi_columns <= 2 && $grab_taxi_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );


	grab_taxi_show_layout("<div class='post_meta_under'>");
	grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
			'components' => 'date',
			'counters' => '',
			'seo' => false
		), 'excerpt', 0)
	);
	grab_taxi_show_layout("</div>");

	if ( !in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('grab_taxi_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('grab_taxi_action_before_post_meta'); 

			do_action('grab_taxi_action_after_post_meta');
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php

			$grab_taxi_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($grab_taxi_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($grab_taxi_post_format == 'quote') {
				if (($quote = grab_taxi_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					grab_taxi_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote'))) {
			grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
				'components' => 'categories,date',
				'counters' => ''
				), $grab_taxi_blog_style[0], $grab_taxi_columns)
			);
		}
		// More button
		if ( $grab_taxi_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'grab-taxi'); ?></a></p><?php
		}

		// Post meta
		grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
				'components' => 'categories,counters',
				'counters' => 'comments,likes',
				'seo' => false
			), 'excerpt', 1)
		);
		?>
	</div><!-- .entry-content -->

</article></div>