<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_blog_style = explode('_', grab_taxi_get_theme_option('blog_style'));
$grab_taxi_columns = empty($grab_taxi_blog_style[1]) ? 1 : max(1, $grab_taxi_blog_style[1]);
$grab_taxi_expanded = !grab_taxi_sidebar_present() && grab_taxi_is_on(grab_taxi_get_theme_option('expand_content'));
$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($grab_taxi_columns).' post_format_'.esc_attr($grab_taxi_post_format) ); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($grab_taxi_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="' . the_title_attribute( array('echo' => false, 'post' => get_the_ID())) . '"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	grab_taxi_show_post_featured( array(
											'class' => $grab_taxi_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => grab_taxi_get_thumb_size(
																	strpos(grab_taxi_get_theme_option('body_style'), 'full')!==false
																		? ( $grab_taxi_columns > 1 ? 'huge' : 'original' )
																		: (	$grab_taxi_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);
	if ( $grab_taxi_columns < 3) {
		$grab_taxi_post_meta = grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
				'components' => 'date',
				'counters' => '',
				'seo' => false,
				'echo' => false
			), $grab_taxi_blog_style[0], $grab_taxi_columns)
		);
	}
	grab_taxi_show_layout($grab_taxi_post_meta);
	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('grab_taxi_action_before_post_title'); 

			// Post title
			if ( $grab_taxi_columns == 1) {
				the_title(sprintf('<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
			} elseif ( $grab_taxi_columns == 2) {
				the_title(sprintf('<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h4>');
			} else {
				the_title(sprintf('<h5 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h5>');
			}

			do_action('grab_taxi_action_before_post_meta');

			// Post meta
			if ( $grab_taxi_columns < 3) {
				$grab_taxi_post_meta = grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
						'components' => 'categories',
						'counters' => '',
						'seo' => false,
						'echo' => false
					), $grab_taxi_blog_style[0], $grab_taxi_columns)
				);
			}
			if ( $grab_taxi_columns > 2) {
				$grab_taxi_post_meta = grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
						'components' => 'categories,date',
						'counters' => '',
						'seo' => false,
						'echo' => false
					), $grab_taxi_blog_style[0], $grab_taxi_columns)
				);
			}
			grab_taxi_show_layout($grab_taxi_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$grab_taxi_show_learn_more = !in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($grab_taxi_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($grab_taxi_post_format == 'quote') {
					if (($quote = grab_taxi_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						grab_taxi_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote'))) {
				grab_taxi_show_layout($grab_taxi_post_meta);
			}
			if ( $grab_taxi_columns < 3) {
				$grab_taxi_post_meta = grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
						'components' => 'counters',
						'counters' => 'comments,likes',
					), $grab_taxi_blog_style[0], $grab_taxi_columns)
				);
				grab_taxi_show_layout($grab_taxi_post_meta);
			}
			// More button
			if ( $grab_taxi_show_learn_more && ($grab_taxi_columns > 2) ) {
				?><div class="read_more">
				<a class="sc_button color_style_default sc_button_default sc_button_size_normal sc_button_icon_right" href="<?php echo esc_url(get_permalink()); ?>"><span class="sc_button_text"><span class="sc_button_title"><?php esc_html_e('Read more', 'grab-taxi'); ?></span></span><!-- /.sc_button_text --></a>
				</div><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>