<?php
defined('ABSPATH') || exit;

if (!class_exists('RT_Admin_Icon')) {
    /**
     * Gostudy RT_Admin_Icon
     *
     *
     * @category Class
     * @package gostudy\core\class
     * @author RaisTheme <help.raistheme@gmail.com>
     * @since 1.0.0
     */
    class RT_Admin_Icon
    {
        private $icons = [];

        private static $instance = null;
        public static function get_instance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        private function __construct()
        {
            $this->load();
        }

        public function load()
        {
            $this->setup_stylesheet_data();

        }

        private function setup_stylesheet_data()
        {
            $this->icons = $this->setup_icon_array();
        }

        private function setup_icon_array()
        {
            $icons = array();

            $icons = $this->get_icon_list();
            $icons = apply_filters('gostudy_icon_list', $icons);

            return $icons;
        }

        /*----------------------------------------------------------------------------*
         * Public Helper Functions
         *----------------------------------------------------------------------------*/
        public function get_icons_name($get_icons_value = false)
        {
            $icons = [];

            if (!empty($this->icons)) {
                foreach ($this->icons as $key => $value) {
                    $icons[$key] = (bool) $get_icons_value ? esc_html($key) : esc_html($value);
                }

                return $icons;
            } else {
                return $icons;
            }

        }

        public function get_icon_list()
        {
            return [
                'fab fa-500px' => esc_html__( '500px', 'gostudy' ),
                'fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'gostudy' ),
                'fab fa-accusoft' => esc_html__( 'accusoft', 'gostudy' ),
                'fas fa-address-book' => esc_html__( 'address-book', 'gostudy' ),
                'far fa-address-book' => esc_html__( 'address-book', 'gostudy' ),
                'fas fa-address-card' => esc_html__( 'address-card', 'gostudy' ),
                'far fa-address-card' => esc_html__( 'address-card', 'gostudy' ),
                'fas fa-adjust' => esc_html__( 'adjust', 'gostudy' ),
                'fab fa-adn' => esc_html__( 'adn', 'gostudy' ),
                'fab fa-adversal' => esc_html__( 'adversal', 'gostudy' ),
                'fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'gostudy' ),
                'fab fa-algolia' => esc_html__( 'algolia', 'gostudy' ),
                'fas fa-align-center' => esc_html__( 'align-center', 'gostudy' ),
                'fas fa-align-justify' => esc_html__( 'align-justify', 'gostudy' ),
                'fas fa-align-left' => esc_html__( 'align-left', 'gostudy' ),
                'fas fa-align-right' => esc_html__( 'align-right', 'gostudy' ),
                'fas fa-allergies' => esc_html__( 'allergies', 'gostudy' ),
                'fab fa-amazon' => esc_html__( 'amazon', 'gostudy' ),
                'fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'gostudy' ),
                'fas fa-ambulance' => esc_html__( 'ambulance', 'gostudy' ),
                'fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'gostudy' ),
                'fab fa-amilia' => esc_html__( 'amilia', 'gostudy' ),
                'fas fa-anchor' => esc_html__( 'anchor', 'gostudy' ),
                'fab fa-android' => esc_html__( 'android', 'gostudy' ),
                'fab fa-angellist' => esc_html__( 'angellist', 'gostudy' ),
                'fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'gostudy' ),
                'fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'gostudy' ),
                'fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'gostudy' ),
                'fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'gostudy' ),
                'fas fa-angle-down' => esc_html__( 'angle-down', 'gostudy' ),
                'fas fa-angle-left' => esc_html__( 'angle-left', 'gostudy' ),
                'fas fa-angle-right' => esc_html__( 'angle-right', 'gostudy' ),
                'fas fa-angle-up' => esc_html__( 'angle-up', 'gostudy' ),
                'fab fa-angrycreative' => esc_html__( 'angrycreative', 'gostudy' ),
                'fab fa-angular' => esc_html__( 'angular', 'gostudy' ),
                'fab fa-app-store' => esc_html__( 'app-store', 'gostudy' ),
                'fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'gostudy' ),
                'fab fa-apper' => esc_html__( 'apper', 'gostudy' ),
                'fab fa-apple' => esc_html__( 'apple', 'gostudy' ),
                'fab fa-apple-pay' => esc_html__( 'apple-pay', 'gostudy' ),
                'fas fa-archive' => esc_html__( 'archive', 'gostudy' ),
                'fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'gostudy' ),
                'far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'gostudy' ),
                'fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'gostudy' ),
                'far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'gostudy' ),
                'fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'gostudy' ),
                'far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'gostudy' ),
                'fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'gostudy' ),
                'far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'gostudy' ),
                'fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'gostudy' ),
                'fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'gostudy' ),
                'fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'gostudy' ),
                'fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'gostudy' ),
                'fas fa-arrow-down' => esc_html__( 'arrow-down', 'gostudy' ),
                'fas fa-arrow-left' => esc_html__( 'arrow-left', 'gostudy' ),
                'fas fa-arrow-right' => esc_html__( 'arrow-right', 'gostudy' ),
                'fas fa-arrow-up' => esc_html__( 'arrow-up', 'gostudy' ),
                'fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'gostudy' ),
                'fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'gostudy' ),
                'fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'gostudy' ),
                'fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'gostudy' ),
                'fas fa-asterisk' => esc_html__( 'asterisk', 'gostudy' ),
                'fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'gostudy' ),
                'fas fa-at' => esc_html__( 'at', 'gostudy' ),
                'fab fa-audible' => esc_html__( 'audible', 'gostudy' ),
                'fas fa-audio-description' => esc_html__( 'audio-description', 'gostudy' ),
                'fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'gostudy' ),
                'fab fa-avianex' => esc_html__( 'avianex', 'gostudy' ),
                'fab fa-aviato' => esc_html__( 'aviato', 'gostudy' ),
                'fab fa-aws' => esc_html__( 'aws', 'gostudy' ),
                'fas fa-backward' => esc_html__( 'backward', 'gostudy' ),
                'fas fa-balance-scale' => esc_html__( 'balance-scale', 'gostudy' ),
                'fas fa-ban' => esc_html__( 'ban', 'gostudy' ),
                'fas fa-band-aid' => esc_html__( 'band-aid', 'gostudy' ),
                'fab fa-bandcamp' => esc_html__( 'bandcamp', 'gostudy' ),
                'fas fa-barcode' => esc_html__( 'barcode', 'gostudy' ),
                'fas fa-bars' => esc_html__( 'bars', 'gostudy' ),
                'fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'gostudy' ),
                'fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'gostudy' ),
                'fas fa-bath' => esc_html__( 'bath', 'gostudy' ),
                'fas fa-battery-empty' => esc_html__( 'battery-empty', 'gostudy' ),
                'fas fa-battery-full' => esc_html__( 'battery-full', 'gostudy' ),
                'fas fa-battery-half' => esc_html__( 'battery-half', 'gostudy' ),
                'fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'gostudy' ),
                'fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'gostudy' ),
                'fas fa-bed' => esc_html__( 'bed', 'gostudy' ),
                'fas fa-beer' => esc_html__( 'beer', 'gostudy' ),
                'fab fa-behance' => esc_html__( 'behance', 'gostudy' ),
                'fab fa-behance-square' => esc_html__( 'behance-square', 'gostudy' ),
                'fas fa-bell' => esc_html__( 'bell', 'gostudy' ),
                'far fa-bell' => esc_html__( 'bell', 'gostudy' ),
                'fas fa-bell-slash' => esc_html__( 'bell-slash', 'gostudy' ),
                'far fa-bell-slash' => esc_html__( 'bell-slash', 'gostudy' ),
                'fas fa-bicycle' => esc_html__( 'bicycle', 'gostudy' ),
                'fab fa-bimobject' => esc_html__( 'bimobject', 'gostudy' ),
                'fas fa-binoculars' => esc_html__( 'binoculars', 'gostudy' ),
                'fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'gostudy' ),
                'fab fa-bitbucket' => esc_html__( 'bitbucket', 'gostudy' ),
                'fab fa-bitcoin' => esc_html__( 'bitcoin', 'gostudy' ),
                'fab fa-bity' => esc_html__( 'bity', 'gostudy' ),
                'fab fa-black-tie' => esc_html__( 'black-tie', 'gostudy' ),
                'fab fa-blackberry' => esc_html__( 'blackberry', 'gostudy' ),
                'fas fa-blind' => esc_html__( 'blind', 'gostudy' ),
                'fab fa-blogger' => esc_html__( 'blogger', 'gostudy' ),
                'fab fa-blogger-b' => esc_html__( 'blogger-b', 'gostudy' ),
                'fab fa-bluetooth' => esc_html__( 'bluetooth', 'gostudy' ),
                'fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'gostudy' ),
                'fas fa-bold' => esc_html__( 'bold', 'gostudy' ),
                'fas fa-bolt' => esc_html__( 'bolt', 'gostudy' ),
                'fas fa-bomb' => esc_html__( 'bomb', 'gostudy' ),
                'fas fa-book' => esc_html__( 'book', 'gostudy' ),
                'fas fa-bookmark' => esc_html__( 'bookmark', 'gostudy' ),
                'far fa-bookmark' => esc_html__( 'bookmark', 'gostudy' ),
                'fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'gostudy' ),
                'fas fa-box' => esc_html__( 'box', 'gostudy' ),
                'fas fa-box-open' => esc_html__( 'box-open', 'gostudy' ),
                'fas fa-boxes' => esc_html__( 'boxes', 'gostudy' ),
                'fas fa-braille' => esc_html__( 'braille', 'gostudy' ),
                'fas fa-briefcase' => esc_html__( 'briefcase', 'gostudy' ),
                'fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'gostudy' ),
                'fab fa-btc' => esc_html__( 'btc', 'gostudy' ),
                'fas fa-bug' => esc_html__( 'bug', 'gostudy' ),
                'fas fa-building' => esc_html__( 'building', 'gostudy' ),
                'far fa-building' => esc_html__( 'building', 'gostudy' ),
                'fas fa-bullhorn' => esc_html__( 'bullhorn', 'gostudy' ),
                'fas fa-bullseye' => esc_html__( 'bullseye', 'gostudy' ),
                'fas fa-burn' => esc_html__( 'burn', 'gostudy' ),
                'fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'gostudy' ),
                'fas fa-bus' => esc_html__( 'bus', 'gostudy' ),
                'fab fa-buysellads' => esc_html__( 'buysellads', 'gostudy' ),
                'fas fa-calculator' => esc_html__( 'calculator', 'gostudy' ),
                'fas fa-calendar' => esc_html__( 'calendar', 'gostudy' ),
                'far fa-calendar' => esc_html__( 'calendar', 'gostudy' ),
                'fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'gostudy' ),
                'far fa-calendar-alt' => esc_html__( 'calendar-alt', 'gostudy' ),
                'fas fa-calendar-check' => esc_html__( 'calendar-check', 'gostudy' ),
                'far fa-calendar-check' => esc_html__( 'calendar-check', 'gostudy' ),
                'fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'gostudy' ),
                'far fa-calendar-minus' => esc_html__( 'calendar-minus', 'gostudy' ),
                'fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'gostudy' ),
                'far fa-calendar-plus' => esc_html__( 'calendar-plus', 'gostudy' ),
                'fas fa-calendar-times' => esc_html__( 'calendar-times', 'gostudy' ),
                'far fa-calendar-times' => esc_html__( 'calendar-times', 'gostudy' ),
                'fas fa-camera' => esc_html__( 'camera', 'gostudy' ),
                'fas fa-camera-retro' => esc_html__( 'camera-retro', 'gostudy' ),
                'fas fa-capsules' => esc_html__( 'capsules', 'gostudy' ),
                'fas fa-car' => esc_html__( 'car', 'gostudy' ),
                'fas fa-caret-down' => esc_html__( 'caret-down', 'gostudy' ),
                'fas fa-caret-left' => esc_html__( 'caret-left', 'gostudy' ),
                'fas fa-caret-right' => esc_html__( 'caret-right', 'gostudy' ),
                'fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'gostudy' ),
                'far fa-caret-square-down' => esc_html__( 'caret-square-down', 'gostudy' ),
                'fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'gostudy' ),
                'far fa-caret-square-left' => esc_html__( 'caret-square-left', 'gostudy' ),
                'fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'gostudy' ),
                'far fa-caret-square-right' => esc_html__( 'caret-square-right', 'gostudy' ),
                'fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'gostudy' ),
                'far fa-caret-square-up' => esc_html__( 'caret-square-up', 'gostudy' ),
                'fas fa-caret-up' => esc_html__( 'caret-up', 'gostudy' ),
                'fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'gostudy' ),
                'fas fa-cart-plus' => esc_html__( 'cart-plus', 'gostudy' ),
                'fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'gostudy' ),
                'fab fa-cc-amex' => esc_html__( 'cc-amex', 'gostudy' ),
                'fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'gostudy' ),
                'fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'gostudy' ),
                'fab fa-cc-discover' => esc_html__( 'cc-discover', 'gostudy' ),
                'fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'gostudy' ),
                'fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'gostudy' ),
                'fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'gostudy' ),
                'fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'gostudy' ),
                'fab fa-cc-visa' => esc_html__( 'cc-visa', 'gostudy' ),
                'fab fa-centercode' => esc_html__( 'centercode', 'gostudy' ),
                'fas fa-certificate' => esc_html__( 'certificate', 'gostudy' ),
                'fas fa-chart-area' => esc_html__( 'chart-area', 'gostudy' ),
                'fas fa-chart-bar' => esc_html__( 'chart-bar', 'gostudy' ),
                'far fa-chart-bar' => esc_html__( 'chart-bar', 'gostudy' ),
                'fas fa-chart-line' => esc_html__( 'chart-line', 'gostudy' ),
                'fas fa-chart-pie' => esc_html__( 'chart-pie', 'gostudy' ),
                'fas fa-check' => esc_html__( 'check', 'gostudy' ),
                'fas fa-check-circle' => esc_html__( 'check-circle', 'gostudy' ),
                'far fa-check-circle' => esc_html__( 'check-circle', 'gostudy' ),
                'fas fa-check-square' => esc_html__( 'check-square', 'gostudy' ),
                'far fa-check-square' => esc_html__( 'check-square', 'gostudy' ),
                'fas fa-chess' => esc_html__( 'chess', 'gostudy' ),
                'fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'gostudy' ),
                'fas fa-chess-board' => esc_html__( 'chess-board', 'gostudy' ),
                'fas fa-chess-king' => esc_html__( 'chess-king', 'gostudy' ),
                'fas fa-chess-knight' => esc_html__( 'chess-knight', 'gostudy' ),
                'fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'gostudy' ),
                'fas fa-chess-queen' => esc_html__( 'chess-queen', 'gostudy' ),
                'fas fa-chess-rook' => esc_html__( 'chess-rook', 'gostudy' ),
                'fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'gostudy' ),
                'fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'gostudy' ),
                'fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'gostudy' ),
                'fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'gostudy' ),
                'fas fa-chevron-down' => esc_html__( 'chevron-down', 'gostudy' ),
                'fas fa-chevron-left' => esc_html__( 'chevron-left', 'gostudy' ),
                'fas fa-chevron-right' => esc_html__( 'chevron-right', 'gostudy' ),
                'fas fa-chevron-up' => esc_html__( 'chevron-up', 'gostudy' ),
                'fas fa-child' => esc_html__( 'child', 'gostudy' ),
                'fab fa-chrome' => esc_html__( 'chrome', 'gostudy' ),
                'fas fa-circle' => esc_html__( 'circle', 'gostudy' ),
                'far fa-circle' => esc_html__( 'circle', 'gostudy' ),
                'fas fa-circle-notch' => esc_html__( 'circle-notch', 'gostudy' ),
                'fas fa-clipboard' => esc_html__( 'clipboard', 'gostudy' ),
                'far fa-clipboard' => esc_html__( 'clipboard', 'gostudy' ),
                'fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'gostudy' ),
                'fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'gostudy' ),
                'fas fa-clock' => esc_html__( 'clock', 'gostudy' ),
                'far fa-clock' => esc_html__( 'clock', 'gostudy' ),
                'fas fa-clone' => esc_html__( 'clone', 'gostudy' ),
                'far fa-clone' => esc_html__( 'clone', 'gostudy' ),
                'fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'gostudy' ),
                'far fa-closed-captioning' => esc_html__( 'closed-captioning', 'gostudy' ),
                'fas fa-cloud' => esc_html__( 'cloud', 'gostudy' ),
                'fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'gostudy' ),
                'fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'gostudy' ),
                'fab fa-cloudscale' => esc_html__( 'cloudscale', 'gostudy' ),
                'fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'gostudy' ),
                'fab fa-cloudversify' => esc_html__( 'cloudversify', 'gostudy' ),
                'fas fa-code' => esc_html__( 'code', 'gostudy' ),
                'fas fa-code-branch' => esc_html__( 'code-branch', 'gostudy' ),
                'fab fa-codepen' => esc_html__( 'codepen', 'gostudy' ),
                'fab fa-codiepie' => esc_html__( 'codiepie', 'gostudy' ),
                'fas fa-coffee' => esc_html__( 'coffee', 'gostudy' ),
                'fas fa-cog' => esc_html__( 'cog', 'gostudy' ),
                'fas fa-cogs' => esc_html__( 'cogs', 'gostudy' ),
                'fas fa-columns' => esc_html__( 'columns', 'gostudy' ),
                'fas fa-comment' => esc_html__( 'comment', 'gostudy' ),
                'far fa-comment' => esc_html__( 'comment', 'gostudy' ),
                'fas fa-comment-alt' => esc_html__( 'comment-alt', 'gostudy' ),
                'far fa-comment-alt' => esc_html__( 'comment-alt', 'gostudy' ),
                'fas fa-comment-dots' => esc_html__( 'comment-dots', 'gostudy' ),
                'fas fa-comment-slash' => esc_html__( 'comment-slash', 'gostudy' ),
                'fas fa-comments' => esc_html__( 'comments', 'gostudy' ),
                'far fa-comments' => esc_html__( 'comments', 'gostudy' ),
                'fas fa-compass' => esc_html__( 'compass', 'gostudy' ),
                'far fa-compass' => esc_html__( 'compass', 'gostudy' ),
                'fas fa-compress' => esc_html__( 'compress', 'gostudy' ),
                'fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'gostudy' ),
                'fab fa-contao' => esc_html__( 'contao', 'gostudy' ),
                'fas fa-copy' => esc_html__( 'copy', 'gostudy' ),
                'far fa-copy' => esc_html__( 'copy', 'gostudy' ),
                'fas fa-copyright' => esc_html__( 'copyright', 'gostudy' ),
                'far fa-copyright' => esc_html__( 'copyright', 'gostudy' ),
                'fas fa-couch' => esc_html__( 'couch', 'gostudy' ),
                'fab fa-cpanel' => esc_html__( 'cpanel', 'gostudy' ),
                'fab fa-creative-commons' => esc_html__( 'creative-commons', 'gostudy' ),
                'fas fa-credit-card' => esc_html__( 'credit-card', 'gostudy' ),
                'far fa-credit-card' => esc_html__( 'credit-card', 'gostudy' ),
                'fas fa-crop' => esc_html__( 'crop', 'gostudy' ),
                'fas fa-crosshairs' => esc_html__( 'crosshairs', 'gostudy' ),
                'fab fa-css3' => esc_html__( 'css3', 'gostudy' ),
                'fab fa-css3-alt' => esc_html__( 'css3-alt', 'gostudy' ),
                'fas fa-cube' => esc_html__( 'cube', 'gostudy' ),
                'fas fa-cubes' => esc_html__( 'cubes', 'gostudy' ),
                'fas fa-cut' => esc_html__( 'cut', 'gostudy' ),
                'fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'gostudy' ),
                'fab fa-d-and-d' => esc_html__( 'd-and-d', 'gostudy' ),
                'fab fa-dashcube' => esc_html__( 'dashcube', 'gostudy' ),
                'fas fa-database' => esc_html__( 'database', 'gostudy' ),
                'fas fa-deaf' => esc_html__( 'deaf', 'gostudy' ),
                'fab fa-delicious' => esc_html__( 'delicious', 'gostudy' ),
                'fab fa-deploydog' => esc_html__( 'deploydog', 'gostudy' ),
                'fab fa-deskpro' => esc_html__( 'deskpro', 'gostudy' ),
                'fas fa-desktop' => esc_html__( 'desktop', 'gostudy' ),
                'fab fa-deviantart' => esc_html__( 'deviantart', 'gostudy' ),
                'fas fa-diagnoses' => esc_html__( 'diagnoses', 'gostudy' ),
                'fab fa-digg' => esc_html__( 'digg', 'gostudy' ),
                'fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'gostudy' ),
                'fab fa-discord' => esc_html__( 'discord', 'gostudy' ),
                'fab fa-discourse' => esc_html__( 'discourse', 'gostudy' ),
                'fas fa-dna' => esc_html__( 'dna', 'gostudy' ),
                'fab fa-dochub' => esc_html__( 'dochub', 'gostudy' ),
                'fab fa-docker' => esc_html__( 'docker', 'gostudy' ),
                'fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'gostudy' ),
                'fas fa-dolly' => esc_html__( 'dolly', 'gostudy' ),
                'fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'gostudy' ),
                'fas fa-donate' => esc_html__( 'donate', 'gostudy' ),
                'fas fa-dot-circle' => esc_html__( 'dot-circle', 'gostudy' ),
                'far fa-dot-circle' => esc_html__( 'dot-circle', 'gostudy' ),
                'fas fa-dove' => esc_html__( 'dove', 'gostudy' ),
                'fas fa-download' => esc_html__( 'download', 'gostudy' ),
                'fab fa-draft2digital' => esc_html__( 'draft2digital', 'gostudy' ),
                'fab fa-dribbble' => esc_html__( 'dribbble', 'gostudy' ),
                'fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'gostudy' ),
                'fab fa-dropbox' => esc_html__( 'dropbox', 'gostudy' ),
                'fab fa-drupal' => esc_html__( 'drupal', 'gostudy' ),
                'fab fa-dyalog' => esc_html__( 'dyalog', 'gostudy' ),
                'fab fa-earlybirds' => esc_html__( 'earlybirds', 'gostudy' ),
                'fab fa-edge' => esc_html__( 'edge', 'gostudy' ),
                'fas fa-edit' => esc_html__( 'edit', 'gostudy' ),
                'far fa-edit' => esc_html__( 'edit', 'gostudy' ),
                'fas fa-eject' => esc_html__( 'eject', 'gostudy' ),
                'fab fa-elementor' => esc_html__( 'elementor', 'gostudy' ),
                'fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'gostudy' ),
                'fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'gostudy' ),
                'fab fa-ember' => esc_html__( 'ember', 'gostudy' ),
                'fab fa-empire' => esc_html__( 'empire', 'gostudy' ),
                'fas fa-envelope' => esc_html__( 'envelope', 'gostudy' ),
                'far fa-envelope' => esc_html__( 'envelope', 'gostudy' ),
                'fas fa-envelope-open' => esc_html__( 'envelope-open', 'gostudy' ),
                'far fa-envelope-open' => esc_html__( 'envelope-open', 'gostudy' ),
                'fas fa-envelope-square' => esc_html__( 'envelope-square', 'gostudy' ),
                'fab fa-envira' => esc_html__( 'envira', 'gostudy' ),
                'fas fa-eraser' => esc_html__( 'eraser', 'gostudy' ),
                'fab fa-erlang' => esc_html__( 'erlang', 'gostudy' ),
                'fab fa-ethereum' => esc_html__( 'ethereum', 'gostudy' ),
                'fab fa-etsy' => esc_html__( 'etsy', 'gostudy' ),
                'fas fa-euro-sign' => esc_html__( 'euro-sign', 'gostudy' ),
                'fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'gostudy' ),
                'fas fa-exclamation' => esc_html__( 'exclamation', 'gostudy' ),
                'fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'gostudy' ),
                'fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'gostudy' ),
                'fas fa-expand' => esc_html__( 'expand', 'gostudy' ),
                'fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'gostudy' ),
                'fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'gostudy' ),
                'fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'gostudy' ),
                'fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'gostudy' ),
                'fas fa-eye' => esc_html__( 'eye', 'gostudy' ),
                'fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'gostudy' ),
                'fas fa-eye-slash' => esc_html__( 'eye-slash', 'gostudy' ),
                'far fa-eye-slash' => esc_html__( 'eye-slash', 'gostudy' ),
                'fab fa-facebook' => esc_html__( 'facebook', 'gostudy' ),
                'fab fa-facebook-f' => esc_html__( 'facebook-f', 'gostudy' ),
                'fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'gostudy' ),
                'fab fa-facebook-square' => esc_html__( 'facebook-square', 'gostudy' ),
                'fas fa-fast-backward' => esc_html__( 'fast-backward', 'gostudy' ),
                'fas fa-fast-forward' => esc_html__( 'fast-forward', 'gostudy' ),
                'fas fa-fax' => esc_html__( 'fax', 'gostudy' ),
                'fas fa-female' => esc_html__( 'female', 'gostudy' ),
                'fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'gostudy' ),
                'fas fa-file' => esc_html__( 'file', 'gostudy' ),
                'far fa-file' => esc_html__( 'file', 'gostudy' ),
                'fas fa-file-alt' => esc_html__( 'file-alt', 'gostudy' ),
                'far fa-file-alt' => esc_html__( 'file-alt', 'gostudy' ),
                'fas fa-file-archive' => esc_html__( 'file-archive', 'gostudy' ),
                'far fa-file-archive' => esc_html__( 'file-archive', 'gostudy' ),
                'fas fa-file-audio' => esc_html__( 'file-audio', 'gostudy' ),
                'far fa-file-audio' => esc_html__( 'file-audio', 'gostudy' ),
                'fas fa-file-code' => esc_html__( 'file-code', 'gostudy' ),
                'far fa-file-code' => esc_html__( 'file-code', 'gostudy' ),
                'fas fa-file-excel' => esc_html__( 'file-excel', 'gostudy' ),
                'far fa-file-excel' => esc_html__( 'file-excel', 'gostudy' ),
                'fas fa-file-image' => esc_html__( 'file-image', 'gostudy' ),
                'far fa-file-image' => esc_html__( 'file-image', 'gostudy' ),
                'fas fa-file-medical' => esc_html__( 'file-medical', 'gostudy' ),
                'fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'gostudy' ),
                'fas fa-file-pdf' => esc_html__( 'file-pdf', 'gostudy' ),
                'far fa-file-pdf' => esc_html__( 'file-pdf', 'gostudy' ),
                'fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'gostudy' ),
                'far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'gostudy' ),
                'fas fa-file-video' => esc_html__( 'file-video', 'gostudy' ),
                'far fa-file-video' => esc_html__( 'file-video', 'gostudy' ),
                'fas fa-file-word' => esc_html__( 'file-word', 'gostudy' ),
                'far fa-file-word' => esc_html__( 'file-word', 'gostudy' ),
                'fas fa-film' => esc_html__( 'film', 'gostudy' ),
                'fas fa-filter' => esc_html__( 'filter', 'gostudy' ),
                'fas fa-fire' => esc_html__( 'fire', 'gostudy' ),
                'fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'gostudy' ),
                'fab fa-firefox' => esc_html__( 'firefox', 'gostudy' ),
                'fas fa-first-aid' => esc_html__( 'first-aid', 'gostudy' ),
                'fab fa-first-order' => esc_html__( 'first-order', 'gostudy' ),
                'fab fa-firstdraft' => esc_html__( 'firstdraft', 'gostudy' ),
                'fas fa-flag' => esc_html__( 'flag', 'gostudy' ),
                'far fa-flag' => esc_html__( 'flag', 'gostudy' ),
                'fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'gostudy' ),
                'fas fa-flask' => esc_html__( 'flask', 'gostudy' ),
                'fab fa-flickr' => esc_html__( 'flickr', 'gostudy' ),
                'fab fa-flipboard' => esc_html__( 'flipboard', 'gostudy' ),
                'fab fa-fly' => esc_html__( 'fly', 'gostudy' ),
                'fas fa-folder' => esc_html__( 'folder', 'gostudy' ),
                'far fa-folder' => esc_html__( 'folder', 'gostudy' ),
                'fas fa-folder-open' => esc_html__( 'folder-open', 'gostudy' ),
                'far fa-folder-open' => esc_html__( 'folder-open', 'gostudy' ),
                'fas fa-font' => esc_html__( 'font', 'gostudy' ),
                'fab fa-font-awesome' => esc_html__( 'font-awesome', 'gostudy' ),
                'fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'gostudy' ),
                'fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'gostudy' ),
                'fab fa-fonticons' => esc_html__( 'fonticons', 'gostudy' ),
                'fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'gostudy' ),
                'fas fa-football-ball' => esc_html__( 'football-ball', 'gostudy' ),
                'fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'gostudy' ),
                'fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'gostudy' ),
                'fab fa-forumbee' => esc_html__( 'forumbee', 'gostudy' ),
                'fas fa-forward' => esc_html__( 'forward', 'gostudy' ),
                'fab fa-foursquare' => esc_html__( 'foursquare', 'gostudy' ),
                'fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'gostudy' ),
                'fab fa-freebsd' => esc_html__( 'freebsd', 'gostudy' ),
                'fas fa-frown' => esc_html__( 'frown', 'gostudy' ),
                'far fa-frown' => esc_html__( 'frown', 'gostudy' ),
                'fas fa-futbol' => esc_html__( 'futbol', 'gostudy' ),
                'far fa-futbol' => esc_html__( 'futbol', 'gostudy' ),
                'fas fa-gamepad' => esc_html__( 'gamepad', 'gostudy' ),
                'fas fa-gavel' => esc_html__( 'gavel', 'gostudy' ),
                'fas fa-gem' => esc_html__( 'gem', 'gostudy' ),
                'far fa-gem' => esc_html__( 'gem', 'gostudy' ),
                'fas fa-genderless' => esc_html__( 'genderless', 'gostudy' ),
                'fab fa-get-pocket' => esc_html__( 'get-pocket', 'gostudy' ),
                'fab fa-gg' => esc_html__( 'gg', 'gostudy' ),
                'fab fa-gg-circle' => esc_html__( 'gg-circle', 'gostudy' ),
                'fas fa-gift' => esc_html__( 'gift', 'gostudy' ),
                'fab fa-git' => esc_html__( 'git', 'gostudy' ),
                'fab fa-git-square' => esc_html__( 'git-square', 'gostudy' ),
                'fab fa-github' => esc_html__( 'github', 'gostudy' ),
                'fab fa-github-alt' => esc_html__( 'github-alt', 'gostudy' ),
                'fab fa-github-square' => esc_html__( 'github-square', 'gostudy' ),
                'fab fa-gitkraken' => esc_html__( 'gitkraken', 'gostudy' ),
                'fab fa-gitlab' => esc_html__( 'gitlab', 'gostudy' ),
                'fab fa-gitter' => esc_html__( 'gitter', 'gostudy' ),
                'fas fa-glass-martini' => esc_html__( 'glass-martini', 'gostudy' ),
                'fab fa-glide' => esc_html__( 'glide', 'gostudy' ),
                'fab fa-glide-g' => esc_html__( 'glide-g', 'gostudy' ),
                'fas fa-globe' => esc_html__( 'globe', 'gostudy' ),
                'fab fa-gofore' => esc_html__( 'gofore', 'gostudy' ),
                'fas fa-golf-ball' => esc_html__( 'golf-ball', 'gostudy' ),
                'fab fa-goodreads' => esc_html__( 'goodreads', 'gostudy' ),
                'fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'gostudy' ),
                'fab fa-google' => esc_html__( 'google', 'gostudy' ),
                'fab fa-google-drive' => esc_html__( 'google-drive', 'gostudy' ),
                'fab fa-google-play' => esc_html__( 'google-play', 'gostudy' ),
                'fab fa-google-plus' => esc_html__( 'google-plus', 'gostudy' ),
                'fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'gostudy' ),
                'fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'gostudy' ),
                'fab fa-google-wallet' => esc_html__( 'google-wallet', 'gostudy' ),
                'fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'gostudy' ),
                'fab fa-gratipay' => esc_html__( 'gratipay', 'gostudy' ),
                'fab fa-grav' => esc_html__( 'grav', 'gostudy' ),
                'fab fa-gripfire' => esc_html__( 'gripfire', 'gostudy' ),
                'fab fa-grunt' => esc_html__( 'grunt', 'gostudy' ),
                'fab fa-gulp' => esc_html__( 'gulp', 'gostudy' ),
                'fas fa-h-square' => esc_html__( 'h-square', 'gostudy' ),
                'fab fa-hacker-news' => esc_html__( 'hacker-news', 'gostudy' ),
                'fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'gostudy' ),
                'fas fa-hand-holding' => esc_html__( 'hand-holding', 'gostudy' ),
                'fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'gostudy' ),
                'fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'gostudy' ),
                'fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'gostudy' ),
                'far fa-hand-lizard' => esc_html__( 'hand-lizard', 'gostudy' ),
                'fas fa-hand-paper' => esc_html__( 'hand-paper', 'gostudy' ),
                'far fa-hand-paper' => esc_html__( 'hand-paper', 'gostudy' ),
                'fas fa-hand-peace' => esc_html__( 'hand-peace', 'gostudy' ),
                'far fa-hand-peace' => esc_html__( 'hand-peace', 'gostudy' ),
                'fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'gostudy' ),
                'far fa-hand-point-down' => esc_html__( 'hand-point-down', 'gostudy' ),
                'fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'gostudy' ),
                'far fa-hand-point-left' => esc_html__( 'hand-point-left', 'gostudy' ),
                'fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'gostudy' ),
                'far fa-hand-point-right' => esc_html__( 'hand-point-right', 'gostudy' ),
                'fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'gostudy' ),
                'far fa-hand-point-up' => esc_html__( 'hand-point-up', 'gostudy' ),
                'fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'gostudy' ),
                'far fa-hand-pointer' => esc_html__( 'hand-pointer', 'gostudy' ),
                'fas fa-hand-rock' => esc_html__( 'hand-rock', 'gostudy' ),
                'far fa-hand-rock' => esc_html__( 'hand-rock', 'gostudy' ),
                'fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'gostudy' ),
                'far fa-hand-scissors' => esc_html__( 'hand-scissors', 'gostudy' ),
                'fas fa-hand-spock' => esc_html__( 'hand-spock', 'gostudy' ),
                'far fa-hand-spock' => esc_html__( 'hand-spock', 'gostudy' ),
                'fas fa-hands' => esc_html__( 'hands', 'gostudy' ),
                'fas fa-hands-helping' => esc_html__( 'hands-helping', 'gostudy' ),
                'fas fa-handshake' => esc_html__( 'handshake', 'gostudy' ),
                'far fa-handshake' => esc_html__( 'handshake', 'gostudy' ),
                'fas fa-hashtag' => esc_html__( 'hashtag', 'gostudy' ),
                'fas fa-hdd' => esc_html__( 'hdd', 'gostudy' ),
                'far fa-hdd' => esc_html__( 'hdd', 'gostudy' ),
                'fas fa-heading' => esc_html__( 'heading', 'gostudy' ),
                'fas fa-headphones' => esc_html__( 'headphones', 'gostudy' ),
                'fas fa-heart' => esc_html__( 'heart', 'gostudy' ),
                'far fa-heart' => esc_html__( 'heart', 'gostudy' ),
                'fas fa-heartbeat' => esc_html__( 'heartbeat', 'gostudy' ),
                'fab fa-hips' => esc_html__( 'hips', 'gostudy' ),
                'fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'gostudy' ),
                'fas fa-history' => esc_html__( 'history', 'gostudy' ),
                'fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'gostudy' ),
                'fas fa-home' => esc_html__( 'home', 'gostudy' ),
                'fab fa-hooli' => esc_html__( 'hooli', 'gostudy' ),
                'fas fa-hospital' => esc_html__( 'hospital', 'gostudy' ),
                'far fa-hospital' => esc_html__( 'hospital', 'gostudy' ),
                'fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'gostudy' ),
                'fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'gostudy' ),
                'fab fa-hotjar' => esc_html__( 'hotjar', 'gostudy' ),
                'fas fa-hourglass' => esc_html__( 'hourglass', 'gostudy' ),
                'far fa-hourglass' => esc_html__( 'hourglass', 'gostudy' ),
                'fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'gostudy' ),
                'fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'gostudy' ),
                'fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'gostudy' ),
                'fab fa-houzz' => esc_html__( 'houzz', 'gostudy' ),
                'fab fa-html5' => esc_html__( 'html5', 'gostudy' ),
                'fab fa-hubspot' => esc_html__( 'hubspot', 'gostudy' ),
                'fas fa-i-cursor' => esc_html__( 'i-cursor', 'gostudy' ),
                'fas fa-id-badge' => esc_html__( 'id-badge', 'gostudy' ),
                'far fa-id-badge' => esc_html__( 'id-badge', 'gostudy' ),
                'fas fa-id-card' => esc_html__( 'id-card', 'gostudy' ),
                'far fa-id-card' => esc_html__( 'id-card', 'gostudy' ),
                'fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'gostudy' ),
                'fas fa-image' => esc_html__( 'image', 'gostudy' ),
                'far fa-image' => esc_html__( 'image', 'gostudy' ),
                'fas fa-images' => esc_html__( 'images', 'gostudy' ),
                'far fa-images' => esc_html__( 'images', 'gostudy' ),
                'fab fa-imdb' => esc_html__( 'imdb', 'gostudy' ),
                'fas fa-inbox' => esc_html__( 'inbox', 'gostudy' ),
                'fas fa-indent' => esc_html__( 'indent', 'gostudy' ),
                'fas fa-industry' => esc_html__( 'industry', 'gostudy' ),
                'fas fa-info' => esc_html__( 'info', 'gostudy' ),
                'fas fa-info-circle' => esc_html__( 'info-circle', 'gostudy' ),
                'fab fa-instagram' => esc_html__( 'instagram', 'gostudy' ),
                'fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'gostudy' ),
                'fab fa-ioxhost' => esc_html__( 'ioxhost', 'gostudy' ),
                'fas fa-italic' => esc_html__( 'italic', 'gostudy' ),
                'fab fa-itunes' => esc_html__( 'itunes', 'gostudy' ),
                'fab fa-itunes-note' => esc_html__( 'itunes-note', 'gostudy' ),
                'fab fa-java' => esc_html__( 'java', 'gostudy' ),
                'fab fa-jenkins' => esc_html__( 'jenkins', 'gostudy' ),
                'fab fa-joget' => esc_html__( 'joget', 'gostudy' ),
                'fab fa-joomla' => esc_html__( 'joomla', 'gostudy' ),
                'fab fa-js' => esc_html__( 'js', 'gostudy' ),
                'fab fa-js-square' => esc_html__( 'js-square', 'gostudy' ),
                'fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'gostudy' ),
                'fas fa-key' => esc_html__( 'key', 'gostudy' ),
                'fas fa-keyboard' => esc_html__( 'keyboard', 'gostudy' ),
                'far fa-keyboard' => esc_html__( 'keyboard', 'gostudy' ),
                'fab fa-keycdn' => esc_html__( 'keycdn', 'gostudy' ),
                'fab fa-kickstarter' => esc_html__( 'kickstarter', 'gostudy' ),
                'fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'gostudy' ),
                'fab fa-korvue' => esc_html__( 'korvue', 'gostudy' ),
                'fas fa-language' => esc_html__( 'language', 'gostudy' ),
                'fas fa-laptop' => esc_html__( 'laptop', 'gostudy' ),
                'fab fa-laravel' => esc_html__( 'laravel', 'gostudy' ),
                'fab fa-lastfm' => esc_html__( 'lastfm', 'gostudy' ),
                'fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'gostudy' ),
                'fas fa-leaf' => esc_html__( 'leaf', 'gostudy' ),
                'fab fa-leanpub' => esc_html__( 'leanpub', 'gostudy' ),
                'fas fa-lemon' => esc_html__( 'lemon', 'gostudy' ),
                'far fa-lemon' => esc_html__( 'lemon', 'gostudy' ),
                'fab fa-less' => esc_html__( 'less', 'gostudy' ),
                'fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'gostudy' ),
                'fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'gostudy' ),
                'fas fa-life-ring' => esc_html__( 'life-ring', 'gostudy' ),
                'far fa-life-ring' => esc_html__( 'life-ring', 'gostudy' ),
                'fas fa-lightbulb' => esc_html__( 'lightbulb', 'gostudy' ),
                'far fa-lightbulb' => esc_html__( 'lightbulb', 'gostudy' ),
                'fab fa-line' => esc_html__( 'line', 'gostudy' ),
                'fas fa-link' => esc_html__( 'link', 'gostudy' ),
                'fab fa-linkedin' => esc_html__( 'linkedin', 'gostudy' ),
                'fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'gostudy' ),
                'fab fa-linode' => esc_html__( 'linode', 'gostudy' ),
                'fab fa-linux' => esc_html__( 'linux', 'gostudy' ),
                'fas fa-lira-sign' => esc_html__( 'lira-sign', 'gostudy' ),
                'fas fa-list' => esc_html__( 'list', 'gostudy' ),
                'fas fa-list-alt' => esc_html__( 'list-alt', 'gostudy' ),
                'far fa-list-alt' => esc_html__( 'list-alt', 'gostudy' ),
                'fas fa-list-ol' => esc_html__( 'list-ol', 'gostudy' ),
                'fas fa-list-ul' => esc_html__( 'list-ul', 'gostudy' ),
                'fas fa-location-arrow' => esc_html__( 'location-arrow', 'gostudy' ),
                'fas fa-lock' => esc_html__( 'lock', 'gostudy' ),
                'fas fa-lock-open' => esc_html__( 'lock-open', 'gostudy' ),
                'fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'gostudy' ),
                'fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'gostudy' ),
                'fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'gostudy' ),
                'fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'gostudy' ),
                'fas fa-low-vision' => esc_html__( 'low-vision', 'gostudy' ),
                'fab fa-lyft' => esc_html__( 'lyft', 'gostudy' ),
                'fab fa-magento' => esc_html__( 'magento', 'gostudy' ),
                'fas fa-magic' => esc_html__( 'magic', 'gostudy' ),
                'fas fa-magnet' => esc_html__( 'magnet', 'gostudy' ),
                'fas fa-male' => esc_html__( 'male', 'gostudy' ),
                'fas fa-map' => esc_html__( 'map', 'gostudy' ),
                'far fa-map' => esc_html__( 'map', 'gostudy' ),
                'fas fa-map-marker' => esc_html__( 'map-marker', 'gostudy' ),
                'fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'gostudy' ),
                'fas fa-map-pin' => esc_html__( 'map-pin', 'gostudy' ),
                'fas fa-map-signs' => esc_html__( 'map-signs', 'gostudy' ),
                'fas fa-mars' => esc_html__( 'mars', 'gostudy' ),
                'fas fa-mars-double' => esc_html__( 'mars-double', 'gostudy' ),
                'fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'gostudy' ),
                'fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'gostudy' ),
                'fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'gostudy' ),
                'fab fa-maxcdn' => esc_html__( 'maxcdn', 'gostudy' ),
                'fab fa-medapps' => esc_html__( 'medapps', 'gostudy' ),
                'fab fa-medium' => esc_html__( 'medium', 'gostudy' ),
                'fab fa-medium-m' => esc_html__( 'medium-m', 'gostudy' ),
                'fas fa-medkit' => esc_html__( 'medkit', 'gostudy' ),
                'fab fa-medrt' => esc_html__( 'medrt', 'gostudy' ),
                'fab fa-meetup' => esc_html__( 'meetup', 'gostudy' ),
                'fas fa-meh' => esc_html__( 'meh', 'gostudy' ),
                'far fa-meh' => esc_html__( 'meh', 'gostudy' ),
                'fas fa-mercury' => esc_html__( 'mercury', 'gostudy' ),
                'fas fa-microchip' => esc_html__( 'microchip', 'gostudy' ),
                'fas fa-microphone' => esc_html__( 'microphone', 'gostudy' ),
                'fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'gostudy' ),
                'fab fa-microsoft' => esc_html__( 'microsoft', 'gostudy' ),
                'fas fa-minus' => esc_html__( 'minus', 'gostudy' ),
                'fas fa-minus-circle' => esc_html__( 'minus-circle', 'gostudy' ),
                'fas fa-minus-square' => esc_html__( 'minus-square', 'gostudy' ),
                'far fa-minus-square' => esc_html__( 'minus-square', 'gostudy' ),
                'fab fa-mix' => esc_html__( 'mix', 'gostudy' ),
                'fab fa-mixcloud' => esc_html__( 'mixcloud', 'gostudy' ),
                'fab fa-mizuni' => esc_html__( 'mizuni', 'gostudy' ),
                'fas fa-mobile' => esc_html__( 'mobile', 'gostudy' ),
                'fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'gostudy' ),
                'fab fa-modx' => esc_html__( 'modx', 'gostudy' ),
                'fab fa-monero' => esc_html__( 'monero', 'gostudy' ),
                'fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'gostudy' ),
                'far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'gostudy' ),
                'fas fa-moon' => esc_html__( 'moon', 'gostudy' ),
                'far fa-moon' => esc_html__( 'moon', 'gostudy' ),
                'fas fa-motorcycle' => esc_html__( 'motorcycle', 'gostudy' ),
                'fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'gostudy' ),
                'fas fa-music' => esc_html__( 'music', 'gostudy' ),
                'fab fa-napster' => esc_html__( 'napster', 'gostudy' ),
                'fas fa-neuter' => esc_html__( 'neuter', 'gostudy' ),
                'fas fa-newspaper' => esc_html__( 'newspaper', 'gostudy' ),
                'far fa-newspaper' => esc_html__( 'newspaper', 'gostudy' ),
                'fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'gostudy' ),
                'fab fa-node' => esc_html__( 'node', 'gostudy' ),
                'fab fa-node-js' => esc_html__( 'node-js', 'gostudy' ),
                'fas fa-notes-medical' => esc_html__( 'notes-medical', 'gostudy' ),
                'fab fa-npm' => esc_html__( 'npm', 'gostudy' ),
                'fab fa-ns8' => esc_html__( 'ns8', 'gostudy' ),
                'fab fa-nutritionix' => esc_html__( 'nutritionix', 'gostudy' ),
                'fas fa-object-group' => esc_html__( 'object-group', 'gostudy' ),
                'far fa-object-group' => esc_html__( 'object-group', 'gostudy' ),
                'fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'gostudy' ),
                'far fa-object-ungroup' => esc_html__( 'object-ungroup', 'gostudy' ),
                'fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'gostudy' ),
                'fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'gostudy' ),
                'fab fa-opencart' => esc_html__( 'opencart', 'gostudy' ),
                'fab fa-openid' => esc_html__( 'openid', 'gostudy' ),
                'fab fa-opera' => esc_html__( 'opera', 'gostudy' ),
                'fab fa-optin-monster' => esc_html__( 'optin-monster', 'gostudy' ),
                'fab fa-osi' => esc_html__( 'osi', 'gostudy' ),
                'fas fa-outdent' => esc_html__( 'outdent', 'gostudy' ),
                'fab fa-page4' => esc_html__( 'page4', 'gostudy' ),
                'fab fa-pagelines' => esc_html__( 'pagelines', 'gostudy' ),
                'fas fa-paint-brush' => esc_html__( 'paint-brush', 'gostudy' ),
                'fab fa-palfed' => esc_html__( 'palfed', 'gostudy' ),
                'fas fa-pallet' => esc_html__( 'pallet', 'gostudy' ),
                'fas fa-paper-plane' => esc_html__( 'paper-plane', 'gostudy' ),
                'far fa-paper-plane' => esc_html__( 'paper-plane', 'gostudy' ),
                'fas fa-paperclip' => esc_html__( 'paperclip', 'gostudy' ),
                'fas fa-parachute-box' => esc_html__( 'parachute-box', 'gostudy' ),
                'fas fa-paragraph' => esc_html__( 'paragraph', 'gostudy' ),
                'fas fa-paste' => esc_html__( 'paste', 'gostudy' ),
                'fab fa-patreon' => esc_html__( 'patreon', 'gostudy' ),
                'fas fa-pause' => esc_html__( 'pause', 'gostudy' ),
                'fas fa-pause-circle' => esc_html__( 'pause-circle', 'gostudy' ),
                'far fa-pause-circle' => esc_html__( 'pause-circle', 'gostudy' ),
                'fas fa-paw' => esc_html__( 'paw', 'gostudy' ),
                'fab fa-paypal' => esc_html__( 'paypal', 'gostudy' ),
                'fas fa-pen-square' => esc_html__( 'pen-square', 'gostudy' ),
                'fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'gostudy' ),
                'fas fa-people-carry' => esc_html__( 'people-carry', 'gostudy' ),
                'fas fa-percent' => esc_html__( 'percent', 'gostudy' ),
                'fab fa-periscope' => esc_html__( 'periscope', 'gostudy' ),
                'fab fa-phabricator' => esc_html__( 'phabricator', 'gostudy' ),
                'fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'gostudy' ),
                'fas fa-phone' => esc_html__( 'phone', 'gostudy' ),
                'fas fa-phone-slash' => esc_html__( 'phone-slash', 'gostudy' ),
                'fas fa-phone-square' => esc_html__( 'phone-square', 'gostudy' ),
                'fas fa-phone-volume' => esc_html__( 'phone-volume', 'gostudy' ),
                'fab fa-php' => esc_html__( 'php', 'gostudy' ),
                'fab fa-pied-piper' => esc_html__( 'pied-piper', 'gostudy' ),
                'fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'gostudy' ),
                'fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'gostudy' ),
                'fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'gostudy' ),
                'fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'gostudy' ),
                'fas fa-pills' => esc_html__( 'pills', 'gostudy' ),
                'fab fa-pinterest' => esc_html__( 'pinterest', 'gostudy' ),
                'fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'gostudy' ),
                'fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'gostudy' ),
                'fas fa-plane' => esc_html__( 'plane', 'gostudy' ),
                'fas fa-play' => esc_html__( 'play', 'gostudy' ),
                'fas fa-play-circle' => esc_html__( 'play-circle', 'gostudy' ),
                'far fa-play-circle' => esc_html__( 'play-circle', 'gostudy' ),
                'fab fa-playstation' => esc_html__( 'playstation', 'gostudy' ),
                'fas fa-plug' => esc_html__( 'plug', 'gostudy' ),
                'fas fa-plus' => esc_html__( 'plus', 'gostudy' ),
                'fas fa-plus-circle' => esc_html__( 'plus-circle', 'gostudy' ),
                'fas fa-plus-square' => esc_html__( 'plus-square', 'gostudy' ),
                'far fa-plus-square' => esc_html__( 'plus-square', 'gostudy' ),
                'fas fa-podcast' => esc_html__( 'podcast', 'gostudy' ),
                'fas fa-poo' => esc_html__( 'poo', 'gostudy' ),
                'fas fa-pound-sign' => esc_html__( 'pound-sign', 'gostudy' ),
                'fas fa-power-off' => esc_html__( 'power-off', 'gostudy' ),
                'fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'gostudy' ),
                'fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'gostudy' ),
                'fas fa-print' => esc_html__( 'print', 'gostudy' ),
                'fas fa-procedures' => esc_html__( 'procedures', 'gostudy' ),
                'fab fa-product-hunt' => esc_html__( 'product-hunt', 'gostudy' ),
                'fab fa-pushed' => esc_html__( 'pushed', 'gostudy' ),
                'fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'gostudy' ),
                'fab fa-python' => esc_html__( 'python', 'gostudy' ),
                'fab fa-qq' => esc_html__( 'qq', 'gostudy' ),
                'fas fa-qrcode' => esc_html__( 'qrcode', 'gostudy' ),
                'fas fa-question' => esc_html__( 'question', 'gostudy' ),
                'fas fa-question-circle' => esc_html__( 'question-circle', 'gostudy' ),
                'far fa-question-circle' => esc_html__( 'question-circle', 'gostudy' ),
                'fas fa-quidditch' => esc_html__( 'quidditch', 'gostudy' ),
                'fab fa-quinscape' => esc_html__( 'quinscape', 'gostudy' ),
                'fab fa-quora' => esc_html__( 'quora', 'gostudy' ),
                'fas fa-quote-left' => esc_html__( 'quote-left', 'gostudy' ),
                'fas fa-quote-right' => esc_html__( 'quote-right', 'gostudy' ),
                'fas fa-random' => esc_html__( 'random', 'gostudy' ),
                'fab fa-ravelry' => esc_html__( 'ravelry', 'gostudy' ),
                'fab fa-react' => esc_html__( 'react', 'gostudy' ),
                'fab fa-readme' => esc_html__( 'readme', 'gostudy' ),
                'fab fa-rebel' => esc_html__( 'rebel', 'gostudy' ),
                'fas fa-recycle' => esc_html__( 'recycle', 'gostudy' ),
                'fab fa-red-river' => esc_html__( 'red-river', 'gostudy' ),
                'fab fa-reddit' => esc_html__( 'reddit', 'gostudy' ),
                'fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'gostudy' ),
                'fab fa-reddit-square' => esc_html__( 'reddit-square', 'gostudy' ),
                'fas fa-redo' => esc_html__( 'redo', 'gostudy' ),
                'fas fa-redo-alt' => esc_html__( 'redo-alt', 'gostudy' ),
                'fas fa-registered' => esc_html__( 'registered', 'gostudy' ),
                'far fa-registered' => esc_html__( 'registered', 'gostudy' ),
                'fab fa-rendact' => esc_html__( 'rendact', 'gostudy' ),
                'fab fa-renren' => esc_html__( 'renren', 'gostudy' ),
                'fas fa-reply' => esc_html__( 'reply', 'gostudy' ),
                'fas fa-reply-all' => esc_html__( 'reply-all', 'gostudy' ),
                'fab fa-replyd' => esc_html__( 'replyd', 'gostudy' ),
                'fab fa-resolving' => esc_html__( 'resolving', 'gostudy' ),
                'fas fa-retweet' => esc_html__( 'retweet', 'gostudy' ),
                'fas fa-ribbon' => esc_html__( 'ribbon', 'gostudy' ),
                'fas fa-road' => esc_html__( 'road', 'gostudy' ),
                'fas fa-rocket' => esc_html__( 'rocket', 'gostudy' ),
                'fab fa-rocketchat' => esc_html__( 'rocketchat', 'gostudy' ),
                'fab fa-rockrms' => esc_html__( 'rockrms', 'gostudy' ),
                'fas fa-rss' => esc_html__( 'rss', 'gostudy' ),
                'fas fa-rss-square' => esc_html__( 'rss-square', 'gostudy' ),
                'fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'gostudy' ),
                'fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'gostudy' ),
                'fab fa-safari' => esc_html__( 'safari', 'gostudy' ),
                'fab fa-sass' => esc_html__( 'sass', 'gostudy' ),
                'fas fa-save' => esc_html__( 'save', 'gostudy' ),
                'far fa-save' => esc_html__( 'save', 'gostudy' ),
                'fab fa-schlix' => esc_html__( 'schlix', 'gostudy' ),
                'fab fa-scribd' => esc_html__( 'scribd', 'gostudy' ),
                'fas fa-search' => esc_html__( 'search', 'gostudy' ),
                'fas fa-search-minus' => esc_html__( 'search-minus', 'gostudy' ),
                'fas fa-search-plus' => esc_html__( 'search-plus', 'gostudy' ),
                'fab fa-searchengin' => esc_html__( 'searchengin', 'gostudy' ),
                'fas fa-seedling' => esc_html__( 'seedling', 'gostudy' ),
                'fab fa-sellcast' => esc_html__( 'sellcast', 'gostudy' ),
                'fab fa-sellsy' => esc_html__( 'sellsy', 'gostudy' ),
                'fas fa-server' => esc_html__( 'server', 'gostudy' ),
                'fab fa-servicestack' => esc_html__( 'servicestack', 'gostudy' ),
                'fas fa-share' => esc_html__( 'share', 'gostudy' ),
                'fas fa-share-alt' => esc_html__( 'share-alt', 'gostudy' ),
                'fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'gostudy' ),
                'fas fa-share-square' => esc_html__( 'share-square', 'gostudy' ),
                'far fa-share-square' => esc_html__( 'share-square', 'gostudy' ),
                'fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'gostudy' ),
                'fas fa-shield-alt' => esc_html__( 'shield-alt', 'gostudy' ),
                'fas fa-ship' => esc_html__( 'ship', 'gostudy' ),
                'fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'gostudy' ),
                'fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'gostudy' ),
                'fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'gostudy' ),
                'fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'gostudy' ),
                'fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'gostudy' ),
                'fas fa-shower' => esc_html__( 'shower', 'gostudy' ),
                'fas fa-sign' => esc_html__( 'sign', 'gostudy' ),
                'fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'gostudy' ),
                'fas fa-sign-language' => esc_html__( 'sign-language', 'gostudy' ),
                'fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'gostudy' ),
                'fas fa-signal' => esc_html__( 'signal', 'gostudy' ),
                'fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'gostudy' ),
                'fab fa-sistrix' => esc_html__( 'sistrix', 'gostudy' ),
                'fas fa-sitemap' => esc_html__( 'sitemap', 'gostudy' ),
                'fab fa-skyatlas' => esc_html__( 'skyatlas', 'gostudy' ),
                'fab fa-skype' => esc_html__( 'skype', 'gostudy' ),
                'fab fa-slack' => esc_html__( 'slack', 'gostudy' ),
                'fab fa-slack-hash' => esc_html__( 'slack-hash', 'gostudy' ),
                'fas fa-sliders-h' => esc_html__( 'sliders-h', 'gostudy' ),
                'fab fa-slideshare' => esc_html__( 'slideshare', 'gostudy' ),
                'fas fa-smile' => esc_html__( 'smile', 'gostudy' ),
                'far fa-smile' => esc_html__( 'smile', 'gostudy' ),
                'fas fa-smoking' => esc_html__( 'smoking', 'gostudy' ),
                'fab fa-snapchat' => esc_html__( 'snapchat', 'gostudy' ),
                'fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'gostudy' ),
                'fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'gostudy' ),
                'fas fa-snowflake' => esc_html__( 'snowflake', 'gostudy' ),
                'far fa-snowflake' => esc_html__( 'snowflake', 'gostudy' ),
                'fas fa-sort' => esc_html__( 'sort', 'gostudy' ),
                'fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'gostudy' ),
                'fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'gostudy' ),
                'fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'gostudy' ),
                'fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'gostudy' ),
                'fas fa-sort-down' => esc_html__( 'sort-down', 'gostudy' ),
                'fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'gostudy' ),
                'fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'gostudy' ),
                'fas fa-sort-up' => esc_html__( 'sort-up', 'gostudy' ),
                'fab fa-soundcloud' => esc_html__( 'soundcloud', 'gostudy' ),
                'fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'gostudy' ),
                'fab fa-speakap' => esc_html__( 'speakap', 'gostudy' ),
                'fas fa-spinner' => esc_html__( 'spinner', 'gostudy' ),
                'fab fa-spotify' => esc_html__( 'spotify', 'gostudy' ),
                'fas fa-square' => esc_html__( 'square', 'gostudy' ),
                'far fa-square' => esc_html__( 'square', 'gostudy' ),
                'fas fa-square-full' => esc_html__( 'square-full', 'gostudy' ),
                'fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'gostudy' ),
                'fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'gostudy' ),
                'fas fa-star' => esc_html__( 'star', 'gostudy' ),
                'far fa-star' => esc_html__( 'star', 'gostudy' ),
                'fas fa-star-half' => esc_html__( 'star-half', 'gostudy' ),
                'far fa-star-half' => esc_html__( 'star-half', 'gostudy' ),
                'fab fa-staylinked' => esc_html__( 'staylinked', 'gostudy' ),
                'fab fa-steam' => esc_html__( 'steam', 'gostudy' ),
                'fab fa-steam-square' => esc_html__( 'steam-square', 'gostudy' ),
                'fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'gostudy' ),
                'fas fa-step-backward' => esc_html__( 'step-backward', 'gostudy' ),
                'fas fa-step-forward' => esc_html__( 'step-forward', 'gostudy' ),
                'fas fa-stethoscope' => esc_html__( 'stethoscope', 'gostudy' ),
                'fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'gostudy' ),
                'fas fa-sticky-note' => esc_html__( 'sticky-note', 'gostudy' ),
                'far fa-sticky-note' => esc_html__( 'sticky-note', 'gostudy' ),
                'fas fa-stop' => esc_html__( 'stop', 'gostudy' ),
                'fas fa-stop-circle' => esc_html__( 'stop-circle', 'gostudy' ),
                'far fa-stop-circle' => esc_html__( 'stop-circle', 'gostudy' ),
                'fas fa-stopwatch' => esc_html__( 'stopwatch', 'gostudy' ),
                'fab fa-strava' => esc_html__( 'strava', 'gostudy' ),
                'fas fa-street-view' => esc_html__( 'street-view', 'gostudy' ),
                'fas fa-strikethrough' => esc_html__( 'strikethrough', 'gostudy' ),
                'fab fa-stripe' => esc_html__( 'stripe', 'gostudy' ),
                'fab fa-stripe-s' => esc_html__( 'stripe-s', 'gostudy' ),
                'fab fa-studiovinari' => esc_html__( 'studiovinari', 'gostudy' ),
                'fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'gostudy' ),
                'fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'gostudy' ),
                'fas fa-subscript' => esc_html__( 'subscript', 'gostudy' ),
                'fas fa-subway' => esc_html__( 'subway', 'gostudy' ),
                'fas fa-suitcase' => esc_html__( 'suitcase', 'gostudy' ),
                'fas fa-sun' => esc_html__( 'sun', 'gostudy' ),
                'far fa-sun' => esc_html__( 'sun', 'gostudy' ),
                'fab fa-superpowers' => esc_html__( 'superpowers', 'gostudy' ),
                'fas fa-superscript' => esc_html__( 'superscript', 'gostudy' ),
                'fab fa-supple' => esc_html__( 'supple', 'gostudy' ),
                'fas fa-sync' => esc_html__( 'sync', 'gostudy' ),
                'fas fa-sync-alt' => esc_html__( 'sync-alt', 'gostudy' ),
                'fas fa-syringe' => esc_html__( 'syringe', 'gostudy' ),
                'fas fa-table' => esc_html__( 'table', 'gostudy' ),
                'fas fa-table-tennis' => esc_html__( 'table-tennis', 'gostudy' ),
                'fas fa-tablet' => esc_html__( 'tablet', 'gostudy' ),
                'fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'gostudy' ),
                'fas fa-tablets' => esc_html__( 'tablets', 'gostudy' ),
                'fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'gostudy' ),
                'fas fa-tag' => esc_html__( 'tag', 'gostudy' ),
                'fas fa-tags' => esc_html__( 'tags', 'gostudy' ),
                'fas fa-tape' => esc_html__( 'tape', 'gostudy' ),
                'fas fa-tasks' => esc_html__( 'tasks', 'gostudy' ),
                'fas fa-taxi' => esc_html__( 'taxi', 'gostudy' ),
                'fab fa-telegram' => esc_html__( 'telegram', 'gostudy' ),
                'fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'gostudy' ),
                'fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'gostudy' ),
                'fas fa-terminal' => esc_html__( 'terminal', 'gostudy' ),
                'fas fa-text-height' => esc_html__( 'text-height', 'gostudy' ),
                'fas fa-text-width' => esc_html__( 'text-width', 'gostudy' ),
                'fas fa-th' => esc_html__( 'th', 'gostudy' ),
                'fas fa-th-large' => esc_html__( 'th-large', 'gostudy' ),
                'fas fa-th-list' => esc_html__( 'th-list', 'gostudy' ),
                'fab fa-themeisle' => esc_html__( 'themeisle', 'gostudy' ),
                'fas fa-thermometer' => esc_html__( 'thermometer', 'gostudy' ),
                'fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'gostudy' ),
                'fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'gostudy' ),
                'fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'gostudy' ),
                'fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'gostudy' ),
                'fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'gostudy' ),
                'fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'gostudy' ),
                'far fa-thumbs-down' => esc_html__( 'thumbs-down', 'gostudy' ),
                'fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'gostudy' ),
                'far fa-thumbs-up' => esc_html__( 'thumbs-up', 'gostudy' ),
                'fas fa-thumbtack' => esc_html__( 'thumbtack', 'gostudy' ),
                'fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'gostudy' ),
                'fas fa-times' => esc_html__( 'times', 'gostudy' ),
                'fas fa-times-circle' => esc_html__( 'times-circle', 'gostudy' ),
                'far fa-times-circle' => esc_html__( 'times-circle', 'gostudy' ),
                'fas fa-tint' => esc_html__( 'tint', 'gostudy' ),
                'fas fa-toggle-off' => esc_html__( 'toggle-off', 'gostudy' ),
                'fas fa-toggle-on' => esc_html__( 'toggle-on', 'gostudy' ),
                'fas fa-trademark' => esc_html__( 'trademark', 'gostudy' ),
                'fas fa-train' => esc_html__( 'train', 'gostudy' ),
                'fas fa-transgender' => esc_html__( 'transgender', 'gostudy' ),
                'fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'gostudy' ),
                'fas fa-trash' => esc_html__( 'trash', 'gostudy' ),
                'fas fa-trash-alt' => esc_html__( 'trash-alt', 'gostudy' ),
                'far fa-trash-alt' => esc_html__( 'trash-alt', 'gostudy' ),
                'fas fa-tree' => esc_html__( 'tree', 'gostudy' ),
                'fab fa-trello' => esc_html__( 'trello', 'gostudy' ),
                'fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'gostudy' ),
                'fas fa-trophy' => esc_html__( 'trophy', 'gostudy' ),
                'fas fa-truck' => esc_html__( 'truck', 'gostudy' ),
                'fas fa-truck-loading' => esc_html__( 'truck-loading', 'gostudy' ),
                'fas fa-truck-moving' => esc_html__( 'truck-moving', 'gostudy' ),
                'fas fa-tty' => esc_html__( 'tty', 'gostudy' ),
                'fab fa-tumblr' => esc_html__( 'tumblr', 'gostudy' ),
                'fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'gostudy' ),
                'fas fa-tv' => esc_html__( 'tv', 'gostudy' ),
                'fab fa-twitch' => esc_html__( 'twitch', 'gostudy' ),
                'fab fa-twitter' => esc_html__( 'twitter', 'gostudy' ),
                'fab fa-twitter-square' => esc_html__( 'twitter-square', 'gostudy' ),
                'fab fa-typo3' => esc_html__( 'typo3', 'gostudy' ),
                'fab fa-uber' => esc_html__( 'uber', 'gostudy' ),
                'fab fa-uikit' => esc_html__( 'uikit', 'gostudy' ),
                'fas fa-umbrella' => esc_html__( 'umbrella', 'gostudy' ),
                'fas fa-underline' => esc_html__( 'underline', 'gostudy' ),
                'fas fa-undo' => esc_html__( 'undo', 'gostudy' ),
                'fas fa-undo-alt' => esc_html__( 'undo-alt', 'gostudy' ),
                'fab fa-uniregistry' => esc_html__( 'uniregistry', 'gostudy' ),
                'fas fa-universal-access' => esc_html__( 'universal-access', 'gostudy' ),
                'fas fa-university' => esc_html__( 'university', 'gostudy' ),
                'fas fa-unlink' => esc_html__( 'unlink', 'gostudy' ),
                'fas fa-unlock' => esc_html__( 'unlock', 'gostudy' ),
                'fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'gostudy' ),
                'fab fa-untappd' => esc_html__( 'untappd', 'gostudy' ),
                'fas fa-upload' => esc_html__( 'upload', 'gostudy' ),
                'fab fa-usb' => esc_html__( 'usb', 'gostudy' ),
                'fas fa-user' => esc_html__( 'user', 'gostudy' ),
                'far fa-user' => esc_html__( 'user', 'gostudy' ),
                'fas fa-user-circle' => esc_html__( 'user-circle', 'gostudy' ),
                'far fa-user-circle' => esc_html__( 'user-circle', 'gostudy' ),
                'fas fa-user-md' => esc_html__( 'user-md', 'gostudy' ),
                'fas fa-user-plus' => esc_html__( 'user-plus', 'gostudy' ),
                'fas fa-user-secret' => esc_html__( 'user-secret', 'gostudy' ),
                'fas fa-user-times' => esc_html__( 'user-times', 'gostudy' ),
                'fas fa-users' => esc_html__( 'users', 'gostudy' ),
                'fab fa-ussunnah' => esc_html__( 'ussunnah', 'gostudy' ),
                'fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'gostudy' ),
                'fas fa-utensils' => esc_html__( 'utensils', 'gostudy' ),
                'fab fa-vaadin' => esc_html__( 'vaadin', 'gostudy' ),
                'fas fa-venus' => esc_html__( 'venus', 'gostudy' ),
                'fas fa-venus-double' => esc_html__( 'venus-double', 'gostudy' ),
                'fas fa-venus-mars' => esc_html__( 'venus-mars', 'gostudy' ),
                'fab fa-viacoin' => esc_html__( 'viacoin', 'gostudy' ),
                'fab fa-viadeo' => esc_html__( 'viadeo', 'gostudy' ),
                'fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'gostudy' ),
                'fas fa-vial' => esc_html__( 'vial', 'gostudy' ),
                'fas fa-vials' => esc_html__( 'vials', 'gostudy' ),
                'fab fa-viber' => esc_html__( 'viber', 'gostudy' ),
                'fas fa-video' => esc_html__( 'video', 'gostudy' ),
                'fas fa-video-slash' => esc_html__( 'video-slash', 'gostudy' ),
                'fab fa-vimeo' => esc_html__( 'vimeo', 'gostudy' ),
                'fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'gostudy' ),
                'fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'gostudy' ),
                'fab fa-vine' => esc_html__( 'vine', 'gostudy' ),
                'fab fa-vk' => esc_html__( 'vk', 'gostudy' ),
                'fab fa-vnv' => esc_html__( 'vnv', 'gostudy' ),
                'fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'gostudy' ),
                'fas fa-volume-down' => esc_html__( 'volume-down', 'gostudy' ),
                'fas fa-volume-off' => esc_html__( 'volume-off', 'gostudy' ),
                'fas fa-volume-up' => esc_html__( 'volume-up', 'gostudy' ),
                'fab fa-vuejs' => esc_html__( 'vuejs', 'gostudy' ),
                'fas fa-warehouse' => esc_html__( 'warehouse', 'gostudy' ),
                'fab fa-weibo' => esc_html__( 'weibo', 'gostudy' ),
                'fas fa-weight' => esc_html__( 'weight', 'gostudy' ),
                'fab fa-weixin' => esc_html__( 'weixin', 'gostudy' ),
                'fab fa-whatsapp' => esc_html__( 'whatsapp', 'gostudy' ),
                'fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'gostudy' ),
                'fas fa-wheelchair' => esc_html__( 'wheelchair', 'gostudy' ),
                'fab fa-whmcs' => esc_html__( 'whmcs', 'gostudy' ),
                'fas fa-wifi' => esc_html__( 'wifi', 'gostudy' ),
                'fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'gostudy' ),
                'fas fa-window-close' => esc_html__( 'window-close', 'gostudy' ),
                'far fa-window-close' => esc_html__( 'window-close', 'gostudy' ),
                'fas fa-window-maximize' => esc_html__( 'window-maximize', 'gostudy' ),
                'far fa-window-maximize' => esc_html__( 'window-maximize', 'gostudy' ),
                'fas fa-window-minimize' => esc_html__( 'window-minimize', 'gostudy' ),
                'far fa-window-minimize' => esc_html__( 'window-minimize', 'gostudy' ),
                'fas fa-window-restore' => esc_html__( 'window-restore', 'gostudy' ),
                'far fa-window-restore' => esc_html__( 'window-restore', 'gostudy' ),
                'fab fa-windows' => esc_html__( 'windows', 'gostudy' ),
                'fas fa-wine-glass' => esc_html__( 'wine-glass', 'gostudy' ),
                'fas fa-won-sign' => esc_html__( 'won-sign', 'gostudy' ),
                'fab fa-wordpress' => esc_html__( 'wordpress', 'gostudy' ),
                'fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'gostudy' ),
                'fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'gostudy' ),
                'fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'gostudy' ),
                'fab fa-wpforms' => esc_html__( 'wpforms', 'gostudy' ),
                'fas fa-wrench' => esc_html__( 'wrench', 'gostudy' ),
                'fas fa-x-ray' => esc_html__( 'x-ray', 'gostudy' ),
                'fab fa-xbox' => esc_html__( 'xbox', 'gostudy' ),
                'fab fa-xing' => esc_html__( 'xing', 'gostudy' ),
                'fab fa-xing-square' => esc_html__( 'xing-square', 'gostudy' ),
                'fab fa-y-combinator' => esc_html__( 'y-combinator', 'gostudy' ),
                'fab fa-yahoo' => esc_html__( 'yahoo', 'gostudy' ),
                'fab fa-yandex' => esc_html__( 'yandex', 'gostudy' ),
                'fab fa-yandex-international' => esc_html__( 'yandex-international', 'gostudy' ),
                'fab fa-yelp' => esc_html__( 'yelp', 'gostudy' ),
                'fas fa-yen-sign' => esc_html__( 'yen-sign', 'gostudy' ),
                'fab fa-yoast' => esc_html__( 'yoast', 'gostudy' ),
                'fab fa-youtube' => esc_html__( 'youtube', 'gostudy' ),
                'fab fa-youtube-square' => esc_html__( 'youtube-square', 'gostudy' ),
            ];
        }
    }

    function WglAdminIcon()
    {
        return RT_Admin_Icon::get_instance();
    }

    // Call Admin Function
    WglAdminIcon();
}
