<?php 
/*
Plugin Name: Goodnews Shortcodes editor
Plugin URI: http://www.Momizat.com
Description: Super easy shortcodes generator works on editor visual mode and text mode
Version: 1.2
Author: Momizat
Author URI: http://www.momizat.com
*/

if (!class_exists('Momizat_Shortcodes_editor')) {

	class Momizat_Shortcodes_editor
	{
		protected static $instance = null;

	
		/**
		 * Initialize the plugin
		 *
		 * @since	 1.0.0
		 */
		function __construct()
		{
			$this->init();
			$this->includes();
		}

		/**
		 * init
		 *
		 * @since	 1.0.0
		 * @return void
		 */
		function init() {
    		if ( current_user_can('edit_posts') || current_user_can('edit_pages') ) {
				delete_option('mom_mse_shortcodes');
				add_action('admin_enqueue_scripts', array(&$this, 'scripts'));
				add_action('media_buttons', array(&$this, 'button'));
				add_action('admin_footer', array(&$this, 'modal'));

				add_action('wp_ajax_mom_shortcode_settings', array(&$this, 'edit_item'));
				// for tinymce
				//add_filter( 'wp_default_editor', create_function('', 'return "tinymce";') );
			}
		}

		/**
		 * Include the core files
		 *
		 * @since  1.0.0
		 * @return void
		 */
		function includes() {
			if (is_admin()) {
				require_once plugin_dir_path( __FILE__ ) . '/class-mapper.php';
				require_once plugin_dir_path( __FILE__ ) . '/map.php';
			}			

		}


		/**
		 * add intial scripts and styles
		 *
		 * @since	 1.0.0
		 * @return void
		 */
		function scripts() {
				wp_enqueue_style( 'momizat-shortcodes-editor', plugin_dir_url( __FILE__ ).'assets/css/shortcodes-editor.css' );
				wp_register_script( 'momizat-shortcodes', plugin_dir_url( __FILE__ ). 'assets/js/shortcodes-editor.js' , array('jquery'), '1.0', true );
				wp_localize_script( 'momizat-shortcodes', 'momShortcodes', array(
                'url' => admin_url( 'admin-ajax.php' ),
                'nonce' => wp_create_nonce( 'ajax-nonce' ),
                'back_to_selector' => __('Back', 'theme'),
            ));
            wp_enqueue_script('momizat-shortcodes');

		}

		/**
		 * editor button that hold all shortcodes
		 *
		 * @since  1.0.0
		 * @return void
		 */
		function button() {
			$button = '<a href="#" class="mom_shortcodes_editor_button button"><i class="dashicons dashicons-editor-code"></i>'.__('Shortcodes', 'theme').'</a>';
			echo balancetags($button);
		}


		/**
		 * editor button that hold all shortcodes
		 *
		 * @since  1.0.0
		 * @return void
		 */
		function modal() {
			ob_start(); 
			?>
					<div class="mse-modal-wrap">
						<div class="mse-modal">
							<div class="mse-modal-header"><h3><?php echo esc_html__( 'Shortcodes', 'theme' ); ?></h3><a href="#" class="mse-modal-close fa-close"></a></div>
							<div class="mse-modal-content">
								<div class="mse-loader"><img src="<?php echo plugin_dir_url( __FILE__ ).'assets/images/loader.gif'; ?>"></div>
								<div class="momizat-shortcodes-wrap momizat-shortcodes-selector clearfix">
								<?php 
									$shortcodes = get_option('mom_mse_shortcodes');
									if (is_array($shortcodes)) {
										foreach ($shortcodes as $shortcode) {
											$icon = isset( $shortcode['icon'] ) ? '<i class="'.$shortcode['icon'].'"></i>' : '' ;
											$description = isset( $shortcode['description'] ) ? '<small>'.$shortcode['description'].'</small>' : '' ;
											$category = isset( $shortcode['category'] ) ? $shortcode['category'] : '' ;
											$is_container = isset( $shortcode['is_container'] ) ? $shortcode['is_container'] : '' ;

											echo '<div class="mom_shortcode_container" data-category="'.esc_attr($category).'"><a href="#" class="mom_shortcode" data-type="'.esc_attr($shortcode['base']).'" data-shortcode="['.esc_attr($shortcode['base']).']" data-is_container="'.esc_attr($is_container).'">'.$icon.$shortcode['name'].$description.'</a></div>';
										}
									}
								?>
								</div>
								<div class="mom-shortcode-settings">
								</div>
							</div> <!-- Modal content -->
							<div class="mse-modal-footer">
								<a href="#" class="mse-modal-save mse-modal-insert"><?php echo esc_html__( 'Insert Shortcode', 'theme' ); ?></a>
							</div>
						</div>
					</div>
					<div class="mse-modal-backdrop"></div>
					<div class="mse-elements-params">
						<?php 
								$shortcodes = get_option('mom_mse_shortcodes');
								if (is_array($shortcodes)) {
								foreach ($shortcodes as $shortcode) {
									$el_params = json_encode($shortcode);
									echo '<span class="'.esc_attr($shortcode['base']).'_shortcode_params" data-type="'.esc_attr($shortcode['base']).'" data-params="'.esc_attr($el_params).'"> </span>';
								}
								}
						?>
					</div>					
			<?php

			$output = ob_get_contents();
			ob_end_clean();

			echo $output;
		}

	/**
	* Edit grid item 
	* @since 1.0.0
	*/
	function edit_item() {
            $nonce = $_POST['nonce'];
            $params = isset($_POST['params']) ? json_decode(stripslashes($_POST['params']), true) : '';
            $num = isset($_POST['num']) ? $_POST['num'] : '';

            if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) )
            die ( '' );
			ob_start();


			//var_dump($params);
        	if (is_array($params)) {
        		foreach ($params as $param) { 
        				$id = isset($param['id']) ? $param['id'] : '' ;
        				$name = isset($param['name']) ? $param['name'] : '' ;
        				$desc = isset($param['desc']) ? $param['desc'] : '';
        				$type = isset($param['type']) ? $param['type'] : '';
        				$options = isset($param['options']) ? $param['options'] : '';
        				$default = isset($param['default']) ? $param['default'] : '';
        				$std = isset($param['std']) ? $param['std'] : '';
        				$class = isset($param['class']) ? $param['class'] : '';
        				$min = isset($param['min']) ? $param['min'] : '';
        				$max = isset($param['max']) ? $param['max'] : '';
        				$step = isset($param['step']) ? $param['step'] : '';
        				$suffix = isset($param['suffix']) ? $param['suffix'] : '';
        				$group = isset($param['group']) ? $param['group'] : __('General', 'MOM_TEXT_DOMAIN');
						$required = '';
						$required_class = 'mom-mb-parent-attr';
						$required_level = '';
       					$req = '';

						//"dependency" => Array('element' => "checkbox", 'value' => array('val3')),
        				//integrate this with visual composer params 
        				$param_name = isset($param['param_name']) ? $param['param_name'] : false ;
        				$heading = isset($param['heading']) ? $param['heading'] : false ;
        				$description = isset($param['description']) ? $param['description'] : false;
        				$value = isset($param['value']) ? $param['value'] : false;
        				$dependency = isset($param['dependency']) ? $param['dependency'] : false;
        				if ($dependency) {
        					$req = 'deb';
        				}

        				if ($param_name) {
        					$id = $param_name;
        				}
        				if ($heading) {
        					$name = $heading; 
        				}
        				if ($description) {
        					$desc = $description;
        				}
        				if ($value) {
        					$options = $value;
        				}

        				if ($req == 'deb') {
								$op = isset($param['dependency']['op']) ? $param['dependency']['op'] : '=';
								$not_empty = isset($param['dependency']['not_empty']) ? $param['dependency']['not_empty'] : false;
								$req_val = isset($param['dependency']['value'][0]) ? $param['dependency']['value'][0] : ''; 

								if ($not_empty == true) {
									$op = '!=';
									$req_val = '';
								}
								$required .= 'data-required="'.esc_attr($param['dependency']['element']).'" data-value="'.esc_attr($req_val).'" data-operator="'.esc_attr($op).'"';
								$required_class = 'mb-require-another-attr';
								$required_level = isset($param['dependency']['lvl']) ? ' mom-attr-level-'.$param['dependency']['lvl']: '';
        				} else {
							if (isset($param['required'])) {
								$op = isset($param['required'][2]) ? $param['required'][2] : '=';
								$required .= 'data-required="'.esc_attr($param['required'][0]).'" data-value="'.esc_attr($param['required'][1]).'" data-operator="'.esc_attr($op).'"';
								$required_class = 'mb-require-another-attr';
								$required_level = isset($param['required'][3]) ? ' mom-attr-level-'.$param['required'][3]: '';

							}        				
        				}
        			 ?>
        			<div class="mg-modal-field clearfix mg-field-<?php echo esc_attr( $type ); ?>  <?php echo esc_attr($required_class.$required_level); ?>" data-group="<?php echo esc_attr($group ); ?>" <?php echo $required; ?>>
        				<div class="mg-field-label">
							<label for="<?php echo esc_attr( $id ); ?>"><?php echo balancetags( $name ); ?></label>
							<p class="mg-modal-field--desc"><?php echo balancetags($desc); ?></p>
						</div>						
						<div class="mg-field-content">
						<?php 
							$html = '';
							if ($type == 'select' || $type == 'dropdown') {
								$html .= '<div class="mg-select-wrap"><div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select name="'.$id.'" id="'.$id.'" class="mg-modal-field-'.$id.'">';
								if (is_array($options))	{
									foreach ($options as $label => $val) {
										if ( is_numeric( $label ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
											$l = $val;
											$v = $val;
										} elseif ( is_numeric( $label ) && is_array( $val ) ) {
											$l = isset( $val['label'] ) ? $val['label'] : array_pop( $val );
											$v = isset( $val['value'] ) ? $val['value'] : array_pop( $val );
										} else {
											$v = $val;
											$l = $label;
										}
										

										$html .= '<option value="'.$v.'">'.$l.'</option>';
									}
								}
								$html .= '</select>';
								$html .= '</div>';

							} elseif ($type == 'textarea') {
								$html .= '<textarea name="'.$id.'" class="mg-modal-field-'.$id.'" id="'.$id.'" cols="30" rows="10">'.$default.'</textarea>';
							} elseif ($type == 'color' || $type == 'colorpicker') {
								$html .= '<input type="text" class="mg-color-field" name="'.$id.'" class="mg-modal-field-'.$id.'" id="'.$id.'">';
							} elseif ($type == 'background') {
								$html .= '<div class="mom_bg-color">';
								$html .= '<input type="text" class="mg-color-field" id="'.$id.'_color" name="'.$id.'_color"/>';
								$html .= '</div>';
								$html .= '<div class="mom_upload_meta mom_bg_image">';
								$html .= '<div><input type="text" id="'.$id.'_url" name="'.$id.'_url" class="url"> <input type="hidden" id="'.$id.'_id" name="'.$id.'_id" class="id"> <input type="hidden" id="'.$id.'_width" name="'.$id.'_width" class="width"> <input type="hidden" id="'.$id.'_height" name="'.$id.'_height" class="height"></div>';
					    		$html .= '<div class="mom_upload_button_container"><input type="button" class="mom_upload_meta_button button" value="'.__('Upload', 'theme').'"></div>';
								$html .= '</div>';
								$html .= '<div class="mom_bg-options">';
								$html .= '<div class="mg-select-wrap">';
								$html .= '<div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select  id="'.$id.'_repeat" name="'.$id.'_repeat">';
								$html .= '<option value="" class="placeholder">'.__('Backgorund Repeat ...', 'theme').'</option>';
								$html .= '<option value="no-repeat">'.__('No Repeat', 'theme').'</option>';
								$html .= '<option value="repeat">'.__('Repeat All', 'theme').'</option>';
								$html .= '<option value="repeat-x">'.__('Repeat Horizontally', 'theme').'</option>';
								$html .= '<option value="repeat-y">'.__('Repeat Vertically', 'theme').'</option>';
								$html .= '<option value="inherit">'.__('Inherit', 'theme').'</option>';
								$html .= '</select>';
								$html .= '</div>';
								$html .= '<div class="mg-select-wrap">';
								$html .= '<div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select  id="'.$id.'_size" name="'.$id.'_size">';
								$html .= '<option value="" class="placeholder">'.__('Backgorund Size ...', 'theme').'</option>';
								$html .= '<option value="inherit">'.__('Inherit', 'theme').'</option>';
								$html .= '<option value="cover">'.__('Cover', 'theme').'</option>';
								$html .= '<option value="contain">'.__('Contain', 'theme').'</option>';
								$html .= '</select>';
								$html .= '</div>';
								$html .= '<div class="mg-select-wrap">';
								$html .= '<div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select  id="'.$id.'_attachment" name="'.$id.'_attachment">';
								$html .= '<option value="" class="placeholder">'.__('Backgorund Attachment ...', 'theme').'</option>';
								$html .= '<option value="fixed">'.__('Fixed', 'theme').'</option>';
								$html .= '<option value="scroll">'.__('scroll', 'theme').'</option>';
								$html .= '<option value="inherit">'.__('Inherit', 'theme').'</option>';
								$html .= '</select>';
								$html .= '</div>';
								$html .= '<div class="mg-select-wrap">';
								$html .= '<div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select  id="'.$id.'_position" name="'.$id.'_position">';
								$html .= '<option value="" class="placeholder">'.__('Backgorund position ...', 'theme').'</option>';
								$html .= '<option value="left top">'.__('left top', 'theme').'</option>';
								$html .= '<option value="left center">'.__('left center', 'theme').'</option>';
								$html .= '<option value="Left Bottom">'.__('Left Bottom', 'theme').'</option>';
								$html .= '<option value="Center Top">'.__('Center Top', 'theme').'</option>';
								$html .= '<option value="center center">'.__('center center', 'theme').'</option>';
								$html .= '<option value="Center Bottom">'.__('Center Bottom', 'theme').'</option>';
								$html .= '<option value="right top">'.__('right top', 'theme').'</option>';
								$html .= '<option value="Right center">'.__('Right center', 'theme').'</option>';
								$html .= '<option value="right bottom">'.__('right bottom', 'theme').'</option>';
								$html .= '</select>';
								$html .= '</div>';
								$html .= '</div>';

							} elseif ($type == 'upload' || $type == 'attach_image') { 
								$html .= '<div class="mom_upload_meta mom_bg_image">';
								$html .= '<div><input type="text" id="'.$id.'" name="'.$id.'" class="url"> <input type="hidden" id="'.$id.'_id" name="'.$id.'_id" class="id"> <input type="hidden" id="'.$id.'_width" name="'.$id.'_width" class="width"> <input type="hidden" id="'.$id.'_height" name="'.$id.'_height" class="height"></div>';
					    		$html .= '<div class="mom_upload_button_container"><input type="button" class="mom_upload_meta_button button" value="'.__('Upload', 'theme').'"></div>';
								$html .= '</div>';
							} elseif ($type == 'editor' || $type == 'textarea_html') { 
								//wp_editor( '', 'mg-editor'.$num, array('textarea_name' => $id, 'editor_class' => 'mom-mg-editor') );
								$html .= '<textarea name="'.$id.'" class="mg-modal-field-'.$id.' mom-mg-editor" id="'.$id.'" cols="30" rows="10">'.$default.'</textarea>';
							} elseif ($type == 'border') { 
								$html .= '<input type="text" class="min" id="'.$id.'_width" name="'.$id.'_width" placeholder="1"/>';
								$html .= '<input type="text" class="mg-color-field" name="'.$id.'_color" id="'.$id.'">';
								$html .= '<div class="mg-select-wrap">';
								$html .= '<div class="mg-select-arrow dashicons dashicons-arrow-down-alt2"></div>';
								$html .= '<select id="'.$id.'_style" name="'.$id.'_style">';
								$html .= '<option value="" class="placeholder">'.__('Border style ...', 'theme').'</option>';
								$html .= '<option value="solid">'.__('Solid', 'theme').'</option>';
								$html .= '<option value="dashed">'.__('Dashed', 'theme').'</option>';
								$html .= '<option value="dotted">'.__('Dotted', 'theme').'</option>';
								$html .= '<option value="none">'.__('None', 'theme').'</option>';
								$html .= '</select>';
								$html .= '</div>';
							} elseif ($type == 'radio') {
										foreach ($options as $value => $name) {
										$html .= '<label class="mom-mb-radio"><input type="radio" value="'.esc_attr($value).'" id="'.$id.'" name="'.$id.'" class="mg-modal-field-'.$id.'"> '.esc_html($name).'</label>';
										}
							} elseif ($type == 'images') {
										foreach ($options as $value => $image) {
										$html .= '<label class="mom-mb-image"><input type="radio" value="'.esc_attr($value).'" id="'.$id.'" name="'.$id.'" class="mg-modal-field-'.$id.'"> <img alt="'.esc_attr($image['name']).'" title="'.esc_attr($image['name']).'" src="'.esc_url($image['src']).'"></label>';
										}
							} elseif ($type == 'buttons') {
										foreach ($options as $value => $label) {
											$html .= '<label class="mom-mb-button"><input type="radio" value="'.esc_attr($value).'" id="'.$id.'" name="'.$id.'" class="mg-modal-field-'.$id.'"><span class="the-button button">'.esc_html($label).'</span></label>';
										}
							} elseif ($type == 'alignment') {
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-top-left" title="Top Left"><input type="radio" value="top-left" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-top-center" title="Top Center"><input type="radio" value="top-center" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-top-right" title="Top Right"><input type="radio" value="top-right" id="'.$id.'" name="'.$id.'"><span></span></label>';

										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-middle mg-align-middle-left" title="Middle Left"><input type="radio" value="middle-left" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-middle mg-align-middle-center" title="Middle Center"><input type="radio" value="middle-center" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-middle mg-align-middle-right" title="Middle Right"><input type="radio" value="middle-right" id="'.$id.'" name="'.$id.'"><span></span></label>';

										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-bottom mg-align-bottom-left" title="Bottom Left"><input type="radio" value="bottom-left" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-bottom mg-align-bottom-center" title="Bottom Center"><input type="radio" value="bottom-center" id="'.$id.'" name="'.$id.'"><span></span></label>';
										$html .= '<label class="mom-mg-alingment  mg-tooltip mg-align-bottom mg-align-bottom-right" title="Bottom Right"><input type="radio" value="bottom-right" id="'.$id.'" name="'.$id.'"><span></span></label>';

							} elseif ($type == 'checkbox') {
								if ($std) {
									$val = $std;
								} else {
									$val = 'true';
								}
								if (is_array($options)) {
									$i = 1;
									foreach ($options as $label => $value) {
										$html .= '<label style="display:block;"><input type="checkbox" class="mg-modal-field-'.$id.'" name="'.$id.'_'.$i.']" id="'.$id.'_'.$i.']" value="'.esc_attr($value).'">'.esc_html($label).'</label>';
										$i++;
									}
								} else {
									$html .= '<label><input type="checkbox" name="'.$id.'" class="mg-modal-field-'.$id.'" id="'.$id.'" value="'.esc_attr($val).'">'.__('Yes', 'MOM_TEXT_DOMAIN').'</label>';
								}

							} elseif ( $type == 'link_color' ) {
									$html .= '<label>Regular: </label><input type="text" class="mg-color-field" name="'.$id.'_color"/>';
									$html .= '<label>Hover: </label><input type="text" class="mg-color-field" name="'.$id.'_hover"/>';
									$html .= '<label>Active: </label><input type="text" class="mg-color-field" name="'.$id.'_active"/>';
							} elseif ( $type == 'link' || $type == 'vc_link' ) {
								$html .= '<input type="text" class="link_url" name="'.$id.'_url">';
								$html .= '<label><input type="checkbox" name="'.$id.'_target" value="_blank">'.__('Open in new window', 'MOM_TEXT_DOMAIN').'</label>';

							
							} elseif ($type == 'spacing') {
			$html .= '<div class="input-group mom-spacing-field"><span>'.__('Top', 'theme').'</span><input type="text" id="'.$id.'_top" name="'.$id.'_top"/></div>';
			$html .= '<div class="input-group mom-spacing-field"><span>'.__('Right', 'theme').'</span><input type="text" id="'.$id.'_right" name="'.$id.'_right"/></div>';
			$html .= '<div class="input-group mom-spacing-field"><span>'.__('Bottom', 'theme').'</span><input type="text" id="'.$id.'_bottom" name="'.$id.'_bottom"/></div>'; 
			$html .= '<div class="input-group mom-spacing-field"><span>'.__('Left', 'theme').'</span><input type="text" id="'.$id.'_left" name="'.$id.'_left"/></div>';

							} elseif ($type == 'number' || $type == 'mom_number') {
								$html .= '<input type="number" name="'.$id.'" min="'.$min.'" max="'.$max.'" step="'.$step.'" class="mg-modal-field-'.$id.'" id="'.$id.'" value="'.$default.'"><span class="mom-mb-siffix">'.$suffix.'</span>';
							} elseif ($type == 'icon' || $type == 'mom_icon') {
								//$html .= '<input type="text" name="'.$id.'" class="mg-modal-field-'.$id.'" id="'.$id.'">';
								$icons_packs = $this->icons();
								$html .= '<div class="mom_icons_selector">';
								$html .= '<form id="mse-icons-live-search" action="" class="mes-icons-live-search" method="post"><i class="fa-search"></i>
											<input type="text" class="text-input" id="mse-mom_icons_filter" value="" placeholder="Search for icon ..." />
										</form>';
									if (is_array($icons_packs)) {
										foreach ($icons_packs as $pack) {
											$pack_name = isset($pack['name']) ? $pack['name']: '';
											$html .= '<div class="mom-icons-pack">';
											if ($pack_name) {
												$html .= '<h4 class="icons-package-name">'.__('Icons Pack: ', 'theme').$pack_name.'</h4>';
											}
											$icons = isset($pack['icons']) ? $pack['icons']: '';
											if (is_array($icons)) {
												foreach ($icons as $icon) {
													$html .= '<label class="mom_shortcodes_icon"><input type="radio" value="'.esc_attr($icon).'" id="'.$id.'" name="'.$id.'" class="mg-modal-field-'.$id.'"> <i class="'.$icon.'"></i></label>';
												}
											}
											$html .= '</div>';
										}

									}
								$html .= '</div>';

							} else {
								$html .= '<input type="text" name="'.$id.'" class="mg-modal-field-'.$id.'" id="'.$id.'" value="'.$default.'">';
							}
								echo $html;
						?>
						</div>
					</div>
        		<?php } 
        	}
	$content = ob_get_contents();
	ob_end_clean();

echo $content;
            exit();
	}
	
	public static function icons() {
		return apply_filters( 'mom_shortcodes_icons', array(
				'font-awesome' => array(
					'name' => __('Font Awesome','theme'),
					'version' => 4.5,
					'icons' => array('fa-glass','fa-music','fa-search','fa-envelope-o','fa-heart','fa-star','fa-star-o','fa-user','fa-film','fa-th-large','fa-th','fa-th-list','fa-check','fa-times','fa-search-plus','fa-search-minus','fa-power-off','fa-signal','fa-cog','fa-trash-o','fa-home','fa-file-o','fa-clock-o','fa-road','fa-download','fa-arrow-circle-o-down','fa-arrow-circle-o-up','fa-inbox','fa-play-circle-o','fa-repeat','fa-refresh','fa-list-alt','fa-lock','fa-flag','fa-headphones','fa-volume-off','fa-volume-down','fa-volume-up','fa-qrcode','fa-barcode','fa-tag','fa-tags','fa-book','fa-bookmark','fa-print','fa-camera','fa-font','fa-bold','fa-italic','fa-text-height','fa-text-width','fa-align-left','fa-align-center','fa-align-right','fa-align-justify','fa-list','fa-outdent','fa-indent','fa-video-camera','fa-picture-o','fa-pencil','fa-map-marker','fa-adjust','fa-tint','fa-pencil-square-o','fa-share-square-o','fa-check-square-o','fa-arrows','fa-step-backward','fa-fast-backward','fa-backward','fa-play','fa-pause','fa-stop','fa-forward','fa-fast-forward','fa-step-forward','fa-eject','fa-chevron-left','fa-chevron-right','fa-plus-circle','fa-minus-circle','fa-times-circle','fa-check-circle','fa-question-circle','fa-info-circle','fa-crosshairs','fa-times-circle-o','fa-check-circle-o','fa-ban','fa-arrow-left','fa-arrow-right','fa-arrow-up','fa-arrow-down','fa-share','fa-expand','fa-compress','fa-plus','fa-minus','fa-asterisk','fa-exclamation-circle','fa-gift','fa-leaf','fa-fire','fa-eye','fa-eye-slash','fa-exclamation-triangle','fa-plane','fa-calendar','fa-random','fa-comment','fa-magnet','fa-chevron-up','fa-chevron-down','fa-retweet','fa-shopping-cart','fa-folder','fa-folder-open','fa-arrows-v','fa-arrows-h','fa-bar-chart','fa-twitter-square','fa-facebook-square','fa-camera-retro','fa-key','fa-cogs','fa-comments','fa-thumbs-o-up','fa-thumbs-o-down','fa-star-half','fa-heart-o','fa-sign-out','fa-linkedin-square','fa-thumb-tack','fa-external-link','fa-sign-in','fa-trophy','fa-github-square','fa-upload','fa-lemon-o','fa-phone','fa-square-o','fa-bookmark-o','fa-phone-square','fa-twitter','fa-facebook','fa-github','fa-unlock','fa-credit-card','fa-rss','fa-hdd-o','fa-bullhorn','fa-bell','fa-certificate','fa-hand-o-right','fa-hand-o-left','fa-hand-o-up','fa-hand-o-down','fa-arrow-circle-left','fa-arrow-circle-right','fa-arrow-circle-up','fa-arrow-circle-down','fa-globe','fa-wrench','fa-tasks','fa-filter','fa-briefcase','fa-arrows-alt','fa-users','fa-link','fa-cloud','fa-flask','fa-scissors','fa-files-o','fa-paperclip','fa-floppy-o','fa-square','fa-bars','fa-list-ul','fa-list-ol','fa-strikethrough','fa-underline','fa-table','fa-magic','fa-truck','fa-pinterest','fa-pinterest-square','fa-google-plus-square','fa-google-plus','fa-money','fa-caret-down','fa-caret-up','fa-caret-left','fa-caret-right','fa-columns','fa-sort','fa-sort-desc','fa-sort-asc','fa-envelope','fa-linkedin','fa-undo','fa-gavel','fa-tachometer','fa-comment-o','fa-comments-o','fa-bolt','fa-sitemap','fa-umbrella','fa-clipboard','fa-lightbulb-o','fa-exchange','fa-cloud-download','fa-cloud-upload','fa-user-md','fa-stethoscope','fa-suitcase','fa-bell-o','fa-coffee','fa-cutlery','fa-file-text-o','fa-building-o','fa-hospital-o','fa-ambulance','fa-medkit','fa-fighter-jet','fa-beer','fa-h-square','fa-plus-square','fa-angle-double-left','fa-angle-double-right','fa-angle-double-up','fa-angle-double-down','fa-angle-left','fa-angle-right','fa-angle-up','fa-angle-down','fa-desktop','fa-laptop','fa-tablet','fa-mobile','fa-circle-o','fa-quote-left','fa-quote-right','fa-spinner','fa-circle','fa-reply','fa-github-alt','fa-folder-o','fa-folder-open-o','fa-smile-o','fa-frown-o','fa-meh-o','fa-gamepad','fa-keyboard-o','fa-flag-o','fa-flag-checkered','fa-terminal','fa-code','fa-reply-all','fa-star-half-o','fa-location-arrow','fa-crop','fa-code-fork','fa-chain-broken','fa-question','fa-info','fa-exclamation','fa-superscript','fa-subscript','fa-eraser','fa-puzzle-piece','fa-microphone','fa-microphone-slash','fa-shield','fa-calendar-o','fa-fire-extinguisher','fa-rocket','fa-maxcdn','fa-chevron-circle-left','fa-chevron-circle-right','fa-chevron-circle-up','fa-chevron-circle-down','fa-html5','fa-css3','fa-anchor','fa-unlock-alt','fa-bullseye','fa-ellipsis-h','fa-ellipsis-v','fa-rss-square','fa-play-circle','fa-ticket','fa-minus-square','fa-minus-square-o','fa-level-up','fa-level-down','fa-check-square','fa-pencil-square','fa-external-link-square','fa-share-square','fa-compass','fa-caret-square-o-down','fa-caret-square-o-up','fa-caret-square-o-right','fa-eur','fa-gbp','fa-usd','fa-inr','fa-jpy','fa-rub','fa-krw','fa-btc','fa-file','fa-file-text','fa-sort-alpha-asc','fa-sort-alpha-desc','fa-sort-amount-asc','fa-sort-amount-desc','fa-sort-numeric-asc','fa-sort-numeric-desc','fa-thumbs-up','fa-thumbs-down','fa-youtube-square','fa-youtube','fa-xing','fa-xing-square','fa-youtube-play','fa-dropbox','fa-stack-overflow','fa-instagram','fa-flickr','fa-adn','fa-bitbucket','fa-bitbucket-square','fa-tumblr','fa-tumblr-square','fa-long-arrow-down','fa-long-arrow-up','fa-long-arrow-left','fa-long-arrow-right','fa-apple','fa-windows','fa-android','fa-linux','fa-dribbble','fa-skype','fa-foursquare','fa-trello','fa-female','fa-male','fa-gratipay','fa-sun-o','fa-moon-o','fa-archive','fa-bug','fa-vk','fa-weibo','fa-renren','fa-pagelines','fa-stack-exchange','fa-arrow-circle-o-right','fa-arrow-circle-o-left','fa-caret-square-o-left','fa-dot-circle-o','fa-wheelchair','fa-vimeo-square','fa-try','fa-plus-square-o','fa-space-shuttle','fa-slack','fa-envelope-square','fa-wordpress','fa-openid','fa-university','fa-graduation-cap','fa-yahoo','fa-google','fa-reddit','fa-reddit-square','fa-stumbleupon-circle','fa-stumbleupon','fa-delicious','fa-digg','fa-pied-piper','fa-pied-piper-alt','fa-drupal','fa-joomla','fa-language','fa-fax','fa-building','fa-child','fa-paw','fa-spoon','fa-cube','fa-cubes','fa-behance','fa-behance-square','fa-steam','fa-steam-square','fa-recycle','fa-car','fa-taxi','fa-tree','fa-spotify','fa-deviantart','fa-soundcloud','fa-database','fa-file-pdf-o','fa-file-word-o','fa-file-excel-o','fa-file-powerpoint-o','fa-file-image-o','fa-file-archive-o','fa-file-audio-o','fa-file-video-o','fa-file-code-o','fa-vine','fa-codepen','fa-jsfiddle','fa-life-ring','fa-circle-o-notch','fa-rebel','fa-empire','fa-git-square','fa-git','fa-hacker-news','fa-tencent-weibo','fa-qq','fa-weixin','fa-paper-plane','fa-paper-plane-o','fa-history','fa-circle-thin','fa-header','fa-paragraph','fa-sliders','fa-share-alt','fa-share-alt-square','fa-bomb','fa-futbol-o','fa-tty','fa-binoculars','fa-plug','fa-slideshare','fa-twitch','fa-yelp','fa-newspaper-o','fa-wifi','fa-calculator','fa-paypal','fa-google-wallet','fa-cc-visa','fa-cc-mastercard','fa-cc-discover','fa-cc-amex','fa-cc-paypal','fa-cc-stripe','fa-bell-slash','fa-bell-slash-o','fa-trash','fa-copyright','fa-at','fa-eyedropper','fa-paint-brush','fa-birthday-cake','fa-area-chart','fa-pie-chart','fa-line-chart','fa-lastfm','fa-lastfm-square','fa-toggle-off','fa-toggle-on','fa-bicycle','fa-bus','fa-ioxhost','fa-angellist','fa-cc','fa-ils','fa-meanpath','fa-buysellads','fa-connectdevelop','fa-dashcube','fa-forumbee','fa-leanpub','fa-sellsy','fa-shirtsinbulk','fa-simplybuilt','fa-skyatlas','fa-cart-plus','fa-cart-arrow-down','fa-diamond','fa-ship','fa-user-secret','fa-motorcycle','fa-street-view','fa-heartbeat','fa-venus','fa-mars','fa-mercury','fa-transgender','fa-transgender-alt','fa-venus-double','fa-mars-double','fa-venus-mars','fa-mars-stroke','fa-mars-stroke-v','fa-mars-stroke-h','fa-neuter','fa-genderless','fa-facebook-official','fa-pinterest-p','fa-whatsapp','fa-server','fa-user-plus','fa-user-times','fa-bed','fa-viacoin','fa-train','fa-subway','fa-medium','fa-y-combinator','fa-optin-monster','fa-opencart','fa-expeditedssl','fa-battery-full','fa-battery-three-quarters','fa-battery-half','fa-battery-quarter','fa-battery-empty','fa-mouse-pointer','fa-i-cursor','fa-object-group','fa-object-ungroup','fa-sticky-note','fa-sticky-note-o','fa-cc-jcb','fa-cc-diners-club','fa-clone','fa-balance-scale','fa-hourglass-o','fa-hourglass-start','fa-hourglass-half','fa-hourglass-end','fa-hourglass','fa-hand-rock-o','fa-hand-paper-o','fa-hand-scissors-o','fa-hand-lizard-o','fa-hand-spock-o','fa-hand-pointer-o','fa-hand-peace-o','fa-trademark','fa-registered','fa-creative-commons','fa-gg','fa-gg-circle','fa-tripadvisor','fa-odnoklassniki','fa-odnoklassniki-square','fa-get-pocket','fa-wikipedia-w','fa-safari','fa-chrome','fa-firefox','fa-opera','fa-internet-explorer','fa-television','fa-contao','fa-500px','fa-amazon','fa-calendar-plus-o','fa-calendar-minus-o','fa-calendar-times-o','fa-calendar-check-o','fa-industry','fa-map-pin','fa-map-signs','fa-map-o','fa-map','fa-commenting','fa-commenting-o','fa-houzz','fa-vimeo','fa-black-tie','fa-fonticons','fa-reddit-alien','fa-edge','fa-credit-card-alt','fa-codiepie','fa-modx','fa-fort-awesome','fa-usb','fa-product-hunt','fa-mixcloud','fa-scribd','fa-pause-circle','fa-pause-circle-o','fa-stop-circle','fa-stop-circle-o','fa-shopping-bag','fa-shopping-basket','fa-hashtag','fa-bluetooth','fa-bluetooth-b','fa-percent')
				),
			'momizat' =>  array(
					'name' => __('Momizat','theme'),
					'version' => 1.0,
					'icons' => array('momizat-icon-home', 'momizat-icon-home2', 'momizat-icon-home3', 'momizat-icon-office', 'momizat-icon-newspaper', 'momizat-icon-pencil', 'momizat-icon-pencil2', 'momizat-icon-quill', 'momizat-icon-pen', 'momizat-icon-blog', 'momizat-icon-droplet', 'momizat-icon-paint-format', 'momizat-icon-image', 'momizat-icon-image2', 'momizat-icon-images', 'momizat-icon-camera', 'momizat-icon-music', 'momizat-icon-headphones', 'momizat-icon-play', 'momizat-icon-film', 'momizat-icon-camera2', 'momizat-icon-dice', 'momizat-icon-pacman', 'momizat-icon-spades', 'momizat-icon-clubs', 'momizat-icon-diamonds', 'momizat-icon-pawn', 'momizat-icon-bullhorn', 'momizat-icon-connection', 'momizat-icon-podcast', 'momizat-icon-feed', 'momizat-icon-book', 'momizat-icon-books', 'momizat-icon-library', 'momizat-icon-file', 'momizat-icon-profile', 'momizat-icon-file2', 'momizat-icon-file3', 'momizat-icon-file4', 'momizat-icon-copy', 'momizat-icon-copy2', 'momizat-icon-copy3', 'momizat-icon-paste', 'momizat-icon-paste2', 'momizat-icon-paste3', 'momizat-icon-stack', 'momizat-icon-folder', 'momizat-icon-folder-open', 'momizat-icon-tag', 'momizat-icon-tags', 'momizat-icon-barcode', 'momizat-icon-qrcode', 'momizat-icon-ticket', 'momizat-icon-cart', 'momizat-icon-cart2', 'momizat-icon-cart3', 'momizat-icon-coin', 'momizat-icon-credit', 'momizat-icon-calculate', 'momizat-icon-support', 'momizat-icon-phone', 'momizat-icon-phone-hang-up', 'momizat-icon-address-book', 'momizat-icon-notebook', 'momizat-icon-envelope', 'momizat-icon-pushpin', 'momizat-icon-location', 'momizat-icon-location2', 'momizat-icon-compass', 'momizat-icon-map', 'momizat-icon-map2', 'momizat-icon-history', 'momizat-icon-clock', 'momizat-icon-clock2', 'momizat-icon-alarm', 'momizat-icon-alarm2', 'momizat-icon-bell', 'momizat-icon-stopwatch', 'momizat-icon-calendar', 'momizat-icon-calendar2', 'momizat-icon-print', 'momizat-icon-keyboard', 'momizat-icon-screen', 'momizat-icon-laptop', 'momizat-icon-mobile', 'momizat-icon-mobile2', 'momizat-icon-tablet', 'momizat-icon-tv', 'momizat-icon-cabinet', 'momizat-icon-drawer', 'momizat-icon-drawer2', 'momizat-icon-drawer3', 'momizat-icon-box-add', 'momizat-icon-box-remove', 'momizat-icon-download', 'momizat-icon-upload', 'momizat-icon-disk', 'momizat-icon-storage', 'momizat-icon-undo', 'momizat-icon-redo', 'momizat-icon-flip', 'momizat-icon-flip2', 'momizat-icon-undo2', 'momizat-icon-redo2', 'momizat-icon-forward', 'momizat-icon-reply', 'momizat-icon-bubble', 'momizat-icon-bubbles', 'momizat-icon-bubbles2', 'momizat-icon-bubble2', 'momizat-icon-bubbles3', 'momizat-icon-bubbles4', 'momizat-icon-user', 'momizat-icon-users', 'momizat-icon-user2', 'momizat-icon-users2', 'momizat-icon-user3', 'momizat-icon-user4', 'momizat-icon-quotes-left', 'momizat-icon-busy', 'momizat-icon-spinner', 'momizat-icon-spinner2', 'momizat-icon-spinner3', 'momizat-icon-spinner4', 'momizat-icon-spinner5', 'momizat-icon-spinner6', 'momizat-icon-binoculars', 'momizat-icon-search', 'momizat-icon-zoom-in', 'momizat-icon-zoom-out', 'momizat-icon-expand', 'momizat-icon-contract', 'momizat-icon-expand2', 'momizat-icon-contract2', 'momizat-icon-key', 'momizat-icon-key2', 'momizat-icon-lock', 'momizat-icon-lock2', 'momizat-icon-unlocked', 'momizat-icon-wrench', 'momizat-icon-settings', 'momizat-icon-equalizer', 'momizat-icon-cog', 'momizat-icon-cogs', 'momizat-icon-cog2', 'momizat-icon-hammer', 'momizat-icon-wand', 'momizat-icon-aid', 'momizat-icon-bug', 'momizat-icon-pie', 'momizat-icon-stats', 'momizat-icon-bars', 'momizat-icon-bars2', 'momizat-icon-gift', 'momizat-icon-trophy', 'momizat-icon-glass', 'momizat-icon-mug', 'momizat-icon-food', 'momizat-icon-leaf', 'momizat-icon-rocket', 'momizat-icon-meter', 'momizat-icon-meter2', 'momizat-icon-dashboard', 'momizat-icon-hammer2', 'momizat-icon-fire', 'momizat-icon-lab', 'momizat-icon-magnet', 'momizat-icon-remove', 'momizat-icon-remove2', 'momizat-icon-briefcase', 'momizat-icon-airplane', 'momizat-icon-truck', 'momizat-icon-road', 'momizat-icon-accessibility', 'momizat-icon-target', 'momizat-icon-shield', 'momizat-icon-lightning', 'momizat-icon-switch', 'momizat-icon-power-cord', 'momizat-icon-signup', 'momizat-icon-list', 'momizat-icon-list2', 'momizat-icon-numbered-list', 'momizat-icon-menu', 'momizat-icon-menu2', 'momizat-icon-tree', 'momizat-icon-cloud', 'momizat-icon-cloud-download', 'momizat-icon-cloud-upload', 'momizat-icon-download2', 'momizat-icon-upload2', 'momizat-icon-download3', 'momizat-icon-upload3', 'momizat-icon-globe', 'momizat-icon-earth', 'momizat-icon-link', 'momizat-icon-flag', 'momizat-icon-attachment', 'momizat-icon-eye', 'momizat-icon-eye-blocked', 'momizat-icon-eye2', 'momizat-icon-bookmark', 'momizat-icon-bookmarks', 'momizat-icon-brightness-medium', 'momizat-icon-brightness-contrast', 'momizat-icon-contrast', 'momizat-icon-star', 'momizat-icon-star2', 'momizat-icon-star3', 'momizat-icon-heart', 'momizat-icon-heart2', 'momizat-icon-heart-broken', 'momizat-icon-thumbs-up', 'momizat-icon-thumbs-up2', 'momizat-icon-happy', 'momizat-icon-happy2', 'momizat-icon-smiley', 'momizat-icon-smiley2', 'momizat-icon-tongue', 'momizat-icon-tongue2', 'momizat-icon-sad', 'momizat-icon-sad2', 'momizat-icon-wink', 'momizat-icon-wink2', 'momizat-icon-grin', 'momizat-icon-grin2', 'momizat-icon-cool', 'momizat-icon-cool2', 'momizat-icon-angry', 'momizat-icon-angry2', 'momizat-icon-evil', 'momizat-icon-evil2', 'momizat-icon-shocked', 'momizat-icon-shocked2', 'momizat-icon-confused', 'momizat-icon-confused2', 'momizat-icon-neutral', 'momizat-icon-neutral2', 'momizat-icon-wondering', 'momizat-icon-wondering2', 'momizat-icon-point-up', 'momizat-icon-point-right', 'momizat-icon-point-down', 'momizat-icon-point-left', 'momizat-icon-warning', 'momizat-icon-notification', 'momizat-icon-question', 'momizat-icon-info', 'momizat-icon-info2', 'momizat-icon-blocked', 'momizat-icon-cancel-circle', 'momizat-icon-checkmark-circle', 'momizat-icon-spam', 'momizat-icon-close', 'momizat-icon-checkmark', 'momizat-icon-checkmark2', 'momizat-icon-spell-check', 'momizat-icon-minus', 'momizat-icon-plus', 'momizat-icon-enter', 'momizat-icon-exit', 'momizat-icon-play2', 'momizat-icon-pause', 'momizat-icon-stop', 'momizat-icon-backward', 'momizat-icon-forward2', 'momizat-icon-play3', 'momizat-icon-pause2', 'momizat-icon-stop2', 'momizat-icon-backward2', 'momizat-icon-forward3', 'momizat-icon-first', 'momizat-icon-last', 'momizat-icon-previous', 'momizat-icon-next', 'momizat-icon-eject', 'momizat-icon-volume-high', 'momizat-icon-volume-medium', 'momizat-icon-volume-low', 'momizat-icon-volume-mute', 'momizat-icon-volume-mute2', 'momizat-icon-volume-increase', 'momizat-icon-volume-decrease', 'momizat-icon-loop', 'momizat-icon-loop2', 'momizat-icon-loop3', 'momizat-icon-shuffle', 'momizat-icon-arrow-up-left', 'momizat-icon-arrow-up', 'momizat-icon-arrow-up-right', 'momizat-icon-arrow-right', 'momizat-icon-arrow-down-right', 'momizat-icon-arrow-down', 'momizat-icon-arrow-down-left', 'momizat-icon-arrow-left', 'momizat-icon-arrow-up-left2', 'momizat-icon-arrow-up2', 'momizat-icon-arrow-up-right2', 'momizat-icon-arrow-right2', 'momizat-icon-arrow-down-right2', 'momizat-icon-arrow-down2', 'momizat-icon-arrow-down-left2', 'momizat-icon-arrow-left2', 'momizat-icon-arrow-up-left3', 'momizat-icon-arrow-up3', 'momizat-icon-arrow-up-right3', 'momizat-icon-arrow-right3', 'momizat-icon-arrow-down-right3', 'momizat-icon-arrow-down3', 'momizat-icon-arrow-down-left3', 'momizat-icon-arrow-left3', 'momizat-icon-tab', 'momizat-icon-checkbox-checked', 'momizat-icon-checkbox-unchecked', 'momizat-icon-checkbox-partial', 'momizat-icon-radio-checked', 'momizat-icon-radio-unchecked', 'momizat-icon-crop', 'momizat-icon-scissors', 'momizat-icon-filter', 'momizat-icon-filter2', 'momizat-icon-font', 'momizat-icon-text-height', 'momizat-icon-text-width', 'momizat-icon-bold', 'momizat-icon-underline', 'momizat-icon-italic', 'momizat-icon-strikethrough', 'momizat-icon-omega', 'momizat-icon-sigma', 'momizat-icon-table', 'momizat-icon-table2', 'momizat-icon-insert-template', 'momizat-icon-pilcrow', 'momizat-icon-left-toright', 'momizat-icon-right-toleft', 'momizat-icon-paragraph-left', 'momizat-icon-paragraph-center', 'momizat-icon-paragraph-right', 'momizat-icon-paragraph-justify', 'momizat-icon-paragraph-left2', 'momizat-icon-paragraph-center2', 'momizat-icon-paragraph-right2', 'momizat-icon-paragraph-justify2', 'momizat-icon-indent-increase', 'momizat-icon-indent-decrease', 'momizat-icon-new-tab', 'momizat-icon-embed', 'momizat-icon-code', 'momizat-icon-console', 'momizat-icon-share', 'momizat-icon-mail', 'momizat-icon-mail2', 'momizat-icon-mail3', 'momizat-icon-mail4', 'momizat-icon-google', 'momizat-icon-google-plus', 'momizat-icon-google-plus2', 'momizat-icon-google-plus3', 'momizat-icon-google-plus4', 'momizat-icon-google-drive', 'momizat-icon-facebook', 'momizat-icon-facebook2', 'momizat-icon-facebook3', 'momizat-icon-instagram', 'momizat-icon-twitter', 'momizat-icon-twitter2', 'momizat-icon-twitter3', 'momizat-icon-feed2', 'momizat-icon-feed3', 'momizat-icon-feed4', 'momizat-icon-youtube', 'momizat-icon-youtube2', 'momizat-icon-vimeo', 'momizat-icon-vimeo2', 'momizat-icon-vimeo3', 'momizat-icon-lanyrd', 'momizat-icon-flickr', 'momizat-icon-flickr2', 'momizat-icon-flickr3', 'momizat-icon-flickr4', 'momizat-icon-picassa', 'momizat-icon-picassa2', 'momizat-icon-dribbble', 'momizat-icon-dribbble2', 'momizat-icon-dribbble3', 'momizat-icon-forrst', 'momizat-icon-forrst2', 'momizat-icon-deviantart', 'momizat-icon-deviantart2', 'momizat-icon-steam', 'momizat-icon-steam2', 'momizat-icon-github', 'momizat-icon-github2', 'momizat-icon-github3', 'momizat-icon-github4', 'momizat-icon-github5', 'momizat-icon-wordpress', 'momizat-icon-wordpress2', 'momizat-icon-joomla', 'momizat-icon-blogger', 'momizat-icon-blogger2', 'momizat-icon-tumblr', 'momizat-icon-tumblr2', 'momizat-icon-yahoo', 'momizat-icon-tux', 'momizat-icon-apple', 'momizat-icon-finder', 'momizat-icon-android', 'momizat-icon-windows', 'momizat-icon-windows8', 'momizat-icon-soundcloud', 'momizat-icon-soundcloud2', 'momizat-icon-skype', 'momizat-icon-reddit', 'momizat-icon-linkedin', 'momizat-icon-lastfm', 'momizat-icon-lastfm2', 'momizat-icon-delicious', 'momizat-icon-stumbleupon', 'momizat-icon-stumbleupon2', 'momizat-icon-stackoverflow', 'momizat-icon-pinterest', 'momizat-icon-pinterest2', 'momizat-icon-xing', 'momizat-icon-xing2', 'momizat-icon-flattr', 'momizat-icon-foursquare', 'momizat-icon-foursquare2', 'momizat-icon-paypal', 'momizat-icon-paypal2', 'momizat-icon-paypal3', 'momizat-icon-yelp', 'momizat-icon-libreoffice', 'momizat-icon-file-pdf', 'momizat-icon-file-openoffice', 'momizat-icon-file-word', 'momizat-icon-file-excel', 'momizat-icon-file-zip', 'momizat-icon-file-powerpoint', 'momizat-icon-file-xml', 'momizat-icon-file-css', 'momizat-icon-html5', 'momizat-icon-html52', 'momizat-icon-css3', 'momizat-icon-chrome', 'momizat-icon-firefox', 'momizat-icon-IE', 'momizat-icon-opera', 'momizat-icon-safari', 'momizat-icon-IcoMoon')
			)
		) 

		);

	}

		// --------------------------------------------------------------------------		
		
		/**
		 * Return an instance of this class.
		 *
		 * @since	 1.0.0
		 *
		 * @return	object	A single instance of this class.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
			}

			return self::$instance;

		}
		

	}
//new Momizat_Shortcodes_editor;
add_action( 'init', array( 'Momizat_Shortcodes_editor', 'get_instance' ) );

}