jQuery(document).ready(function($) {
var backdrop = $('.mse-modal-backdrop');

var	selector = $('.mse-modal-content').find('.momizat-shortcodes-selector'),
	settings = $('.mse-modal-content').find('.mom-shortcode-settings'),
	loader = $('.mse-modal-content').find('.mse-loader'),
	footer = $('.mse-modal-footer'),
    orig_header_text = $('.mse-modal-header h3').text();
    

//open modal
	$('body').on('click', '.mom_shortcodes_editor_button', function(e) {
			e.preventDefault();
			$('.mse-modal-wrap').addClass('modal-on');
			backdrop.addClass('modal-on');
	});
function mse_reset_modal(hard) {
	if (typeof hard === 'undefined') {
		hard = false;
	}
	if (hard == true) {
		$('.mse-modal-wrap').removeClass('modal-on');
    	backdrop.removeClass('modal-on');
		$('.mse-back-to-selector').remove();
	}
	selector.show();
	settings.hide();
	footer.hide();
	$('.mse-modal').find('.mg-tabs.mg-settings-tabs').remove();
    $('.mse-modal-header h3').removeClass('with-back-button').html(orig_header_text);
}
//close modal
$('body').on('click', '.mse-modal-close, .mse-modal-backdrop', function(e) {
    e.stopPropagation();
    e.preventDefault();
	mse_reset_modal(true);
});

$(document).keydown(function(e) {
    e.stopPropagation();
    code = e.keyCode;
    if ( code == 27 ) {
		mse_reset_modal(true);
    }
});

$('body').on('click','.mse-back-to-selector.active', function(e){
	   e.preventDefault();
		mse_reset_modal(false);
		$(this).remove();
});

$('body').on('click','.mom_shortcode', function(e){
	   e.preventDefault();
       var t = $(this);
       var type = t.data('type');
       var is_container = t.data('is_container');
       var txt = t.html();
       var params = $('.mse-elements-params .'+type+'_shortcode_params').data('params');
       params = params['params'];
     	params = JSON.stringify(params);
        $('.mse-modal-header h3').html(txt);
        jQuery.ajax({
            type: "post",
            url: momShortcodes.url,
                        dataType: 'html',
                        data: "action=mom_shortcode_settings&nonce="+momShortcodes.nonce+"&params="+params,
                        beforeSend: function() {
                        	selector.hide();
                        	loader.show();
                            t.parents('.mse-modal').find('.mse-modal-header h3').addClass('with-back-button').append('<a href="#" class="mse-back-to-selector"><i class="fa-arrow-left"></i>'+momShortcodes.back_to_selector+'</a>')
                        },
            			success: function(data){
                			settings.html(data);
                			mse_fields();
                            $('.mse-back-to-selector').addClass('active');
	                    },
	                    complete : function() {
                        	loader.hide();
	                    	settings.show();
	                    	settings.attr('data-type', type);
                            settings.attr('data-is_container', is_container);
	                    	footer.show();
	                    }

                });

});

function mse_categories() {
				var modal = $('.mse-modal');
                /*-----------------------------------
                            Tabs
                -----------------------------------*/
                var groups = {};
                $('.mom_shortcode_container').each(function(i, el) {
                    var group = $(el).data('category');
                    if (typeof group !== 'undefined') {
                        groups[group] = group;
                    }
                });
                //console.log(groups);
                var gps = Object.keys(groups);
                if (gps.length > 1) {
                    modal.find('.mse-modal-content').before('<ul class="mg-tabs mg-settings-tabs"></ul>');
                    $.each(gps, function(k, v) {
                        var c = '';
                        if (k === 0) {
                            c = 'class="current"';
                        }
                        raw_v = v.split(' ').join('-');

                        modal.find('.mg-tabs').append('<li><a href="#tabs-content-'+raw_v+'" '+c+'>'+v+'</a></li>');
                        modal.find('.mom_shortcode_container[data-category="'+v+'"]').wrapAll('<div class="mg-tabs-content" id="tabs-content-'+raw_v+'"></div>');
                    });
                    modal.find('.mg-tabs-content').wrapAll('<div class="mg-tabs-container"></div>');
                    modal.find('.mg-tabs-content:not(:first-child)').addClass('hide');
                    $('body').on('click', '.mg-tabs li a', function(event) {
                        event.preventDefault();

                        modal.find('.mg-tabs li a').removeClass('current');
                        $(this).addClass('current');
                        modal.find('.mg-tabs-content').addClass('hide');
                        modal.find($(this).attr('href')).removeClass('hide');
                    });
                }
}
// fields function 
function mse_fields() {
				var modal = $('.mse-modal');
                /*-----------------------------------
                            Tabs
                -----------------------------------*/
                var groups = {};
                $('.mg-modal-field').each(function(i, el) {
                    var group = $(el).data('group');
                    if (typeof group !== 'undefined') {
                        groups[group] = group;
                    }
                });
                //console.log(groups);
                var gps = Object.keys(groups);
                if (gps.length > 1) {
                    modal.find('.mse-modal-content').before('<ul class="mg-tabs mg-settings-tabs"></ul>');
                    $.each(gps, function(k, v) {
                        var c = '';
                        if (k === 0) {
                            c = 'class="current"';
                        }
                        raw_v = v.split(' ').join('-');

                        modal.find('.mg-tabs').append('<li><a href="#tabs-content-'+raw_v+'" '+c+'>'+v+'</a></li>');
                        modal.find('.mg-modal-field[data-group="'+v+'"]').wrapAll('<div class="mg-tabs-content" id="tabs-content-'+raw_v+'"></div>');
                    });
                    modal.find('.mg-tabs-content').wrapAll('<div class="mg-tabs-container"></div>');
                    modal.find('.mg-tabs-content:not(:first-child)').addClass('hide');
                    $('body').on('click', '.mg-tabs li a', function(event) {
                        event.preventDefault();

                        modal.find('.mg-tabs li a').removeClass('current');
                        $(this).addClass('current');
                        modal.find('.mg-tabs-content').addClass('hide');
                        modal.find($(this).attr('href')).removeClass('hide');
                    });
                }


                /*-----------------------------------
                            Fields
                -----------------------------------*/
                // Color field
                modal.find('.mg-color-field').wpColorPicker();

                //upload
                $('.mom_upload_meta_button').click(function(e) {
                        e.preventDefault();
                        var bt = $(this);
                        var image = wp.media({
                        // mutiple: true if you want to upload multiple files at once
                        multiple: false
                        }).open()
                        .on('select', function(e){
                            // This will return the selected image from the Media Uploader, the result is an object
                            var uploaded_image = image.state().get('selection').first();
                            // We convert uploaded_image to a JSON object to make accessing it easier
                            // Output to the console uploaded_image
                            //console.log(uploaded_image);
                            var image_url = uploaded_image.toJSON().url;
                            var image_id = uploaded_image.toJSON().id;
                            var image_width = uploaded_image.toJSON().width;
                            var image_height = uploaded_image.toJSON().height;
                            // Let's assign the url value to the input field
                            bt.parent().prev().find('input.url').val(image_url);
                            bt.parent().prev().find('input.id').val(image_id);
                            bt.parent().prev().find('input.width').val(image_width);
                            bt.parent().prev().find('input.height').val(image_height);
                        });
                  });


                // Required 
                        modal.find('.mg-modal-field').each(function() {
                          var tmod = $(this);
                          var req = tmod.attr('data-required');
                          var val = tmod.attr('data-value');
                          var op = tmod.attr('data-operator');
                          var elm = tmod.parent().find('.mg-modal-field-'+req);
                          //elm.css('background', 'red');
                          if (typeof tmod.data('required') !== 'undefined') {
                            tmod.hide();
                            if (op === '!=') {
                          if (elm.attr('type') === 'radio') {
                            if (elm.filter(':checked').val() !== val) {
                              tmod.show();
                            }
                          } else if (elm.attr('type') === 'checkbox') {
                            elm.each(function() {
                                if ($(this).filter(':checked').val() !== val) {
                                  tmod.show();
                                }
                            });
                          } else {
                            if (elm.val() !== val) {
                              tmod.show();
                            }
                          }
                            elm.on('change', function() {
                              if (elm.attr('type') === 'radio') {
                                if (elm.filter(':checked').val() !== val) {
                                  tmod.show();
                                } else {
                                        tmod.hide();
                                }
                              } else if (elm.attr('type') === 'checkbox') {
                                elm.each(function() {
                                    if ($(this).filter(':checked').val() !== val) {
                                      tmod.show();
                                    } else {
                                        tmod.hide();
                                    }
                                });
                              } else {
                                if ($(this).val() !== val) {
                                    tmod.show();
                                  } else {
                                    tmod.hide();
                                  }
                            }

                            });
                          } else {
                              if (elm.attr('type') === 'radio') {
                                if (elm.filter(':checked').val() === val) {
                                  tmod.show();
                                }
                              } else if (elm.attr('type') === 'checkbox') {
                                elm.each(function() {
                                    if ($(this).filter(':checked').val() === val) {
                                      tmod.show();
                                    }
                                });
                              } else {
                                if (elm.val() === val) {
                                  tmod.show();
                                }
                              }
                            elm.on('change', function() {
                              if (elm.attr('type') === 'radio') {
                                if (elm.filter(':checked').val() === val) {
                                  tmod.show();
                                } else {
                                        tmod.hide();
                                }
                              } else if (elm.attr('type') === 'checkbox') {
                                elm.each(function() {
                                    if ($(this).filter(':checked').val() === val) {
                                      tmod.show();
                                    } else {
                                        tmod.hide();
                                    }
                                });
                              } else {
                                if ($(this).val() === val) {
                                    tmod.show();
                                  } else {
                                    tmod.hide();
                                  }
                            }
                                });
                              }

                          }
                        });
                        // required

}


//insert the shortcode 
//save Fields  
$('.mse-modal-insert').click(function(e) {
    e.preventDefault();
	mse_reset_modal(true);

    var f = $(this).parents('.mse-modal').find('.mse-modal-content').find('input,select,textarea');
    sc = '';
    c = '';
    r = {};
    f.each(function(i,fel) {
        fel = $(fel);
        var name = fel.attr('name');
        var type = fel.attr('type');
        if (fel.val() !== '' && typeof name !== typeof undefined && name !== false) {
            if (fel.attr('type') == 'checkbox' || fel.attr('type') == 'radio') {
                if (fel.is(':checked')) {
                    r[name] = fel.val();
                    //build the shortcode
                    if (! fel.hasClass('mom-mg-editor') ) {
                        sc += ' '+name+"='"+fel.val()+"' ";
                    }
                }
            } else {
                    //build the shortcode
                        r[name] = $.trim(fel.val());
                    if (! fel.hasClass('mom-mg-editor') && name != 'content') {
                        sc += ' '+name+"='"+fel.val()+"'";
                    } 
                    if (fel.hasClass('mom-mg-editor') || name == 'content') {
                        c = $.trim(fel.val());
                    }
            }
        }
    });
    var is_container = settings.attr('data-is_container');
    var shortcode = '['+settings.attr('data-type')+sc+']';
    	if (c !== '' || is_container == 1) {
    		shortcode += c+'[/'+settings.attr('data-type')+']';
    	}
        // Save original activeeditor
        window.mom_mse_wpActiveEditor = window.wpActiveEditor;
        // Insert shortcode
        window.wp.media.editor.insert(shortcode);
        // Restore previous editor
        window.wpActiveEditor = window.mom_mse_wpActiveEditor;
    console.log(is_container);

});


//live search 
setTimeout(function() {
    jQuery("#mse-mom_icons_filter").focus();
}, 1000);
    $("body").on('keyup', '#mse-mom_icons_filter', function(){
        // Retrieve the input field text and reset the count to zero
        var filter = $(this).val(), count = 0;

        // Loop through the icons
        $(".mom_shortcodes_icon").each(function(){
            var classname = $('i', this).attr('class');
            // If the list item does not contain the text phrase fade it out
            if (classname.search(new RegExp(filter, "i")) < 0) { // use the variable here
                $(this).hide();

            // Show the list item if the phrase matches and increase the count by 1
            } else {
                $(this).fadeIn();
                count++;
            }
        });

    });

});