<?php
/**
 * @package Case-Themes
 */
$archive_readmore_text = floka()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'floka'));
$featured_img_size = floka()->get_theme_opt('featured_img_size', '960x460');
$post_video_link = get_post_meta(get_the_ID(), 'post_video_link', true);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
    <?php if (has_post_thumbnail()) {
        $img  = pxl_get_image_by_size( array(
            'attach_id'  => get_post_thumbnail_id($post->ID),
            'thumb_size' => $featured_img_size,
        ) );
        $thumbnail    = $img['thumbnail'];
        echo '<div class="pxl-item--image">'; ?>
        <a href="<?php echo esc_url( get_permalink()); ?>"><?php echo pxl_print_html($thumbnail); ?></a>
        <?php if(!empty($post_video_link)) : ?>
            <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video btn-video-style2 pxl-action-popup"><i class="caseicon-play1"></i></a>
        <?php endif; ?>
        <?php echo '</div>';
    } ?>
    <div class="pxl-item--holder">
        <h2 class="pxl-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="caseicon-check-mark pxl-mr-4"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
        <?php floka()->blog->get_archive_meta(); ?>
        <div class="pxl-item--excerpt">
            <?php
            floka()->blog->get_excerpt();
            wp_link_pages( array(
                'before'      => '<div class="page-links">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) );
            ?>
        </div>
        <div class="pxl-item--readmore">
            <a class="btn-icon-box" href="<?php echo esc_url( get_permalink()); ?>">
                <span class="pxl--btn-text"><?php echo pxl_print_html($archive_readmore_text); ?></span>
                <span class="pxl--btn-icon pxl-ml-8">
                    <svg class="pxl-icon--before" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.2428 4.41082C10.5682 4.08539 11.0959 4.08539 11.4213 4.41082L16.4213 9.41083C16.7467 9.73625 16.7467 10.2639 16.4213 10.5893L11.4213 15.5893C11.0959 15.9147 10.5682 15.9147 10.2428 15.5893C9.91737 15.2639 9.91737 14.7362 10.2428 14.4108L13.8202 10.8334H4.16536C3.70513 10.8334 3.33203 10.4603 3.33203 10.0001C3.33203 9.53983 3.70513 9.16675 4.16536 9.16675H13.8202L10.2428 5.58934C9.91737 5.2639 9.91737 4.73626 10.2428 4.41082Z" fill="#FFF"/>
                    </svg>


                    <svg class="pxl-icon--after" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.2428 4.41082C10.5682 4.08539 11.0959 4.08539 11.4213 4.41082L16.4213 9.41083C16.7467 9.73625 16.7467 10.2639 16.4213 10.5893L11.4213 15.5893C11.0959 15.9147 10.5682 15.9147 10.2428 15.5893C9.91737 15.2639 9.91737 14.7362 10.2428 14.4108L13.8202 10.8334H4.16536C3.70513 10.8334 3.33203 10.4603 3.33203 10.0001C3.33203 9.53983 3.70513 9.16675 4.16536 9.16675H13.8202L10.2428 5.58934C9.91737 5.2639 9.91737 4.73626 10.2428 4.41082Z" fill="#FFF"/>
                    </svg>
                </span>
            </a>
        </div>
    </div>
</article>