<?php

add_action( 'pxl_post_metabox_register', 'floka_page_options_register' );
function floka_page_options_register( $metabox ) {

	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'floka' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'floka' ),
					'icon'   => 'el el-cog',
					'fields' => array_merge(
						floka_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						floka_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(

							array(
								'id'	=> 'type_post_feature',
								'type'	=> 'button_set',
								'title'	=> esc_html__('Post Feature','floka'),
								'options'	=>  array(
									'default'	=> esc_html__('Default','floka'),
									'video_link'=> esc_html__('Video','floka'),
									'image_swiper'	=> esc_html__('Image Swiper','floka'),
								),
								'default'	=> 'default',	
							),
							array(
								'id'=> 'post_video_link',
								'type' => 'text',
								'title' => esc_html__('Video Link', 'floka'),
								'validate' => 'url',
								'default' => '',
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'video_link' ),
							),
							array(
								'id'       => 'post_images',
								'type'     => 'gallery',
								'title'    => esc_html__('Images', 'floka'),
								'default'  => array(),
								'url'      => '',
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'image_swiper' ),
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'floka' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=> 'description_post',
								'type' => 'textarea',
								'title' => esc_html__('Description Post', 'floka'),
							),

						)
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'floka' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'floka' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						floka_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						floka_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header Display', 'floka'),
								'options'  => array(
									'show' => esc_html__('Show', 'floka'),
									'hide'  => esc_html__('Hide', 'floka'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'page_mobile_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Mobile Style', 'floka'),
								'options'  => array(
									'inherit'  => esc_html__('Inherit', 'floka'),
									'light'  => esc_html__('Light', 'floka'),
									'dark'  => esc_html__('Dark', 'floka'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile Logo Dark', 'floka'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'logo_light_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile Logo Light', 'floka'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'logo_pg',
								'type'     => 'media',
								'title'    => esc_html__('Logo Search', 'floka'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'floka' ),
								'options'  => floka_get_nav_menu_slug(),
								'default' => '',
								'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky Scroll', 'floka'),
								'options'  => array(
									'-1' => esc_html__('Inherit', 'floka'),
									'pxl-sticky-stt' => esc_html__('Scroll To Top', 'floka'),
									'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'floka'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('Margin', 'floka'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'floka' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						floka_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
					)
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'floka' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						floka_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'floka' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
						)
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'floka' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						floka_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'footer_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer Display', 'floka'),
								'options'  => array(
									'show' => esc_html__('Show', 'floka'),
									'hide'  => esc_html__('Hide', 'floka'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_footer_fixed',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer Fixed', 'floka'),
								'options'  => array(
									'inherit' => esc_html__('Inherit', 'floka'),
									'on' => esc_html__('On', 'floka'),
									'off' => esc_html__('Off', 'floka'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'back_top_top_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Back to Top Style', 'floka'),
								'options'  => array(
									'style-default' => esc_html__('Default', 'floka'),
									'style-round' => esc_html__('Round', 'floka'),
								),
								'default'  => 'style-default',
							),
						)
					)
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'floka' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id'        => 'page_body_color',
								'type'      => 'color',
								'title'     => esc_html__('Body Background Color', 'floka'),
								'default'   => '',
								'transparent' => false,
								'output'    => array(
									'background-color' => 'body',
								)
							),
							array(
								'id'          => 'color_primary',
								'type'        => 'color',
								'title'       => esc_html__('Primary Color', 'floka'),
								'transparent' => false,
								'default'     => ''
							),
							array(
								'id'          => 'gradient_color',
								'type'        => 'color_gradient',
								'title'       => esc_html__('Gradient Color', 'floka'),
								'transparent' => false,
								'default'  => array(
									'from' => '',
									'to'   => '', 
								),
							),
						)
					)
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'floka' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id' => 'body_custom_class',
								'type' => 'text',
								'title' => esc_html__('Body Custom Class', 'floka'),
							),
							array(
								'id'           => 'loading_page',
								'type'         => 'button_set',
								'title'        => esc_html__( 'Loading', 'floka' ),
								'options'      => array(
									'-1'  	   => esc_html__( 'Inherit', 'floka' ),
									'bd' 	   => esc_html__( 'Custom', 'floka' ),
								),
								'default'      => '-1',
							),
							array(
								'id'       => 'site_loader',
								'type'     => 'button_set',
								'title'    => esc_html__('Site Loader', 'floka'),
								'options'  => array(
									'on' => esc_html__('On', 'floka'),
									'off' => esc_html__('Off', 'floka'),
								),
								'default'  => 'off',
								'required' => array( 0 => 'loading_page', 1 => 'equals', 2 => 'bd' ),
							),
							array(
								'id'       => 'site_loader_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Site Loader Style', 'floka'),
								'options'  => array(
									'style-1' => esc_html__('Style 1', 'floka'),
									'style-2' => esc_html__('Style 2', 'floka'),
								),
								'default'  => 'style-1',
								'required' => array( 0 => 'site_loader', 1 => 'equals', 2 => 'on' ),
								'force_output' => true
							),
						)
					)
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'floka' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'floka' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'floka' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),

							array(
								'id'       => 'portfolio_icon_type',
								'type'     => 'button_set',
								'title'    => esc_html__('Icon Type', 'floka'),
								'options'  => array(
									'icon'  => esc_html__('Icon', 'floka'),
									'image'  => esc_html__('Image', 'floka'),
								),
								'default'  => 'icon'
							),
							array(
								'id'       => 'portfolio_icon_font',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon', 'floka'),
								'required' => array( 0 => 'portfolio_icon_type', 1 => 'equals', 2 => 'icon' ),
								'force_output' => true
							),
							array(
								'id'       => 'portfolio_icon_img',
								'type'     => 'media',
								'title'    => esc_html__('Icon Image', 'floka'),
								'default' => '',
								'required' => array( 0 => 'portfolio_icon_type', 1 => 'equals', 2 => 'image' ),
								'force_output' => true
							),
						)
					)
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'floka' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'floka' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'service_external_link',
								'type' => 'text',
								'title' => esc_html__('External Link', 'floka'),
								'validate' => 'url',
								'default' => '',
							),
							array(
								'id'=> 'service_excerpt',
								'type' => 'textarea',
								'title' => esc_html__('Excerpt', 'floka'),
								'validate' => 'html_custom',
								'default' => '',
							),
							array(
								'id'       => 'service_icon_type',
								'type'     => 'button_set',
								'title'    => esc_html__('Icon Type', 'floka'),
								'options'  => array(
									'icon'  => esc_html__('Icon', 'floka'),
									'image'  => esc_html__('Image', 'floka'),
								),
								'default'  => 'icon'
							),
							array(
								'id'       => 'service_icon_font',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('Icon', 'floka'),
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
								'force_output' => true
							),
							array(
								'id'       => 'service_icon_img',
								'type'     => 'media',
								'title'    => esc_html__('Icon Image', 'floka'),
								'default' => '',
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
								'force_output' => true
							),

							array(
								'id'=>'service_multi_text',
								'type' => 'multi_text',
								'title' => esc_html__('Multi Text Option', 'floka'),
								'desc'      => esc_html__('Enter text and corresponding link in format: Text|Link', 'floka'), 
							),

							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'floka' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						),
						floka_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
					)
				],
			]
		],

		'careers' => [
			'opt_name'            => 'pxl_careers_options',
			'display_name'        => esc_html__( 'Careers Options', 'floka' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'floka' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'careers_external_link',
								'type' => 'text',
								'title' => esc_html__('External Link', 'floka'),
								'validate' => 'url',
								'default' => '',
							),
							array(
								'id'=> 'careers_excerpt',
								'type' => 'textarea',
								'title' => esc_html__('Excerpt', 'floka'),
								'validate' => 'html_custom',
								'default' => '',
							),
							
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'floka' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						),
						floka_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
					)
				],
			]
		],

		'pxl-template' => [ //post_type
		'opt_name'            => 'pxl_hidden_template_options',
		'display_name'        => esc_html__( 'Template Options', 'floka' ),
		'show_options_object' => false,
		'context'  => 'advanced',
		'priority' => 'default',
		'sections'  => [
			'header' => [
				'title'  => esc_html__( 'General', 'floka' ),
				'icon'   => 'el-icon-website',
				'fields' => array(
					array(
						'id'    => 'template_type',
						'type'  => 'select',
						'title' => esc_html__('Type', 'floka'),
						'options' => [
							'df'       	   => esc_html__('Select Type', 'floka'), 
							'header'       => esc_html__('Header Desktop', 'floka'),
							'header-mobile'       => esc_html__('Header Mobile', 'floka'),
							'footer'       => esc_html__('Footer', 'floka'), 
							'mega-menu'    => esc_html__('Mega Menu', 'floka'), 
							'page-title'   => esc_html__('Page Title', 'floka'), 
							'post-title'   => esc_html__('Post Title', 'floka'), 
							'tab' => esc_html__('Tab', 'floka'),
							'hidden-panel' => esc_html__('Hidden Panel', 'floka'),
							'popup' => esc_html__('Popup', 'floka'),
							'page' => esc_html__('Page', 'floka'),
							'slider' => esc_html__('Slider', 'floka'),
							'widget'          => esc_html__('Widget Sidebar', 'floka'),
						],
						'default' => 'df',
					),
					array(
						'id'    => 'header_type',
						'type'  => 'select',
						'title' => esc_html__('Header Type', 'floka'),
						'options' => [
							'px-header--default'       	   => esc_html__('Default', 'floka'), 
							'px-header--transparent'       => esc_html__('Transparent', 'floka'),
							'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'floka'),
						],
						'default' => 'px-header--default',
						'indent' => true,
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
					),

					array(
						'id'    => 'header_mobile_type',
						'type'  => 'select',
						'title' => esc_html__('Header Type', 'floka'),
						'options' => [
							'px-header--default'       	   => esc_html__('Default', 'floka'), 
							'px-header--transparent'       => esc_html__('Transparent', 'floka'),
						],
						'default' => 'px-header--default',
						'indent' => true,
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
					),

					array(
						'id'    => 'hidden_panel_position',
						'type'  => 'select',
						'title' => esc_html__('Hidden Panel Position', 'floka'),
						'options' => [
							'top'       	   => esc_html__('Top', 'floka'),
							'right'       	   => esc_html__('Right', 'floka'),
							'center'       	   => esc_html__('Center', 'floka'),
						],
						'default' => 'right',
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
					),
					array(
						'id'          => 'hidden_panel_height',
						'type'        => 'text',
						'title'       => esc_html__('Hidden Panel Height', 'floka'),
						'subtitle'       => esc_html__('Enter number.', 'floka'),
						'transparent' => false,
						'default'     => '',
						'force_output' => true,
						'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
					),
					array(
						'id'          => 'hidden_panel_boxcolor',
						'type'        => 'color',
						'title'       => esc_html__('Box Color', 'floka'),
						'transparent' => false,
						'default'     => '',
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
					),
					array(
						'id'          => 'header_sidebar_width',
						'type'        => 'slider',
						'title'       => esc_html__('Header Sidebar Width', 'floka'),
						"default"   => 300,
						"min"       => 50,
						"step"      => 1,
						"max"       => 900,
						'force_output' => true,
						'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
					),

					array(
						'id'    => 'header_sidebar_style',
						'type'  => 'select',
						'title' => esc_html__('Header Sidebar Style', 'floka'),
						'options' => [
							'px-header-sidebar-style1'      => esc_html__('Style 1', 'floka'), 
							'px-header-sidebar-style2'      => esc_html__('Style 2', 'floka'),
						],
						'default' => 'px-header-sidebar-style1',
						'indent' => true,
						'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
					),
				),

			],
		]
	],
];

$metabox->add_meta_data( $panels );
}
