<?php
// Register Text Editor
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_text_editor',
        'title' => esc_html__('Case Text Editor', 'floka'),
        'icon' => 'eicon-text',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Text Editor', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'text_ed',
                            'label' => '',
                            'type' => Controls_Manager::WYSIWYG,
                            'default' => esc_html__( 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'floka' ),
                            'description' => 'Create Highlight text width shortcode: [pxl_highlight text="Text Demo"]',
                        ),
                        array(
                            'name'  => 'text_first_letter',
                            'label' => esc_html__('First Letter','floka'),
                            'type'  => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'false',
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'floka' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-text-editor' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};'
                        ],
                    ),
                        array(
                            'name' => 't_width',
                            'label' => esc_html__('Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor .pxl-item--inner' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'flex_grow',
                            'label' => esc_html__('Flex Grow', 'floka' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'inherit' => [
                                    'title' => esc_html__( 'Inherit', 'floka' ),
                                    'icon' => 'fas fa-arrows-alt-v',
                                ],
                                '1' => [
                                    'title' => esc_html__( 'Full', 'floka' ),
                                    'icon' => 'fas fa-arrows-alt-h',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}' => 'flex-grow: {{VALUE}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'section_style_text',
    'label' => esc_html__( 'Text', 'floka' ),
    'tab' => Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style_text_color',
            'label' => esc_html__('Style Text Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Text Normal',
                'text-gradient' => 'Text Gradient',
            ],
            'default' => '',
        ),
        array(
            'name' => 'text_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor' => 'color: {{VALUE}};',
            ],
            'condition' => [
                'style_text_color' => '',
            ],
        ),

        array(
            'name' => 'text_color_from',
            'label' => esc_html__( 'Color From', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor' => 'color: {{VALUE}};',
            ],
            'condition' => [
                'style_text_color' => 'text-gradient',
            ],
        ),
        array(
            'name' => 'text_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'floka' ),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor p',
        ),
        array(
            'name'  => 'heading_first_letter',
            'label' => esc_html__('FIRST LETTER','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => [
                'text_first_letter' => 'true',
            ],
        ),
        array(
            'name' => 'first_letter_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor p:first-letter' => 'color: {{VALUE}};',
            ],
            'condition' => [
                'text_first_letter' => 'true',
            ],
        ),
        array(
            'name' => 'first_letter_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'floka' ),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor p:first-letter',
            'condition' => [
                'text_first_letter' => 'true',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_link',
    'label' => esc_html__( 'Link', 'floka' ),
    'tab' => Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'link_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor a' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'link_color_hover',
            'label' => esc_html__( 'Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor a:hover' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'link_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'floka' ),
            'selector' => '{{WRAPPER}} .pxl-text-editor a',
            'control_type' => 'group',
        ),
    ),
),
array(
    'name' => 'section_style_title_highlight',
    'label' => esc_html__('Highlight', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'highlight_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'highlight_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight',
        ),

        array(
                'name' => 'highlight_margin',
                'label' => esc_html__('Margin', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'control_type' => 'responsive',
            ),
    ),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);