<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );

pxl_add_custom_widget(
    array(
        'name' => 'pxl_testimonial_carousel',
        'title' => esc_html__('Case Testimonial Carousel', 'floka'),
        'icon' => 'eicon-testimonial',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout1.jpg',
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout2.jpg',
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout3.jpg',
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout4.jpg',
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_settings_carousel',
                    'label' => esc_html__('Settings', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 336x400 (Width x Height)).',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                                'progressbar' => 'Progressbar',
                            ],
                            'condition' => [
                                'pagination'    => 'true',
                            ],
                        ),

                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),

                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'description' => 'Default: 15',
                            'default'   => [
                                'size'  => 15,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-container' => 'margin-block:-{{SIZE}}px; margin-inline:-{{SIZE}}px',
                                '{{WRAPPER}} .pxl-swiper-slide' => 'padding-block: {{SIZE}}px; padding-inline:{{SIZE}}px',
                            ],
                            'condition' => [
                                'layout!'    => ['3','4'],
                            ],
                        ),
                    ),
),
array(
    'name' => 'section_content',
    'label' => esc_html__('Content', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'controls' => array(
        array(
            'name' => 'testimonial',
            'label' => esc_html__('Testimonial', 'floka'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'title',
                    'label' => esc_html__('Title', 'floka'),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ),
                array(
                    'name' => 'position',
                    'label' => esc_html__('Position', 'floka'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'desc',
                    'label' => esc_html__('Description', 'floka' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'show_label' => false,
                ),
                array(
                    'name' => 'subtitle',
                    'label' => esc_html__('Subtitle', 'floka' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'description'   => 'Applies to some layouts!',
                ),
                array(
                    'name' => 'star',
                    'label' => esc_html__('Star Rating', 'floka' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        '1' => '1 star',
                        '2' => '2 stars',
                        '3' => '3 stars',
                        '4' => '4 stars',
                        '5' => '5 stars',
                    ],
                    'default' => '5',
                ),
                array(
                    'name' => 'image',
                    'label' => esc_html__('Image', 'floka' ),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                ),
                array(
                    'name' => 'image_thumbs',
                    'label' => esc_html__('Image Thumbs', 'floka' ),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                    'description'   => 'Applies to layout 4!',
                ),



            ),
            'title_field' => '{{{ title }}}',
        ),


        array(
            'name' => 'height_carousel_vertical',
            'label' => esc_html__('Height Carousel', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', 'custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'description'   => esc_html__('Applies to vertical carousel layout only!','floka'),
            'selectors' => [
                '{{WRAPPER}} .swiper-vertical' => 'height: {{SIZE}}{{UNIT}};'
            ],
            'condition' => [
                'layout'    => '3',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
        'layout'    => ['2','3']
    ],
    'controls' => array(
        array(
            'name' => 'line_color',
            'label' => esc_html__('Line Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl--author' => 'border-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'gap_item',
            'label' => esc_html__('Gap Item', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl--author' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'layout'    => ['3']
            ],
        ),
        array(
            'name' => 'padding_item',
            'label' => esc_html__('Padding Item', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--inner ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            
        ),
    ),
),

array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--title:not(.wg_title)',
        ),
    ),
),
array(
    'name' => 'section_style_desc',
    'label' => esc_html__('Description', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'desc_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--desc' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--desc',
        ),
    ),
),

array(
    'name' => 'section_style_position',
    'label' => esc_html__('Position', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
       array(
        'name' => 'position_color',
        'label' => esc_html__('Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--position' => 'color: {{VALUE}};',
        ],
    ),
       array(
        'name' => 'position_typography',
        'label' => esc_html__('Typography', 'floka' ),
        'type' => \Elementor\Group_Control_Typography::get_type(),
        'control_type' => 'group',
        'selector' => '{{WRAPPER}}  .pxl-testimonial-carousel .pxl-swiper-arrow-wrap .pxl-swiper-slide .pxl-info--author .pxl-item--position',
    ),
   ),
),

array(
    'name' => 'section_style_star',
    'label' => esc_html__('Icon', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'heading_quote',
            'label' => esc_html__('Quote','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'iconquote_color',
            'label' => esc_html__('Quote Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-icon--quote' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-icon--quote svg path' => 'fill: {{VALUE}};',
            ],
        ),


        array(
            'name'  => 'heading_star_rating',
            'label' => esc_html__('STAR RATING','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'star_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--star i' => 'color: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'star_fontsize',
            'label' => esc_html__('Font Size', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', 'custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--star i' => 'font-size: {{SIZE}}{{UNIT}};'
            ],
        ),
    ),
),


floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);