<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_stats_box',
        'title' => esc_html__('Case Stats Box', 'floka' ),
        'icon' => ' eicon-menu-card',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => array(
                                    'label' => esc_html__('Layout 1', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_stats_box/layout1.jpg',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title', 
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label' => esc_html__( 'Title', 'floka' ),
                            'label_block' => true,
                        ),

                        array(
                            'name' => 'number', 
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label' => esc_html__( 'Number', 'floka' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'desc', 
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label' => esc_html__( 'Description', 'floka' ),
                            'label_block' => true,
                            'rows' => 3,
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                        ),
                        
                    ),
                ),

                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'heading_content',
                            'label' => esc_html__('CONTENT','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'padding_content',
                            'label' => esc_html__('Padding Content', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name'  => 'heading_line',
                            'label' => esc_html__('Line','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'line_color',
                            'label' => esc_html__( 'Line Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--inner' => 'border-bottom-color: {{VALUE}};',
                            ],
                        ),


                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('Title','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__( 'Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'title_typography',
                            'label' => esc_html__( 'Title Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-stats--box .pxl-item--title',
                        ),

                        array(
                            'name'  => 'heading_icon',
                            'label' => esc_html__('Icon','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__( 'Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--icon i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--icon svg path' => 'fill: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'fs_icon',
                            'label' => esc_html__('Fontsize Icon', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                            ],
                        ),



                        array(
                            'name'  => 'heading_number',
                            'label' => esc_html__('Number','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'number_color',
                            'label' => esc_html__( 'Number Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--number' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'number_typography',
                            'label' => esc_html__( 'Number Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-stats--box .pxl-item--number',
                        ),


                        

                        array(
                            'name'  => 'heading_desc',
                            'label' => esc_html__('Description','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__( 'Description Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-stats--box .pxl-item--desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'desc_typography',
                            'label' => esc_html__( 'Description Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-stats--box .pxl-item--desc',
                        ),
                    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);