<?php
// Register Logo Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_showcase',
        'title' => esc_html__('Case Showcase', 'floka' ),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => array(
                                    'label' => esc_html__('Layout 1', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_showcase/layout1.jpg',
                                ),
                                '2' => array(
                                    'label' => esc_html__('Layout 2', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_showcase/layout2.jpg',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Items', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'placeholder' => 'Ex: 200x100(WxH), thumbnail, medium...',
                        ),
                        array(
                            'name' => 'image_min_height',
                            'label' => esc_html__('Image Min Height', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase .pxl-item--showcase' => '--height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Preview', 'floka'),
                        ),
                        array(
                            'name' => 'button_text2',
                            'label' => esc_html__('Button Text 2', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Onepage', 'floka'),
                        ),
                        array(
                            'name' => 'coming_soon_text',
                            'label' => esc_html__('Coming Soon Text', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Coming Soon', 'floka'),
                        ),
                        array(
                            'name' => 'cases',
                            'label' => esc_html__('Cases', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'is_coming_soon',
                                    'label' => esc_html__('Cooming Soon', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SWITCHER,
                                    'return_value' => 'yes',
                                    'default'   => 'no',
                                ),

                                array(
                                    'name' => 'sub_title',
                                    'label' => esc_html__('Sub Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::WYSIWYG,
                                ),
                                
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    
                                ),
                                
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Upload', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                                array(
                                    'name' => 'link2',
                                    'label' => esc_html__('Link 2', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'layout'    => '2',
                            ],
                        ),
                    ),
),
array(
    'name' => 'tab_style',
    'label' => esc_html__('General', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(



            array(
                'name' => 'justify_content',
                'label' => esc_html__('Justify Content', 'floka' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => '',
                'options' => [
                    'start' =>  [
                        'title' => esc_html__('Start', 'floka'),
                        'icon' => 'eicon-justify-start-h',
                    ],
                    'center' =>  [
                        'title' => esc_html__('Center', 'floka'),
                        'icon' => 'eicon-justify-center-h',
                    ],
                    'end' =>  [
                        'title' => esc_html__('End', 'floka'),
                        'icon' => 'eicon-justify-end-h',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-showcase .pxl-item--inner' => 'justify-content: {{VALUE}}'
                ],
            ),
        ),
    ),
),
floka_grid_settings(false),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path(),
);