<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_rewards',
        'title' => esc_html__('Case Rewards', 'floka'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_rewards/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_rewards/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'description'   => esc_html__('Apply layout 2','floka'),
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title Rewards', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name'  => 'reward',
                                    'label' => esc_html__('Reward', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                ),


                                array(
                                    'name'  => 'title_nomination',
                                    'label' => esc_html__('Title Nomination', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                    'description'   => esc_html__('Apply to the first item of layout 2. ','floka'),
                                ),
                                array(
                                    'name'  => 'nomination',
                                    'label' => esc_html__('Nomination', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                    'description'   => esc_html__('Apply layout 2','floka'),
                                ),


                                array(
                                    'name'  => 'title_date',
                                    'label' => esc_html__('Title Date', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                    'description'   => esc_html__('Apply to the first item of layout 2.','floka'),
                                ),

                                array(
                                    'name'  => 'date',
                                    'label' => esc_html__('Date', 'floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                ),
                                
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default' => [
                                        'url' => '#',
                                    ],
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name'  => 'items_padding',
                            'label' => esc_html__('Padding Items','floka'),
                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type'  => 'responsive',
                            'size_units'    => ['px'],
                            'range' => [
                                'px'=> [
                                    'min'   => 0,
                                    'max'   => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl--item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name'  => 'items_margin',
                            'label' => esc_html__('Margin Items','floka'),
                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type'  => 'responsive',
                            'size_units'    => ['px'],
                            'range' => [
                                'px'=> [
                                    'min'   => 0,
                                    'max'   => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl--item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'border_color',
                            'label' => esc_html__('Border Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl--item' => 'border-color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'background_color',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl--item' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'background_color_hv',
                            'label' => esc_html__('Background Color Hover', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl--item.active' => 'background: {{VALUE}};',
                            ],
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('TITLE','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl-item-title,{{WRAPPER}} .pxl-rewards .pxl--title' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-rewards .pxl-item-title',
                        ),

                        array(
                            'name'  => 'heading_reward',
                            'label' => esc_html__('REWARDS','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'reward_color',
                            'label' => esc_html__('Rewards Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl-item-reward' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'reward_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-rewards .pxl-item-reward',
                        ),

                        array(
                            'name'  => 'heading_date',
                            'label' => esc_html__('DATE','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                        ),

                        array(
                            'name' => 'date_color',
                            'label' => esc_html__('Date Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-rewards .pxl-item--date' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'date_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-rewards .pxl-item--date',
                        ),

                    ),
                ),

                floka_widget_animation_settings(),
            ),
),
),
floka_get_class_widget_path()
);