<?php
$pt_supports = ['service'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_reveal',
        'title' => esc_html__('Case Post Reveal', 'floka' ),
        'icon' => 'eicon-posts-group',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'floka-effect',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'floka' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => floka_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        floka_get_post_reveal_layout($pt_supports),
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'floka' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'floka' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        floka_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        floka_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'floka' ),
                                    'ID' => esc_html__('ID', 'floka' ),
                                    'author' => esc_html__('Author', 'floka' ),
                                    'title' => esc_html__('Title', 'floka' ),
                                    'rand' => esc_html__('Random', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'floka' ),
                                    'asc' => esc_html__('Ascending', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                                'control_type' => 'responsive',

                            ),
                        )
                    ),
                ),
                
                array(
                    'name' => 'section_display',
                    'label' => esc_html__('Display', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'active',
                            'label' => esc_html__('Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'separator' => 'after',
                            'default' => '1',
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        
                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'show_button',
                            'label' => esc_html__('Show Button', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 12,
                            'separator' => 'after',
                            'control_type'  => 'responsive',
                        ),

                    ),
                ),

                array(
                    'name' => 'section_style_categories',
                    'label' => esc_html__('Categories', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'categories_color',
                            'label' => esc_html__('Categories Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-column--categories .pxl-item--category' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'border_bottom_color',
                            'label' => esc_html__('Border Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-column--categories .pxl-item--category' => 'border-bottom-color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name'  => 'heading_categories_active',
                            'label' => esc_html__('ACTIVE','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        
                        array(
                            'name' => 'categories_color_active',
                            'label' => esc_html__('Categories Color Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-column--categories .pxl-item--category.active' => 'color: {{VALUE}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'border_bottom_color_active',
                            'label' => esc_html__('Border Color Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-column--categories .pxl-item--category:before' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'categories_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-reveal .pxl-column--categories .pxl-item--category',
                        ),

                    ),
                ),

                array(
                    'name' => 'section_style_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name' => 'background_color_content',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .pxl-item--holder' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name'  => 'heading_categories_content',
                            'label' => esc_html__('Category','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        
                        array(
                            'name' => 'categories_color_content',
                            'label' => esc_html__('Category Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .pxl-item--category' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'categories_typography_content',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .pxl-item--category',
                        ),

                        array(
                            'name'  => 'heading_excerpt_content',
                            'label' => esc_html__('Exceprt','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'excerpt_color_content',
                            'label' => esc_html__('Category Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .pxl-item--excerpt' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'excerpt_typography_content',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .pxl-item--excerpt',
                        ),

                        array(
                            'name'  => 'heading_button_content',
                            'label' => esc_html__('Button','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'button_color_content',
                            'label' => esc_html__('Button Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .btn-readmore' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .btn-readmore .pxl-icon--plus:before,
                                {{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .btn-readmore .pxl-icon--plus:after' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'button_bgcolor_content',
                            'label' => esc_html__('Button Background', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-reveal .pxl-item--reveal .btn-readmore' => 'background: {{VALUE}};',
                            ],
                        ),



                    ),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);