<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_meta',
        'title' => esc_html__('Case Post Meta', 'floka' ),
        'icon' => 'eicon-post-info',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                     array(
                        'name' => 'show_category',
                        'label' => esc_html__('Show Category', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),

                     array(
                        'name' => 'show_date',
                        'label' => esc_html__('Show Date', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),

                     array(
                        'name' => 'show_comment',
                        'label' => esc_html__('Show Comment', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),

                     array(
                        'name' => 'show_views',
                        'label' => esc_html__('Show View', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),

                     array(
                        'name' => 'show_share',
                        'label' => esc_html__('Show Share', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ), 

                     array(
                        'name' => 'show_tags',
                        'label' => esc_html__('Show Tags', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),
                 ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'heading_category',
                            'label' => esc_html__('Category','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_category' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'categories_color',
                            'label' => esc_html__( 'Categories Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--categories' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_category' => 'true',
                            ],
                        ),
                        array(
                            'name'         => 'categories_typography',
                            'label' => esc_html__( 'Categories Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--categories',
                            'condition' => [
                                'show_category' => 'true',
                            ],
                        ),

                        array(
                            'name'  => 'heading_date',
                            'label' => esc_html__('Date','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_date' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'date_color',
                            'label' => esc_html__( 'Date Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--date' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_date' => 'true',
                            ],
                        ),
                        array(
                            'name'         => 'date_typography',
                            'label' => esc_html__( 'Date Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--date',
                            'condition' => [
                                'show_date' => 'true',
                            ],
                        ),

                        array(
                            'name'  => 'heading_comment',
                            'label' => esc_html__('Comment','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_comment' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'comment_iconcolor',
                            'label' => esc_html__( 'Comment Icon Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--comments i' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_comment' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'comment_color',
                            'label' => esc_html__( 'Comment Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--comments' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_comment' => 'true',
                            ],
                        ),
                        array(
                            'name'         => 'comment_typography',
                            'label' => esc_html__( 'Comment Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--comments',
                            'condition' => [
                                'show_comment' => 'true',
                            ],
                        ),

                        array(
                            'name'  => 'heading_view',
                            'label' => esc_html__('View','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_views' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'view_iconcolor',
                            'label' => esc_html__( 'View Icon Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--views i' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_views' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'view_color',
                            'label' => esc_html__( 'View Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--views' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_views' => 'true',
                            ],
                        ),
                        array(
                            'name'         => 'view_typography',
                            'label' => esc_html__( 'View Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--views',
                            'condition' => [
                                'show_views' => 'true',
                            ],
                        ),


                        array(
                            'name'  => 'heading_tag',
                            'label' => esc_html__('Tags','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'tag_color',
                            'label' => esc_html__( 'Tags Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--tags a' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),
                        array(
                            'name'         => 'tag_typography',
                            'label' => esc_html__( 'Tags Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--tags a',
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),

                        array(
                            'name'         => 'tag_border',
                            'label' => esc_html__( 'Tags Border', 'floka' ),
                            'type'         => \Elementor\Group_Control_Border::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--tags a',
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'item_tags_padding',
                            'label' => esc_html__('Padding Item', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','%','custom' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--tags a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'item_tags_border_radius',
                            'label' => esc_html__('Border Radius Item', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','%','custom' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--tags a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'condition' => [
                                'show_tags' => 'true',
                            ],
                        ),


                        array(
                            'name'  => 'heading_share',
                            'label' => esc_html__('Share','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'condition' => [
                                'show_share' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'share_color_icon',
                            'label' => esc_html__( 'Share Color Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--share .pxl--social i' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_share' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'share_color',
                            'label' => esc_html__( 'Share Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--share span' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'show_share' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'share_fs_icon',
                            'label' => esc_html__('Share Fontsize', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-meta .pxl-post--share .pxl--social i' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'show_share' => 'true',
                            ],
                        ),

                        array(
                            'name'         => 'share_typography',
                            'label' => esc_html__( 'Share Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-post-meta .pxl-post--share span',
                            'condition' => [
                                'show_share' => 'true',
                            ],
                        ),

                    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);