<?php
// Register Button Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_physics_item',
        'title' => esc_html__('Case Physics', 'floka' ),
        'icon' => 'eicon-cart-medium',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'pxl-matter-physics',
            'floka-elementor',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_physics_item/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_physics_item/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'texts',
                            'label' => esc_html__('List', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            
                            'controls' => array(
                                array(
                                    'name' => 'style_layout',
                                    'label' => esc_html__('Type', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => 'content',
                                    'options' => [
                                        'content' => esc_html__('Content', 'floka' ),
                                        'image' => esc_html__('Image', 'floka' ),
                                        'icon' => esc_html__('Icon', 'floka' ),
                                    ],
                                ), 
                                array(
                                    'name' => 'style_content',
                                    'label' => esc_html__('Style Content', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '',
                                    'options' => [
                                        '' => esc_html__('Style 1', 'floka' ),
                                        'style-2' => esc_html__('Style 2', 'floka' ),
                                    ],
                                    'condition' => [
                                        'style_layout'  => 'content',
                                    ],
                                ),

                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'condition' => [
                                        'style_layout'  => 'content'
                                    ],
                                ),

                                array(
                                    'name' => 'text_ed',
                                    'label' => '',
                                    'type' => \Elementor\Controls_Manager::WYSIWYG,
                                    'default' => esc_html__( 'Build bold identities that speak your story—visually and verbally. From websites to packaging, we design experiences.', 'floka' ),
                                    'description' => 'Create Highlight text width shortcode: [pxl_highlight text="Text Demo"]',
                                    'condition' => [
                                        'style_layout'  => 'content'
                                    ],
                                ),

                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                    'condition' => [
                                        'style_layout'  => 'image'
                                    ],
                                ),

                                array(
                                    'name' => 'item_bgcolor',
                                    'label' => esc_html__('Background', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}} .pxl-item--image' => 'background: {{VALUE}}'
                                    ],
                                    'condition' => [
                                        'style_layout'  => 'image',
                                    ],
                                ),

                                array(
                                    'name'          => 'border_item_image',
                                    'label'         => esc_html__('Border','floka'),
                                    'type'          => \Elementor\Group_Control_Border::get_type(),
                                    'control_type'  => 'group',
                                    'selector'      => '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}} .pxl-item--image',
                                    'condition' => [
                                        'style_layout'  => 'image',
                                    ],
                                ),

                                array(
                                    'name' => 'top',
                                    'label' => esc_html__('Top', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'size_units' => [ 'px', '%', 'custom' ],
                                    'range' => [
                                        'px' => [
                                            'min' => 0,
                                            'max' => 300,
                                        ],
                                        '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};'
                                    ],
                                ),
                                array(
                                    'name' => 'left',
                                    'label' => esc_html__('Left', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'size_units' => [ 'px', '%', 'custom' ],
                                    'range' => [
                                        'px' => [
                                            'min' => 0,
                                            'max' => 300,
                                        ],
                                        '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};'
                                    ],
                                ),
                                array(
                                    'name' => 'min_height_item',
                                    'label' => esc_html__('Min Height Item', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'size_units' => [ 'px', '%', 'custom' ],
                                    'range' => [
                                        'px' => [
                                            'min' => 0,
                                            'max' => 300,
                                        ],
                                        '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}} .pxl-item--content ' => 'min-height: {{SIZE}}{{UNIT}};'
                                    ],
                                ),
                                array(
                                    'name' => 'min_width_item',
                                    'label' => esc_html__('Min Width Item', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'size_units' => [ 'px', '%', 'custom' ],
                                    'range' => [
                                        'px' => [
                                            'min' => 0,
                                            'max' => 300,
                                        ],
                                        '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl--physics {{CURRENT_ITEM}} .pxl-item--content .pxl-item--text' => 'min-width: {{SIZE}}{{UNIT}};'
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'min_height',
                            'label' => esc_html__('Min Height Widget', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl--physics' => 'min-height: {{SIZE}}{{UNIT}};',
                            ],
                        ),

                    ),
                ),


            ),
        ),
    ),
    floka_get_class_widget_path()
);