<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_marquee',
        'title' => esc_html__('Case Marquee', 'floka'),
        'icon' => 'eicon-testimonial',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'items',
                            'label' => esc_html__('Items', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'type',
                                    'label' => esc_html__('Type', 'floka'),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => array(
                                        'icon' => esc_html__('Icon', 'floka'),
                                        'image' => esc_html__('Image', 'floka'),
                                        'text' => esc_html__('Text', 'floka'),
                                    ),
                                    'default' => 'icon',
                                ),
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'floka'),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'condition' => array(
                                        'type' => 'icon',
                                    ),
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'floka'),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                    'condition' => [
                                        'type' => 'image',
                                    ],
                                ),
                                array(
                                    'name' => 'image_type',
                                    'label' => esc_html__('Image Type', 'floka'),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => array(
                                        'image' => esc_html__('Image', 'floka'),
                                        'bg' => esc_html__('Background', 'floka'),
                                    ),
                                    'default' => 'image',
                                    'condition' => [
                                        'type' => 'image',
                                    ],
                                ),
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Text', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'condition' => array(
                                        'type' => ['text','image'],
                                    ),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                        ),
                    ),
                ),

                array(
                    'name' => 'section_settings_carousel',
                    'label' => esc_html__('Carousel', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'overflow_hidden',
                            'label' => esc_html__('Overflow Hidden', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'direction',
                            'label' => esc_html__('Direction', 'floka'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'ltr',
                            'options' => [
                                'ltr' => esc_html__('Left to Right', 'floka'), 
                                'rtl' => esc_html__('Right to Left', 'floka'), 
                            ]
                        ),
                        array(
                            'name' => 'duration',
                            'label' => esc_html__('Duration', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 1,
                            'description' => esc_html__('Enter number. Unit is ms', 'floka'),
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--list' => 'animation-duration: {{VALUE}}ms',
                            ],
                        ),
                        array(
                            'name' => 'delay',
                            'label' => esc_html__('Delay', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'min' => 1,
                            'description' => esc_html__('Enter number. Unit is ms', 'floka'),
                            'selectors' => [
                                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--list' => 'animation-delay: {{VALUE}}ms',
                            ],
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause On Hover', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => '',
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                     array(
                        'name' => 'style_marquee',
                        'label' => esc_html__('Style', 'floka'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '',
                        'separator' => 'after',
                        'options' => [
                            '' => esc_html__('Default', 'floka'), 
                            'style-overlay' => esc_html__('Overlay', 'floka'), 
                        ]
                    ),

                     array(
                        'name' => 'item_bgcolor',
                        'label' => esc_html__('Background Item', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--single .pxl-single--inner' => 'background: {{VALUE}}'
                        ],
                    ),

                     array(
                        'name' => 'item_border_radius',
                        'label' => esc_html__( 'Border Radius', 'floka' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                        'control_type' => 'responsive',
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--single .pxl-single--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),

                     array(
                        'name' => 'inner',
                        'label' => esc_html__('INNER', 'floka'),
                        'type' => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),
                     array(
                        'name' => 'spacing_x',
                        'label' => esc_html__('Spacer X', 'floka'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--inner' => '--x: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                     array(
                        'name' => 'max_width',
                        'label' => esc_html__('Max Width', 'floka'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee .pxl-item--container' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                    ),

                     array(
                        'name' => 'size_box',
                        'label' => esc_html__('BOX', 'floka'),
                        'type' => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),

                     array(
                        'name' => 'icon_box_size_w',
                        'label' => esc_html__('Box Size Width', 'floka'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee' => '--size-w: {{SIZE}}{{UNIT}};',
                        ],
                    ),

                     array(
                        'name' => 'icon_box_size_h',
                        'label' => esc_html__('Box Size Height', 'floka'),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'rem', 'em', 'custom'],
                        'control_type' => 'responsive',
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-marquee' => '--size-h: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                 ),
),

array(
    'name' => 'tab_style_label',
    'label' => esc_html__('Label', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'label_normal',
            'label' => esc_html__('NORMAL', 'floka' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'after', 
        ),
        array(
            'name' => 'label_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'color: {{VALUE}}'
            ],
        ),
        array(
            'name' => 'label_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--text',
        ),
        array(
            'name' => 'label_spacer_bottom',
            'label' => esc_html__('Spacing Bottom', 'floka'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'label_padding',
            'label' => esc_html__( 'Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'title_style',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'style-outline' => 'Outline',
            ],
            'default' => '',
        ),
        array(
            'name'         => 'title_style_outline',
            'label' => esc_html__( 'Text Stroke', 'floka' ),
            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-marquee .pxl-item--text',
            'condition' => [
               'title_style'  =>  'style-outline',
           ],
       ),

        array(
            'name' => 'title_style_fill',
            'label' => esc_html__('Text Fill', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--text' => '-webkit-text-fill-color: {{VALUE}};',
            ],
            'condition' => [
                'title_style' => 'style-outline',
            ],
        ),

        array(
            'name' => 'title_style_fill_hv',
            'label' => esc_html__('Text Fill Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--single .pxl-item--text' => '--fill-color: {{VALUE}};',
            ],
            'condition' => [
                'title_style' => 'style-outline',
            ],
        ),

    ),
),

array(
    'name' => 'tab_style_img',
    'label' => esc_html__('Image', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'normal',
            'label' => esc_html__('NORMAL', 'floka'),
            'type' => Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'img_size',
            'label' => esc_html__('Image Size', 'floka'),
            'type' => \Elementor\Controls_Manager::TEXT,
        ),
        array(
            'name' => 'filters',
            'label' => esc_html__('Filters', 'floka'),
            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img, 
            {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' 
        ),
        array(
            'name'         => 'box_shadow',
            'label' => esc_html__( 'Box Shadow', 'floka' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img, 
            {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg'
        ),
        array(
            'name' => 'divider',
            'type' => Elementor\Controls_Manager::DIVIDER,
        ),
        array(
            'name' => 'dimension',
            'label' => esc_html__('DIMENSION', 'floka'),
            'type' => Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'image_height',
            'label' => esc_html__('Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%', 'custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'separator' => 'before',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_width',
            'label' => esc_html__('Width', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%', 'custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'separator' => 'before',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_min_height',
            'label' => esc_html__('Min Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'min-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_max_height',
            'label' => esc_html__('Max Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_min_width',
            'label' => esc_html__('Min Width', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img,
                {{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--bg' => 'min-width: {{SIZE}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'image_border_radius',
            'label' => esc_html__( 'Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
    ),
),

array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(   
        array(
            'name' => 'icon_normal_options',
            'label' => esc_html__( 'NORMAL', 'floka' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),    
        array(
            'name' => 'icon_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'color: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg path:not(.not-fill)' => 'fill: {{VALUE}}',
            ],
        ),

        array(
            'name' => 'icon_color_hv',
            'label' => esc_html__( 'Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--single:hover .pxl-item--icon' => 'color: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--single:hover .pxl-item--icon svg path:not(.not-fill)' => 'fill: {{VALUE}}',
            ],
        ),
        
        array(
            'name' => 'icon_bg_color',
            'label' => esc_html__( 'Background Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'background-color: {{VALUE}}',
            ],
        ),

        array(
            'name' => 'icon_opacity',
            'label' => esc_html__( 'Opacity', 'floka' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 1,
            'step' => 0.1,
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'opacity: {{VALUE}}',
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg path' => 'fill-opacity: {{VALUE}}',
            ],
        ),

        
        array(
            'name' => 'icon_size',
            'label' => esc_html__('Font Size', 'floka'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ),
        

        array(
            'name' => 'icon_box_border',
            'label' => esc_html__('Border', 'floka'),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon',
        ),

        array(
            'name' => 'icon_border_radius',
            'label' => esc_html__( 'Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'divider2',
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ),
        array(
            'name' => 'svg_options',
            'label' => esc_html__( 'SVG', 'floka' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'after',
        ),
        array(
            'name' => 'svg_width',
            'label' => esc_html__('Width', 'floka'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'svg_height',
            'label' => esc_html__('Height', 'floka'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%', 'rem', 'em', 'custom'],
            'control_type' => 'responsive',
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-marquee .pxl-item--inner .pxl-item--icon svg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);