<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image',
        'title' => esc_html__('Case Image', 'floka' ),
        'icon' => 'eicon-image',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'tilt',
            'gsap',
            'scroll-trigger',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source_type',
                            'label' => esc_html__('Source Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                's_img' => 'Select Image',
                                'f_img' => 'Featured Image',
                            ],
                            'default' => 's_img',
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'source_type' => ['s_img'],
                            ],
                        ),
                        array(
                            'name' => 'image_link',
                            'label' => esc_html__('Link', 'floka' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'image_type',
                            'label' => esc_html__('Image Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'img' => 'Image',
                                'bg' => 'Background',
                            ],
                            'default' => 'img',
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                            'condition' => [
                                'image_type' => ['img'],
                            ],
                        ),
                        array(
                            'name' => 'img_label',
                            'label' => esc_html__('Image Label', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name'  => 'type_item_content_img',
                            'label' => esc_html__('Select Type','floka'),
                            'type'  => \Elementor\Controls_Manager::SELECT,
                            'options'   => [
                                ''      => 'Default',
                                'one-line'  => 'One Line',
                            ],
                            'default'   => '',
                            'control_type'  => 'responsive',
                        ),
                        array(
                            'name' => 'image_align',
                            'label' => esc_html__('Image Alignment', 'floka' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__('Left', 'floka' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'floka' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'floka' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single' => 'text-align: {{VALUE}};',
                            ],
                        ),
                    ),
),
array(
    'name' => 'tab_style_img',
    'label' => esc_html__('Image', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'image_min_height',
            'label' => esc_html__('Image Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'floka' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'source_type' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_max_height',
            'label' => esc_html__('Image Max Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'floka' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'image_type' => 'img',
                'source_type!' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_min_height_2',
            'label' => esc_html__('Image Min Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'floka' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'min-height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'image_type' => 'img',
                'source_type!' => 'f_img',
            ],
        ),
        array(
            'name' => 'image_width',
            'label' => esc_html__('Image Width', 'floka' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'auto' => [
                    'title' => esc_html__( 'Auto', 'floka' ),
                    'icon' => 'fas fa-arrows-alt-v',
                ],
                '100%' => [
                    'title' => esc_html__( 'Full', 'floka' ),
                    'icon' => 'fas fa-arrows-alt-h',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'width: {{VALUE}};',
            ],
            'condition' => [
                'image_type' => 'img',
            ],
            'control_type' => 'responsive',
        ),
        array(
            'name' => 'image_height',
            'label' => esc_html__('Image Height', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'floka' ),
            'condition' => [
                'image_type' => 'bg',
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-item--bg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'border_radius',
            'label' => esc_html__('Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single, {{WRAPPER}} .pxl-image-single img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'border_radius_hover',
            'label' => esc_html__('Border Radius Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single:hover, {{WRAPPER}} .pxl-image-single:hover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'border_type',
            'label' => esc_html__( 'Border Type', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__( 'None', 'floka' ),
                'solid' => esc_html__( 'Solid', 'floka' ),
                'double' => esc_html__( 'Double', 'floka' ),
                'dotted' => esc_html__( 'Dotted', 'floka' ),
                'dashed' => esc_html__( 'Dashed', 'floka' ),
                'groove' => esc_html__( 'Groove', 'floka' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-style: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'border_width',
            'label' => esc_html__( 'Border Width', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_color',
            'label' => esc_html__( 'Border Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
        ),
        array(
            'name'         => 'box_shadow',
            'label' => esc_html__( 'Box Shadow', 'floka' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-image-single img'
        ),
        array(
            'name' => 'img_effect',
            'label' => esc_html__('Image Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'None',
                'pxl-image-effect1' => 'Zigzag',
                'pxl-image-tilt' => 'Tilt',
                'pxl-image-spin' => 'Spin',
                'pxl-image-zoom' => 'Zoom 1',
                'pxl-image-zoom2' => 'Zoom 2',
                'pxl-image-bounce' => 'Bounce',
                'slide-up-down' => 'Slide Up Down',
                'slide-top-to-bottom' => 'Slide Top To Bottom ',
                'slide-bottom-to-top' => 'Slide Bottom To Top ',
                'slide-right-to-left' => 'Slide Right To Left ',
                'slide-left-to-right' => 'Slide Left To Right ',
                'pxl-hover1' => 'ZoomIn',
                'pxl-hover2' => 'ZoomOut',
                'pxl-animation-round' => 'Round',
                'pxl-image-parallax' => 'Parallax Hover',
                'pxl-image-scale-parallax' => 'Parallax Scale',
                'pxl-parallax-scroll' => 'Parallax Scroll',
                'pxl-scale-scroll' => 'Scale Scroll',
                'pxl-image-distortion' => 'Distortion',
            ],
            'default' => '',
            'condition' => [
                'image_type' => 'img',
            ],
            'separator' => 'before',
        ),
        array(
            'name' => 'parallax_scroll_type',
            'label' => esc_html__('Parallax Scroll Type', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'y' => 'Effect Y',
                'x' => 'Effect X',
                'z' => 'Effect Z',
            ],
            'default' => 'y',
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
        ),
        array(
            'name' => 'parallax_scroll_value_x',
            'label' => esc_html__('Parallax Value', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-parallax-scroll',
            ],
            'default' => '80',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'parallax_value',
            'label' => esc_html__('Parallax Value', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-parallax',
            ],
            'default' => '40',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'value_scale',
            'label' => esc_html__('Value Scale', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'control_type' => 'responsive',
            'default'   => '0.5',
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single img' => 'scale: {{SIZE}};',
            ],
            'condition' => [
                'img_effect' => 'pxl-scale-scroll',
                'image_type' => 'img',
            ],
        ),
        array(
            'name' => 'displacement_img',
            'label' => esc_html__('Displacement Image', 'floka'),
            'type' => 'media',
            'default' => [
                'url' => content_url('/uploads/2025/05/displacement-5.webp'),
                'id' => 9031,
            ],
            'condition' => [
                'img_effect' => 'pxl-image-distortion',
            ]
        ),
        array(
            'name' => 'max_tilt',
            'label' => esc_html__('Max Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '10',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'speed_tilt',
            'label' => esc_html__('Speed Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '400',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'perspective_tilt',
            'label' => esc_html__('Perspective Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '1000',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'speed_effect',
            'label' => esc_html__('Speed', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single, {{WRAPPER}} .pxl-image-single img' => 'animation-duration: {{SIZE}}ms;',
            ],
            'condition' => [
                'img_effect!' => ['pxl-image-tilt','pxl-hover1','pxl-parallax-scroll','pxl-scale-scroll'],
            ],
            'description' => 'Enter number, unit is ms.',
        ),

        array(
            'name' => 'img_display',
            'label' => esc_html__('Hide on Screen <= 1400px', 'floka'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
            'separator' => 'before',

        ),
        array(
            'name' => 'overflow_hidden',
            'label' => esc_html__('Overflow', 'floka'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options'   => [
                'default'   => esc_html__("Default",'floka'),
                'hidden'    => esc_html__("Hidden",'floka'),
            ],
            'default' => 'hidden',
        ),
        array(
            'name' => 'hide_parallax_sm',
            'label' => esc_html__('Disable Parallax on Mobile <= 767px', 'floka'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
            'condition' => [
                'img_effect' => ['pxl-parallax-scroll'],
            ],
        ),
        array(
            'name' => 'heading_overlay',
            'label' => esc_html__('OVERLAY', 'floka' ),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'switch_overlay',
            'label' => esc_html__('Overlay', 'floka'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',
        ),
        array(
            'name' => 'overlay_color',
            'label' => esc_html__('Overlay Color', 'floka' ),
            'type' => \Elementor\Group_Control_Background::get_type(),
            'control_type'  => 'group',
            'selector' => '{{WRAPPER}} .pxl-image-single .pxl-overlay-color',
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        
        array(
            'name' => 'z_index_overlay',
            'label' => esc_html__('Z-Index', 'floka' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'selectors' => [
                '{{WRAPPER}} .pxl-image-single .pxl-overlay-color' => 'z-index: {{VALUE}};',
            ],
            'condition' => [
                'switch_overlay'    => 'true',
            ],
        ),
        array(
            'name' => 'heading_label',
            'label' => esc_html__('Label', 'floka' ),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'color_label',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-item--label' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'typography_label',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-item--label',
        ),
    ),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);