<?php
// Register Icon Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon_box',
        'title' => esc_html__('Case Icon Box', 'floka' ),
        'icon' => 'eicon-icon-box',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_icon_box/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_icon_box/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        
                        array(
                            'name' => 'desc',
                            'label' => esc_html__('Description', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'rows' => 10,
                            'show_label' => false,
                            
                        ),                                             
                        array(
                            'name' => 'item_link',
                            'label' => esc_html__('Item Link', 'floka' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default'   => [
                                'url'   => '#',
                            ],
                        ),
                        array(
                            'name' => 'icon_type',
                            'label' => esc_html__('Icon Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'icon' => 'Icon',
                                'image' => 'Image',
                            ],
                            'default' => 'icon',
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                        ),

                        array(
                            'name' => 'icon_image',
                            'label' => esc_html__( 'Icon Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'icon_type' => 'image',
                            ],
                        ),

                        array(
                            'name' => 'wg_max_width',
                            'label' => esc_html__('Widget Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-box' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'wg_min_height',
                            'label' => esc_html__('Widget Min Height', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-box .pxl-item--main' => 'min-height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout'    => '9',
                            ],
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'floka' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-icon-box .pxl-item--main' => 'text-align: {{VALUE}}; justify-content: {{VALUE}}; align-items: {{VALUE}};',
                        ],
                        
                    ),
                    ),
),
array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'          => 'general_tab_controls',
            'control_type'  => 'tab',
            'condition'     => [
                'layout' => '1',
            ],
            'tabs'          => [
                [
                    'name'      => 'general_tab_normal',
                    'label'     => esc_html__('Normal', 'floka'),
                    'type'      => 'tab',
                    'controls'  => [
                        array(
                            'name'      => 'background_box',
                            'label'     => esc_html__('Background Color', 'floka'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-icon-box' => 'background: {{VALUE}};',
                        ],
                        
                    ),
                    ],
                ],
                [
                    'name'      => 'general_tab_hover',
                    'label'     => esc_html__('Hover', 'floka'),
                    'type'      => 'tab',
                    'controls'  => [
                        array(
                            'name'      => 'background_box_hover',
                            'label'     => esc_html__('Background Color', 'floka'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-icon-box:hover' => 'background: {{VALUE}};',
                        ],
                        
                    ),
                    ],
                ],
            ],
        ),

        array(
            'name'  => 'general_box_shadow',
            'label' => esc_html__('Box Shadow','floka'),
            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type'  => 'group',
            'selector'  => '{{WRAPPER}} .pxl-icon-box',
        ),
    ),
),
array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_tag',
            'label' => esc_html__('HTML Tag', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'h1' => 'H1',
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'div' => 'div',
                'span' => 'span',
                'p' => 'p',
            ],
            'default' => 'h5',
        ),
        array(
            'name' => 'title_color_type',
            'label' => esc_html__('Color Type', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Normal',
                'text-gradient' => 'Text Gradient',
            ],
            'default' => '',
        ),
        array(
            'name'  => 'title_color_gradient',
            'label' => esc_html__('Gradient Color','floka'),
            'type'  => \Elementor\Group_Control_Background::get_type(),
            'types' => ['gradient'],
            'control_type'  => 'group',
            'selector'  => '{{WRAPPER}} .pxl-icon-box .pxl-item--title',
            'condition' => [
                'title_color_type'  => 'text-gradient',
            ],
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-icon-box .pxl-item--title',
        ),

        array(
            'name' => 'title_top_spacer',
            'label' => esc_html__('Top Spacer', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--title' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
            ],
        ),
        array(
            'name' => 'title_bottom_spacer',
            'label' => esc_html__('Bottom Spacer', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--title' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
            ],
        ),
        array(
            'name' => 'title_padding',
            'label' => esc_html__('Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
            ],
        ),

    ),
),
array(
    'name' => 'section_style_desc',
    'label' => esc_html__('Description', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'desc_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--description' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-icon-box .pxl-item--description',
        ),
        array(
            'name' => 'description_padding',
            'label' => esc_html__('Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--description ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
            ],
        ),
        array(
            'name' => 'description_margin',
            'label' => esc_html__('Margin', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-box .pxl-item--description ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'icon_tab_controls',
            'control_type'  => 'tab',
            'tabs'  => [
                [
                    'name'  => 'icon_tab_normal',
                    'label' => esc_html__('Normal','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-icon-box .pxl-item--icon i' => 'color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;',
                            '{{WRAPPER}} .pxl-icon-box .pxl-item--icon svg path' => 'fill:{{VALUE}};',
                        ],
                        'condition' => [
                        'icon_type' => 'icon',
                    ],
                ),
                        array(
                            'name' => 'icon_bg_color',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-icon-box .pxl-item--icon' => 'background: {{VALUE}};',
                        ],
                        
                    ),
                        
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Icon Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                    'icon_type' => 'icon',
                ],
            ),
                        array(
                            'name' => 'icon_box_size',
                            'label' => esc_html__('Box Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon ' => 'width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                ],
            ),
                        array(
                            'name'  => 'border_icon_normal',
                            'label' => esc_html__('Border','floka'),
                            'type'  => \Elementor\Group_Control_Border::get_type(),
                            'control_type'  => 'group',
                            'selector'  => '{{WRAPPER}} .pxl-icon-box .pxl-item--icon',
                            
                        ),

                        
                        array(
                            'name' => 'icon_border_radius',
                            'label' => esc_html__('Border Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
                    ],
                ),
                        array(
                            'name' => 'icon_padding_normal',
                            'label' => esc_html__('Icon Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
                    ],
                ),
                        array(
                            'name' => 'icon_img_max_height',
                            'label' => esc_html__('Image Max Height', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box .pxl-item--icon img' => 'max-height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                    'icon_type' => 'image',
                ],
            ),
                        array(
                            'name'  => 'icon_box_shadow_group',
                            'label' => esc_html__('Box Shadow','floka'),
                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type'  => 'group',
                            'selector'  => '{{WRAPPER}} .pxl-icon-box .pxl-item--icon',
                        ),

                    ],
                ],
                [
                    'name'  => 'icon_tab_hover',
                    'label' => esc_html__('Hover','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                     array(
                        'name' => 'icon_color_hv',
                        'label' => esc_html__('Color', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box:hover .pxl-item--icon i' => 'color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;',
                        '{{WRAPPER}} .pxl-icon-box:hover .pxl-item--icon svg path' => 'fill: {{VALUE}};',
                    ],
                    'condition' => [
                    'icon_type' => 'icon',
                ],
            ),
                     array(
                        'name' => 'icon_bg_color_hover',
                        'label' => esc_html__('Background Color', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                        '{{WRAPPER}} .pxl-icon-box:hover .pxl-item--icon' => 'background: {{VALUE}};',
                    ],
                    
                ),


                     array(
                        'name'  => 'border_icon_hover',
                        'label' => esc_html__('Border','floka'),
                        'type'  => \Elementor\Group_Control_Border::get_type(),
                        'control_type'  => 'group',
                        'selector'  => '{{WRAPPER}} .pxl-icon-box:hover .pxl-item--icon',
                        
                    ),

                 ],
             ],

         ],

     ),
),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);