<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_feature_card',
        'title' => esc_html__('Case Feature Card', 'floka' ),
        'icon' => ' eicon-menu-card',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_feature_card/layout1.jpg',
                                ],
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title', 
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label' => esc_html__( 'Title', 'floka' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'desc', 
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label' => esc_html__( 'Description', 'floka' ),
                            'label_block' => true,
                            'rows' => 3,
                            'description' => 'Create Typewriter text width shortcode: [typewriter text="Text1, Text2"], Highlight text with shortcode: [highlight text="Text"] and Highlight image with shortcode: [highlight_image id_image="123"]',
                        ),

                        array(
                            'name'  => 'show_button',
                            'label' => esc_html__('Show Button Text','floka'),
                            'type'  => \Elementor\Controls_Manager::SWITCHER,
                            'return_value'  => 'yes',
                            'default'   => 'yes',
                        ),

                        array(
                            'name'  => 'show_button_icon',
                            'label' => esc_html__('Show Button Icon','floka'),
                            'type'  => \Elementor\Controls_Manager::SWITCHER,
                            'return_value'  => 'yes',
                            'default'   => '',
                        ),

                        array(
                            'name' => 'text_button',
                            'label' => esc_html__('Text Button', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Click Here', 'floka'),
                            'condition' => [
                                'show_button'   => 'yes',
                            ],
                        ),

                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'floka' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                        ),

                        array(
                            'name'  => 'show_button_video',
                            'label' => esc_html__('Show Button Video','floka'),
                            'type'  => \Elementor\Controls_Manager::SWITCHER,
                            'return_value'  => 'yes',
                            'default'   => '',
                        ),

                        array(
                            'name' => 'video_link',
                            'label' => esc_html__('Video Link', 'floka' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => 'https://www.youtube.com/watch?v=gjkRihzL_TU&t=1s',
                            ],
                            'condition' => [
                                'show_button_video'   => 'yes',
                            ],
                        ),

                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                        ),

                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-feature--card ' => 'text-align: {{VALUE}};',
                        ],
                    ),
                    ),
),

array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'heading_general',
            'label' => esc_html__('GENERAL','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'background_item',
            'label' => esc_html__( 'Background Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--inner' => 'background: {{VALUE}};',
            ],
        ),

        array(
            'name' => 'padding_item',
            'label' => esc_html__('Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),

        array(
            'name' => 'border_radius_item',
            'label' => esc_html__('Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),

        array(
            'name'  => 'heading_content',
            'label' => esc_html__('CONTENT','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'padding_content',
            'label' => esc_html__('Padding Content', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),

        array(
            'name'  => 'heading_title',
            'label' => esc_html__('Title','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__( 'Title Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name'         => 'title_typography',
            'label' => esc_html__( 'Title Typography', 'floka' ),
            'type'         => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-feature--card .pxl-item--title',
        ),

        array(
            'name'  => 'heading_desc',
            'label' => esc_html__('Description','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'desc_color',
            'label' => esc_html__( 'Description Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--desc' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_color_highlight',
            'label' => esc_html__( 'Description Highlight Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--desc .pxl-title--highlight' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name'         => 'desc_typography',
            'label' => esc_html__( 'Description Typography', 'floka' ),
            'type'         => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-feature--card .pxl-item--desc',
        ),


        array(
            'name'  => 'heading_button',
            'label' => esc_html__('BUTTON','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name' => 'button_color',
            'label' => esc_html__( 'Button Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--button' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'button_bgcolor',
            'label' => esc_html__( 'Button Background', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-feature--card .pxl-item--button' => 'background: {{VALUE}};',
            ],
        ),
        array(
            'name'         => 'button_typography',
            'label' => esc_html__( 'Button Typography', 'floka' ),
            'type'         => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-feature--card .pxl-item--button',
        ),
    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);