<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_circle_text',
        'title' => esc_html__('Case Circle Text', 'floka' ),
        'icon' => 'eicon-animation-text',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'pxl-circle--text',
            'circle-text',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_circle_text_content',
                    'label' => esc_html__('Circle Text', 'floka' ),
                    'tab' => 'content',
                    'controls' => array(

                        array(
                            'name' => 'style_circle',
                            'label' => esc_html__('Spin', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style_circle_text',
                            'options' => [
                                'style_circle_text' => esc_html__('Text', 'floka'),
                                'style_circle_image' => esc_html__('Image', 'floka'),
                            ],
                        ),

                        array(
                            'name' => 'circle_text',
                            'label' => esc_html__('Circle Text', 'floka' ),
                            'type' => 'textarea',
                            'rows' => 2,
                            'default' => esc_html__('WANT IT TO SOUND PLAYFUL, LUXURIOUS, OR MORE/', 'floka'),
                            'condition' => [
                                'style_circle'  => 'style_circle_text',
                            ],
                        ),

                        array(
                            'name' => 'circle_img',
                            'label' => esc_html__('Circle Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'style_circle'  => 'style_circle_image',
                            ],
                        ),

                        array(
                            'name' => 'img_size_circle',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => esc_html__('Ex: "thumbnail", "medium", "large", "full"...Alternatively enter size in pixels. Ex: 200x100 - Width x Height.', 'floka'),
                            'condition' => [
                                'style_circle'  => 'style_circle_image',
                            ],
                        ),

                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'floka' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                        array(
                            'name' => 'icon_type',
                            'type' => 'choose',
                            'label' => esc_html__('Icon Type', 'floka'),
                            'options' => [
                                '' => [
                                    'title' => esc_html__('None', 'floka'),
                                    'icon' => 'eicon-ban',
                                ],
                                'text' => [
                                    'title' => esc_html__('Text', 'floka'),
                                    'icon' => 'eicon-text',
                                ],
                                'icon' => [
                                    'title' => esc_html__('Icon', 'floka'),
                                    'icon' => 'eicon-upload',
                                ],
                                'img' => [
                                    'title' => esc_html__('Image', 'floka'),
                                    'icon' => 'eicon-image',
                                ],
                            ],
                            'default' => 'icon',
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'floka' ),
                            'condition' => [
                                'icon_type' => 'text',
                            ],
                        ),
                        array(
                            'name' => 'img',
                            'label' => esc_html__('Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'icon_type' => 'img',
                            ],
                        ),
                        array(
                            'name' => '_icon',
                            'label' => esc_html__('Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                            'default' => [
                                'value' => [
                                    'url' => content_url('wp-content/uploads/2025/05/icon-logo.svg'), 
                                    'id' => 612, 
                                ],
                                'library' => 'svg',
                            ],
                        ),

                    ),
),
array(
    'name' => 'tab_circle_text_style',
    'label' => esc_html__('Circle Text', 'floka' ),
    'tab' => 'style',
    'controls' => array(


        array(
            'name' => 'circle_text_typography',
            'label' => esc_html__('Text Circle Typography','floka'),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-item',
        ),
        array(
            'name' => 'circle_text_color',
            'label' => esc_html__('Text Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-item' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'bg_color',
            'label' => esc_html__('Box Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'padding',
            'label' => esc_html__( 'Box Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'bg_text_color',
            'label' => esc_html__('Box Text Color', 'floka' ),
            'separator' => 'before',
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-item' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'box_text_padding',
            'label' => esc_html__( 'Box Text Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'spin_text',
            'label' => esc_html__('Spin', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                ''    => esc_html__('None', 'floka'),
                'spin-to-right' => esc_html__('To Right', 'floka'),
                'spin-to-left' => esc_html__('To Left', 'floka'),
                'spin-scroll' => esc_html__('Scroll', 'floka'),
            ],
        ),
        array(
            'name' => 'anim_duration',
            'label' => esc_html__('Animation Duration', 'floka'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['ms', 's'],
            'range' => [
                'ms' => [
                    'min' => 0,
                    'max' => 100000,
                    'step' => 50,
                ],
                's' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 0.05,
                ],
            ],
            'default' => [
                'size' => 15000,
                'unit' => 'ms',
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-item div' => 'animation-duration: {{SIZE}}{{UNIT}}; --webkit-animation-duration: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'circle_text_control',
            'control_type' => 'tab',
            'tabs' => [
                [
                    'name' => 'circle_text_style',
                    'label' => esc_html__('Text', 'floka' ),
                    'type' => 'tab',
                    'controls' => [  


                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon ' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Text Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon',
                        ),

                        array(
                            'name' => 'size_box_text',
                            'label' => esc_html__('Size Box Text', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon' => '--size: {{SIZE}}px;',
                    ],
                ),
                    ],
                ],
                [
                    'name' => 'circle_text_icon',
                    'label' => esc_html__('Icon', 'floka' ),
                    'type' => \Elementor\Controls_Manager::TAB,
                    'controls' => [
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => esc_html__('Ex: "thumbnail", "medium", "large", "full"...Alternatively enter size in pixels. Ex: 200x100 - Width x Height.', 'floka'),
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon svg path' => 'fill: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'box_icon_color',
                            'label' => esc_html__('Box Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon' => 'background-color: {{VALUE}};',
                        ],
                    ),

                        array(
                            'name' => 'img_w',
                            'label' => esc_html__('Width', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'control_type' => 'responsive',
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon img, {{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ),
                        array(
                            'name' => 'img_h',
                            'label' => esc_html__('Height', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'control_type' => 'responsive',
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon img, {{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ),
                        array(
                            'name' => 'icon_box_sz',
                            'label' => esc_html__('Box Size', 'floka'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'control_type' => 'responsive',
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon' => '--size: {{SIZE}}{{UNIT}};',
                    ],
                ),

                        array(
                            'name' => 'box_icon_padding',
                            'label' => esc_html__( 'Box Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                            'control_type' => 'responsive',
                            'selectors' => [
                            '{{WRAPPER}} .pxl-circle-text-wrapper .pxl-circle-text-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ),
                    ],
                ],
            ],
        ),
),
),
),
),
),
);