<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_circle',
        'title' => esc_html__('Case Circle SVG', 'floka'),
        'icon' => 'eicon-library-upload',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(  
             array(
                'name' => 'section_circle',
                'label' => esc_html__('Circle', 'floka' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'controls' => array(
                    array(
                        'name' => 'pxl_icon',
                        'label' => esc_html__('Icon', 'floka' ),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'fa4compatibility' => 'icon',
                    ),
                    array(
                        'name'  => 'heading_circle',
                        'label' => esc_html__('CIRCLE','floka'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                    ),
                    array(
                        'name'  => 'circle_size',
                        'label' => esc_html__('Size','floka'),
                        'type'  => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px','custom' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 300,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-circle' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                    array(
                        'name' => 'circle_spin_sw',
                        'label' => esc_html__('Spin Circle', 'floka'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'default' => 'true',
                    ),
                    array(
                        'name' => 'circle_color',
                        'label' => esc_html__('Color', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-circle .circle' => 'border-color: {{VALUE}};',
                        ],
                    ),
                    array(
                        'name'  => 'heading_dot',
                        'label' => esc_html__('DOT','floka'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ),
                    array(
                        'name'  => 'dots_start',
                        'label' => esc_html__('Position Start','floka'),
                        'type'  => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'deg' ],
                        'range' => [
                            'deg' => [
                                'min' => 0,
                                'max' => 300,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-circle' => 'transform: rotate({{SIZE}}deg);',
                        ],
                    ),
                    array(
                        'name'  => 'dot_size',
                        'label' => esc_html__('Size','floka'),
                        'type'  => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px','custom' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 300,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-circle .dot' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                    array(
                        'name' => 'dot_color',
                        'label' => esc_html__('Color', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pxl-circle .dot' => 'background-color: {{VALUE}};',
                        ],
                    ),
                ),
),
),
),
),
floka_get_class_widget_path()
);