<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_book_call',
        'title' => esc_html__('Case Book Call', 'floka' ),
        'icon' => 'eicon-call-to-action',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => array(
                                    'label' => esc_html__('Layout 1', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_book_call/layout1.jpg',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title', 
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label' => esc_html__( 'Title', 'floka' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'desc', 
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label' => esc_html__( 'Description', 'floka' ),
                            'label_block' => true,
                            'rows' => 3,
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'floka' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'floka'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(

                        array(
                            'name'  => 'heading_content',
                            'label' => esc_html__('CONTENT','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),

                        array(
                            'name' => 'padding_content',
                            'label' => esc_html__('Padding Content', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-book--call .pxl-item--holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'item_bgcolor',
                            'label' => esc_html__( 'Item Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-book--call .pxl-item--holder' => 'background: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('Title','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__( 'Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-book--call .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'title_typography',
                            'label' => esc_html__( 'Title Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-book--call .pxl-item--title',
                        ),

                        array(
                            'name'  => 'heading_desc',
                            'label' => esc_html__('Description','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__( 'Description Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-book--call .pxl-item--desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'desc_typography',
                            'label' => esc_html__( 'Description Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-book--call .pxl-item--desc',
                        ),
                    ),
                ),

                floka_widget_animation_settings(),
            ),
),
),
floka_get_class_widget_path()
);