<?php
if(isset($settings['progressbar']) && !empty($settings['progressbar'])): 
    $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
<div class="pxl-progressbar pxl-progressbar-1">
    <?php foreach ($settings['progressbar'] as $key => $progressbar): 
        $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
        $widget->add_render_attribute( $icon_key, [
            'class' => $progressbar['pxl_icon'],
            'aria-hidden' => 'true',
        ] ); ?>
        <div class="pxl--item elementor-repeater-item-<?php echo esc_attr($progressbar['_id']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
            <?php if ( !empty($progressbar['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon pxl-fl-middle pxl-mr-18">
                    <?php if ( $is_new ):
                        \Elementor\Icons_Manager::render_icon( $progressbar['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                    elseif(!empty($progressbar['pxl_icon'])): ?>
                        <i class="<?php echo esc_attr( $progressbar['pxl_icon'] ); ?>" aria-hidden="true"></i>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="pxl--holder pxl-flex-grow">
                <h4 class="pxl--title el-empty"><?php echo pxl_print_html($progressbar['title']); ?></h4>
                <div class="pxl-progressbar--wrap">
                    <div class="pxl--progressbar" role="progressbar" data-valuetransitiongoal="<?php echo esc_attr($progressbar['percent']['size']); ?>">
                        <div class="pxl--percentage"><?php echo esc_html($progressbar['percent']['size']); ?>%</div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>
<?php endif; ?>