<?php 
$show_category = $settings['show_category'] ?? '';
$show_date = $settings['show_date'] ?? '';
$show_comment = $settings['show_comment'] ?? '';
$show_views = $settings['show_views'] ?? '';
$show_share = $settings['show_share'] ?? '';
$show_tags = $settings['show_tags'] ?? '';
?>
<div class="pxl-post-meta">
	<?php if ($show_category) : ?>
		<div class="pxl-meta--item pxl-post--categories">
			<?php the_terms( get_the_ID(), 'category', '', ', ', '' ); ?>

		</div>
	<?php endif; ?>

	<?php if ($show_date) : ?>
		<div class="pxl-meta--item pxl-post--date">
			<?php echo get_the_date('M d, Y'); ?>
		</div>
	<?php endif; ?>

	<?php if ($show_comment) : ?>
		<div class="pxl-meta--item pxl-post--comments">
			<i class="fas fa-comments"></i>
			<?php
			$comment_count = get_comments_number();
			if ( 0 == intval($comment_count) ) {
				echo esc_html__( 'No Comment', 'floka' );
			} elseif (1 === intval($comment_count)) {
				echo esc_html__($comment_count.' Comment','floka');
			} else{
				echo esc_html__($comment_count.' Comments','floka');
			}
			?>
		</div>
	<?php endif; ?>

	<?php if ($show_views) : ?>
		<div class="pxl-meta--item pxl-post--views">
			<i class="far fa-eye"></i>
			<?php  $review_count = floka()->blog->floka_set_post_views( get_the_ID() );
			 if ( 0 == intval($review_count) ) {
				echo esc_html__( ' No View', 'floka' );
			} elseif (1 === intval($review_count)) {
				echo esc_html__($review_count.' View','floka');
			} else{
				echo esc_html__($review_count.' Views','floka');
			}

			 ?>
		</div>
	<?php endif; ?>


	<?php if ($show_share) : ?>
		<div class="pxl-meta--item pxl-post--share">
			<span>Follow Us:</span>
			<?php echo floka()->blog->get_socials_share(); ?>
		</div>
	<?php endif; ?>

	<?php if ($show_tags) : ?>
		<div class="pxl-meta--item pxl-post--tags pxl--tags">
			<?php echo the_tags( '', ' ', '' ); ?>

		</div>
	<?php endif; ?>

</div>