<?php
$active = intval($settings['active']);

$html_id = pxl_get_element_id($settings);
$tax = ['service-category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(pxl_get_posts_of_grid(
    'service', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    $tax
));

$show_category = $widget->get_setting('show_category');
$show_excerpt = $widget->get_setting('show_excerpt');

if (is_array($posts)): ?>
    <div class="pxl-accordion pxl-post-accordion pxl-service-accordion1">
        <?php 
        $images_size = !empty($settings['img_size']) ? $settings['img_size'] : '400x400';
        $button_more = !empty($settings['button_more']) ? $settings['button_more'] : 'see more';

        foreach ($posts as $key => $post):
            $is_active = ($key + 1) == $active;
            $excerpt_post = get_the_excerpt($post->ID);
            $num_words = $settings['num_words'] ? $settings['num_words'] : '12';

            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                $img_id = get_post_thumbnail_id($post->ID);
            $img          = pxl_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $images_size
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <div class="pxl-accordion-title">
                    <h3 class="pxl-post--title pxl-accordion--title">
                        <?php echo pxl_print_html(get_the_title($post->ID)); ?>
                    </h3>


                </div>
                <div class="pxl-accordion-content">
                 <div class="pxl-post--holder">
                    <div class="pxl-post--content">

                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'service-category', '', ' ' ); ?>
                            </div>
                        <?php endif; ?>
                        <div class="pxl-item--description">
                            <?php if($show_excerpt == 'true') : ?>
                                <div class="pxl-item--excerpt">
                                    <?php
                                    echo wp_trim_words( $excerpt_post, $num_words, $more = null );
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="pxl-post--featured">
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>
</div>
<?php endif; ?>