<?php 

if(!function_exists('floka_get_post_grid')){
    function floka_get_post_grid($posts = [], $settings = []){ 
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
            floka_get_post_grid_layout1($posts, $settings);
            break;

            case 'service-1':
            floka_get_service_grid_layout1($posts, $settings);
            break;

            case 'portfolio-1':
            floka_get_portfolio_grid_layout1($posts, $settings);
            break;

            case 'portfolio-2':
            floka_get_portfolio_grid_layout2($posts, $settings);
            break;

            case 'portfolio-3':
            floka_get_portfolio_grid_layout3($posts, $settings);
            break;

            case 'portfolio-4':
            floka_get_portfolio_grid_layout4($posts, $settings);
            break;

            case 'portfolio-5':
            floka_get_portfolio_grid_layout5($posts, $settings);
            break;

            case 'careers-1':
            floka_get_careers_grid_layout1($posts, $settings);
            break;

            

            default:
            return false;
            break;
        }
    }
}

// Start Post Grid
//--------------------------------------------------
function floka_get_post_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '800x800';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $description_post = get_post_meta($post->ID, 'description_post', true);
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-delay="<?php echo esc_attr($pxl_animate_delay); ?>ms" data-wow-duration="1.2s">

                    <div class="pxl-post--featured hover-imge-effect2">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <?php echo floka_get_thumbnail($img_id, $images_size); ?>
                        </a>

                        <?php if($show_button == 'true') : ?>
                            <a class="btn btn-readmore d-flex" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span class="pxl--btn-icon">
                                    <span class="pxl-icon--plus"></span>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>

                    <div class="pxl-item--holder">
                        <div class="pxl-item--content">
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-item--category">
                                    <?php the_terms( $post->ID, 'category', '', ' ' ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <?php echo get_the_date('M d, Y', $post->ID); ?>

                                </div>
                            <?php endif; ?>
                        </div>

                        <h3 class="pxl-item--title">
                            <a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
                                <?php echo esc_attr(get_the_title($post->ID)); ?>
                            </a>
                        </h3>
                    </div>

                </div>
            </div>
            <?php
        endforeach;
    endif;
}

// End Post Grid
//--------------------------------------------------


// Start Portfolio Grid
//--------------------------------------------------
function floka_get_portfolio_grid_layout1($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '950x634';
    $img_effect = $settings['img_effect'];
    $displacement_url = floka_get_thumbnail($settings['displacement_img']['id'], 'full' ,true);
    

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $author = get_user_by('ID', get_post_field('post_author', $post->ID));
            $author_name = $author->display_name; 
            $portfolio_icon_type = get_post_meta($post->ID, 'portfolio_icon_type', true);
            $portfolio_icon_font = get_post_meta($post->ID, 'portfolio_icon_font', true);
            $portfolio_icon_img = get_post_meta($post->ID, 'portfolio_icon_img', true);


            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>" 
                        <?php if($img_effect == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> 
                        <?php if($img_effect=='pxl-image-distortion') : ?> data-displacement="<?php echo esc_attr($displacement_url); ?>" <?php endif; ?>>
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>


                        <?php if($portfolio_icon_type == 'icon' && !empty($portfolio_icon_font)) : ?>
                            <div class="pxl-post--icon pxl-fl-middle">
                                <i class="<?php echo esc_attr($portfolio_icon_font); ?>"></i>
                            </div>
                        <?php endif; ?>
                        <?php if($portfolio_icon_type == 'image' && !empty($portfolio_icon_img)) : 
                            $icon_img = pxl_get_image_by_size( array(
                                'attach_id'  => $portfolio_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="pxl-post--icon pxl-fl-middle">
                                <?php echo wp_kses_post($icon_thumbnail); ?>
                            </div>
                        <?php endif; ?>

                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-readmore d-flex" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.2778 3.63859C8.25294 3.41485 8.45182 3.21598 8.70041 3.21598H14.4677C14.7163 3.21598 14.8904 3.39 14.8904 3.63859V9.40593C14.8904 9.65452 14.6915 9.85339 14.4677 9.82853L14.0949 9.85339C13.8711 9.82853 13.6971 9.65452 13.6723 9.43079V5.25444L4.35004 14.5766C4.17603 14.7507 3.92744 14.7507 3.75342 14.5766L3.50483 14.3281C3.35567 14.1789 3.33082 13.9054 3.50483 13.7314L12.827 4.40922L8.67555 4.43408C8.45182 4.40922 8.2778 4.23521 8.25294 4.01148L8.2778 3.63859Z" fill="currentColor"/>
                                    </svg>

                                </a>
                            </div>
                        <?php endif; ?>

                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'portfolio-category', '', ', ' ); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--author">

                    <div class="pxl-user--name">
                        <?php echo esc_html($author_name);?>
                    </div>

                    <?php if($show_date == 'true'): ?>
                        <div class="pxl-item--date">
                            <?php echo get_the_date('Y', $post->ID); ?>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    <?php endforeach;
endif;
}


function floka_get_portfolio_grid_layout2($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : 'full';
    $img_effect = $settings['img_effect'];
    $displacement_url = floka_get_thumbnail($settings['displacement_img']['id'], 'full' ,true);
    

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $author = get_user_by('ID', get_post_field('post_author', $post->ID));
            


            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>" 
                        <?php if($img_effect == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> 
                        <?php if($img_effect=='pxl-image-distortion') : ?> data-displacement="<?php echo esc_attr($displacement_url); ?>" <?php endif; ?>>
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-post--content">
                    <div class="pxl-item--content">
                        <h3 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                        </h3>

                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                            </div>
                        <?php endif; ?>
                        
                    </div>
                    <?php if($show_button == 'true') : ?>
                        <a class="btn-readmore pxl-dflex-center" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <svg width="13" height="8" viewBox="0 0 13 8" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8.87891 0.359375C8.98828 0.222656 9.20703 0.222656 9.34375 0.359375L12.5156 3.53125C12.6523 3.66797 12.6523 3.85938 12.5156 3.99609L9.34375 7.16797C9.20703 7.30469 8.98828 7.30469 8.87891 7.16797L8.66016 6.97656C8.55078 6.83984 8.55078 6.64844 8.66016 6.51172L10.957 4.21484H0.703125C0.511719 4.21484 0.375 4.07812 0.375 3.88672V3.61328C0.375 3.44922 0.511719 3.28516 0.703125 3.28516H10.957L8.66016 1.01562C8.55078 0.878906 8.55078 0.6875 8.66016 0.550781L8.87891 0.359375Z" fill="currentColor"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach;
endif;
}


function floka_get_portfolio_grid_layout3($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : 'full';
    $img_effect = $settings['img_effect'];
    $displacement_url = floka_get_thumbnail($settings['displacement_img']['id'], 'full' ,true);
    

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $author = get_user_by('ID', get_post_field('post_author', $post->ID));
            


            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">

                    <div class="pxl-post--content">
                        <div class="pxl-item--content">
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-item--category">
                                    <?php the_terms( $post->ID, 'portfolio-category', '', ', ' ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-item--date">
                                    <?php echo get_the_date('Y', $post->ID); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <h3 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                        </h3>
                    </div>

                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>" 
                        <?php if($img_effect == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> 
                        <?php if($img_effect=='pxl-image-distortion') : ?> data-displacement="<?php echo esc_attr($displacement_url); ?>" <?php endif; ?>>
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>
                    </div>
                <?php endif; ?>
                
            </div>
        </div>
    <?php endforeach;
endif;
}


function floka_get_portfolio_grid_layout4($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : 'full';
    $img_effect = $settings['img_effect'];
    $displacement_url = floka_get_thumbnail($settings['displacement_img']['id'], 'full' ,true);
    

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $author = get_user_by('ID', get_post_field('post_author', $post->ID));
            


            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>" 
                        <?php if($img_effect == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> 
                        <?php if($img_effect=='pxl-image-distortion') : ?> data-displacement="<?php echo esc_attr($displacement_url); ?>" <?php endif; ?>>
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-post--content">

                    <div class="pxl-item--content">
                        <h3 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                        </h3>
                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>

            </div>
        </div>
    <?php endforeach;
endif;
}

function floka_get_portfolio_grid_layout5($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '650x500';
    $img_effect = $settings['img_effect'];
    $displacement_url = floka_get_thumbnail($settings['displacement_img']['id'], 'full' ,true);
    

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $author = get_user_by('ID', get_post_field('post_author', $post->ID));
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner pxl-image-tilt <?php echo esc_attr($pxl_animate); ?>" data-maxtilt="5" data-speedtilt="400" data-perspectivetilt="1000" data-wow-duration="1.2s">

                    <div class="pxl-post--content">
                        <div class="pxl-item--content">
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-item--category">
                                    <?php the_terms( $post->ID, 'portfolio-category', '', ', ' ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <h3 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                        </h3>
                    </div>

                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>">
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>
                    </div>
                <?php endif; ?>
                
            </div>
        </div>
    <?php endforeach;
endif;
}


// End Portfolio Grid
//--------------------------------------------------


//Start Service Grid
//--------------------------------------------------
function floka_get_service_grid_layout1($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '1025x650';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $button_text = !empty($button_text) ? $button_text : 'Read More';
            $num_words = $settings['num_words'] ? $settings['num_words'] : '10';
            $excerpt_post = get_the_excerpt($post->ID);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>">
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-post--holder">
                    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                        <div class="pxl-post--icon pxl-fl-middle">
                            <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                        </div>
                    <?php endif; ?>
                    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                        $icon_img = pxl_get_image_by_size( array(
                            'attach_id'  => $service_icon_img['id'],
                            'thumb_size' => 'full',
                        ));
                        $icon_thumbnail = $icon_img['thumbnail'];
                        ?>
                        <div class="pxl-post--icon pxl-fl-middle">
                            <?php echo wp_kses_post($icon_thumbnail); ?>
                        </div>
                    <?php endif; ?>

                    <h3 class="pxl-post--title">
                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                    </h3>

                    <?php if($show_excerpt == 'true') : ?>
                        <div class="pxl-item--excerpt">
                            <?php echo wp_trim_words( $excerpt_post, $num_words, $more = null ); ?> 
                        </div>
                    <?php endif; ?>

                    <?php if($show_button == 'true') : ?>
                        <div class="pxl-post--button">
                            <a class="btn btn-readmore <?php echo pxl_print_html($settings['btn_text_effect']); ?> " href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span class="pxl--btn-text" data-text="<?php echo esc_attr($button_text); ?>">
                                    <?php if($settings['btn_text_effect'] == 'btn-text-nina' || $settings['btn_text_effect'] == 'btn-text-nanuk') {
                                        $chars = preg_split('//u', $button_text, -1, PREG_SPLIT_NO_EMPTY);

                                        foreach ($chars as $value) {
                                            if($value == ' ') {
                                                echo '<span class="spacer">&nbsp;</span>';
                                            } else {
                                                echo '<span>' . htmlspecialchars($value) . '</span>';
                                            }
                                        }
                                    } else {
                                        echo pxl_print_html($button_text);
                                    }
                                    ?>


                                </span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    <?php endforeach;
endif;
}



//End Service Grid
//--------------------------------------------------

//Start Careers Grid
//--------------------------------------------------
function floka_get_careers_grid_layout1($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : 'full';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    ?>
                    <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>">
                        <?php echo wp_kses_post($thumbnail); ?>
                        <a class="pxl-post--link" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"></a>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    <?php endforeach;
endif;
}



//End Careers Grid
//--------------------------------------------------

add_action( 'wp_ajax_floka_load_more_post_grid', 'floka_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_floka_load_more_post_grid', 'floka_load_more_post_grid' );
function floka_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(('Something went wrong while requesting. Please try again!'));
        }

        $settings = isset($_POST['settings']) ? $_POST['settings'] : null;

        $source = isset($settings['source']) ? $settings['source'] : '';
        $term_slug = isset($settings['term_slug']) ? $settings['term_slug'] : '';
        if( !empty($term_slug) && $term_slug !='*'){
            $term_slug = str_replace('.', '', $term_slug);
            $source = [$term_slug.'|'.$settings['tax'][0]]; 
        }
        if( isset($_POST['handler_click']) && sanitize_text_field(wp_unslash( $_POST[ 'handler_click' ] )) == 'filter'){
            set_query_var('paged', 1);
            $settings['paged'] = 1;
        }else{
            set_query_var('paged', $settings['paged']);
        }
        extract(pxl_get_posts_of_grid($settings['post_type'], [
            'source' => $source,
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => isset($settings['limit'])?$settings['limit']:'6',
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
            'post_not_in' => isset($settings['post_not_in'])?$settings['post_not_in']: [],
        ],
        $settings['tax']
    ));

        ob_start();
        floka_get_post_grid($posts, $settings);
        $html = ob_get_clean();

        $pagin_html = '';
        if( isset($settings['pagination_type']) && $settings['pagination_type'] == 'pagination' ){ 
            ob_start();
            floka()->page->get_pagination( $query,  true );
            $pagin_html = ob_get_clean();
        }
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr('Load Successfully!', 'floka'),
                'data' => array(
                    'html' => $html,
                    'pagin_html' => $pagin_html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}
