<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonPrettyphoto_modal extends SppagebuilderAddons{

	public function render() {
		
		$app = Factory::getApplication();
		
		// Include template's params
		$tpl_params 	= Factory::getApplication()->getTemplate(true)->params;
		$has_lazyload = $tpl_params->get('lazyload', 1);
		
		$settings = $this->addon->settings;
		
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Options
		$modal_selector = (isset($settings->modal_selector) && $settings->modal_selector) ? $settings->modal_selector : '';
		$button_text = (isset($settings->button_text) && $settings->button_text) ? $settings->button_text : '';
		$button_class = (isset($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : ' sppb-btn-default';
		$button_class .= (isset($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
		$button_class .= (isset($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape: ' sppb-btn-rounded';
		$button_class .= (isset($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';

		// Fix for 3D button (removing border)
		$button_class .= ($settings->button_appearance == '3d') ? ' border-0' : '';
		
		$button_class .= (isset($settings->button_block) && $settings->button_block) ? ' ' . $settings->button_block .' centered my-2' : '';
		//Pixeden Icons
		$button_peicon = (isset($settings->button_peicon) && $settings->button_peicon) ? $settings->button_peicon : '';
		$button_icon = (isset($settings->button_icon) && $settings->button_icon) ? $settings->button_icon : '';
		$button_icon_position = (isset($settings->button_icon_position) && $settings->button_icon_position) ? $settings->button_icon_position: 'left';
		
		$icon_arr = array_filter(explode(' ', $button_icon));

		if (count($icon_arr) === 1) {
			$button_icon = 'fa ' . $button_icon;
		}

		if($button_icon_position == 'left') {
			if ($button_peicon != '') {
				$button_text = ($button_peicon) ? '<i class="pe ' . $button_peicon . '"></i> ' . $button_text : $button_text;
			}else{
				$button_text = ($button_icon) ? '<i class="' . $button_icon . '" aria-hidden="true"></i> ' . $button_text : $button_text;
			}
		} else {
			if ($button_peicon != '') {
				$button_text = ($button_peicon) ? $button_text . ' <i style="margin-left:7px;margin-right:-1px;" class="pe ' . $button_peicon . '"></i>' : $button_text;
			}else{
				$button_text = ($button_icon) ? $button_text . ' <i style="margin-left:5px;margin-right:-1px;" class="' . $button_icon . '"></i>' : $button_text;
			}
		}
		

		$selector_image = (isset($settings->selector_image) && $settings->selector_image) ? $settings->selector_image : '';
		//Pixeden Icon
		$peicon_name = (isset($settings->peicon_name) && $settings->peicon_name) ? $settings->peicon_name : '';
		$selector_icon_name = (isset($settings->selector_icon_name) && $settings->selector_icon_name) ? $settings->selector_icon_name : '';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$modal_unique_id = 'prettyphoto-modal-' . $this->addon->id;
		$modal_content_type = (isset($settings->modal_content_type) && $settings->modal_content_type) ? $settings->modal_content_type : 'text';
		$modal_content_text = (isset($settings->modal_content_text) && $settings->modal_content_text) ? $settings->modal_content_text : '';
		
		//Image
		$modal_content_image = (isset($settings->modal_content_image) && $settings->modal_content_image) ? $settings->modal_content_image : '';
		$modal_content_image_src = isset($modal_content_image->src) ? $modal_content_image->src : $modal_content_image;
		
		$modal_content_video_url = (isset($settings->modal_content_video_url) && $settings->modal_content_video_url) ? $settings->modal_content_video_url : '';
		$modal_popup_width = (isset($settings->modal_popup_width) && $settings->modal_popup_width) ? $settings->modal_popup_width : '';
		$modal_popup_height = (isset($settings->modal_popup_height) && $settings->modal_popup_height) ? $settings->modal_popup_height : '';

		// Start Output
		$output = '';
		$attribs = '';

		if($modal_content_type == 'text') {
			$url = '#' . $modal_unique_id. '-content';
			$output .= '<div id="' . $modal_unique_id . '-content" style="display: none;">';
			$output .= '<div style="max-width:'. $modal_popup_width .'px;" class="sppb-addon-modal-content clearfix">';
			$output .= $modal_content_text;
			$output .= '</div>';
			$output .= '</div>';
			$attribs = 'data-popup_type="inline" data-mainclass="mfp-with-zoom"';
			
		} else if( $modal_content_type == 'video') {
			$url = $modal_content_video_url;
			$attribs = 'data-popup_type="iframe" data-mainclass="mfp-no-margins mfp-with-zoom"';
		} else {
			//$url = $modal_content_image;
			$url = $modal_content_image_src;
			$attribs = 'data-popup_type="inline" data-mainclass="mfp-with-zoom"';
		}

		$output .= '<div class="' . $class . ' selector-alignment sppb-text-' . $alignment . '">';

		if($modal_selector=='image') {
			
			if ($selector_image) {
				
				$output .= '<a class="sppb-modal-selector modal-selector-image" ' . $attribs . ' href="'. $url .'" id="'. $modal_unique_id .'">';
				// Image
				if(strpos($selector_image, 'http://') !== false || strpos($selector_image, 'https://') !== false){
					/* Lazyload for images with absolute URL */
					if($has_lazyload) {
						$output .= '<img class="lazyload" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. $selector_image .'" alt="'. $modal_selector .'">';
					} else {
						$output .= '<img src="'. $selector_image .'" alt="'. $modal_selector .'">';	
					}
				} else {
					/* Lazyload for images for relative URL (local image) */
					if($has_lazyload) {
						$output .= '<img class="lazyload" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. Uri::root() . $selector_image .'" alt="'.$modal_selector.'">';
					} else {
						$output .= '<img src="'. $selector_image .'" alt="'. $modal_selector .'">';	
					}
				}
				$output .= '</a>';
			}
		
		
		} else if ($modal_selector=='icon') {
			
			if($selector_icon_name || $peicon_name) {
		
				$select_icon = explode(' ', $selector_icon_name);
				if (count($select_icon) === 1) {
					$selector_icon_name = 'fa '. $selector_icon_name;
				}
				
				$output  .= '<a class="sppb-modal-selector" href="'. $url . '" id="'. $modal_unique_id .'">';
				$output  .= '<span>';
				if ($peicon_name != '') {
					$output  .= '<i class="pe '. $peicon_name .'"></i>';
				}else{
					$output  .= '<i class="'. $selector_icon_name .'"></i>';
				}
				$output  .= '</span>';
				$output  .= '</a>';
			}
		} else {
			$output .= '<a class="sppb-btn '. $button_class .' sppb-modal-selector" href="'. $url .'" id="'. $modal_unique_id .'">'. $button_text .'</a>';
		}

		$output .= '</div>';

		return $output;

	}

	public function scripts() {
		$app = Factory::getApplication();
		return array(Uri::base(true) . '/templates/'.$app->getTemplate().'/sppagebuilder/addons/prettyphoto_modal/js/jquery.prettyPhoto.js');
	}

	public function stylesheets() {
		$app = Factory::getApplication();
		return array(Uri::base(true) . '/templates/'.$app->getTemplate().'/sppagebuilder/addons/prettyphoto_modal/css/prettyPhoto.css');
	}
	
	public function js() {
		$settings = $this->addon->settings;
		$modal_popup_width = (isset($settings->modal_popup_width) && $settings->modal_popup_width) ? $settings->modal_popup_width : '';
		$modal_popup_height = (isset($settings->modal_popup_height) && $settings->modal_popup_height) ? $settings->modal_popup_height : '';
		$js = 'jQuery(function($){$("#prettyphoto-modal-'.$this->addon->id.'").prettyPhoto({social_tools:false,theme:"sppb_prettyphoto",horizontal_padding:20,allow_resize:true,default_width:' . $modal_popup_width . ',default_height:' . $modal_popup_height . '})});'; 
		return $js;
	}

	public function css() {
		
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;
		$cssHelper = new CSSHelper($addon_id);
		
		$settings->alignment = $cssHelper->parseAlignment($settings, 'alignment');
		
		$modal_content_type = (isset($settings->modal_content_type) && $settings->modal_content_type) ? $settings->modal_content_type : 'text';
		
		$modal_size  = (isset($settings->modal_popup_width) && $settings->modal_popup_width) ? $settings->modal_popup_width : '';
		$modal_size .= (isset($settings->modal_popup_height) && $settings->modal_popup_height) ? $settings->modal_popup_height : '';

		$modal_selector = (isset($settings->modal_selector) && $settings->modal_selector) ? $settings->modal_selector : '';
		
		//Pixeden Icon
		$peicon_name = (isset($settings->peicon_name) && $settings->peicon_name) ? $settings->peicon_name : '';
		//Fontawesome Icon
		$selector_icon_name = (isset($settings->selector_icon_name) && $settings->selector_icon_name) ? $settings->selector_icon_name : '';
		$selector_style	= (isset($settings->selector_margin_top) && $settings->selector_margin_top) ? 'margin-top:' . (int) $settings->selector_margin_top .'px;' : '';
		$selector_style	.= (isset($settings->selector_margin_bottom) && $settings->selector_margin_bottom) ? 'margin-bottom:' . (int) $settings->selector_margin_bottom .'px;' : '';
		
		//$button_block = (isset($settings->button_block) && $settings->button_block) ? $settings->button_block : '';
		
		$paddingStyle = $cssHelper->generateStyle('.sppb-icon-inner', $settings, ['padding' => 'padding'], 'px');
		
		$css = '';

		if($modal_selector == 'icon') {
		
			if($selector_icon_name || $peicon_name) {
			
				$selector_style	.= 'display:inline-block;line-height:1;';
				$selector_style	.= (isset($settings->selector_icon_padding) && $settings->selector_icon_padding) ? 'padding:' . (int) $settings->selector_icon_padding .'px;' : '';
				$selector_style	.= (isset($settings->selector_icon_color) && $settings->selector_icon_color) ? 'color:' . $settings->selector_icon_color .';' : '';
				$selector_style	.= (isset($settings->selector_icon_background) && $settings->selector_icon_background) ? 'background-color:' . $settings->selector_icon_background .';' : '';
				$selector_style	.= (isset($settings->selector_icon_border_color) && $settings->selector_icon_border_color) ? 'border-style:solid;border-color:' . $settings->selector_icon_border_color .';' : '';
				$selector_style	.= (isset($settings->selector_icon_border_width) && $settings->selector_icon_border_width) ? 'border-width:' . (int) $settings->selector_icon_border_width .'px;' : '';
				$selector_style	.= (isset($settings->selector_icon_border_radius) && $settings->selector_icon_border_radius) ? 'border-radius:' . (int) $settings->selector_icon_border_radius .'px;' : '';

				$selector_icon_style = (isset($settings->selector_icon_size) && $settings->selector_icon_size) ? 'font-size:' . (int) $settings->selector_icon_size . 'px;width:' . (int) $settings->selector_icon_size . 'px;height:' . (int) $settings->selector_icon_size . 'px;line-height:' . (int) $settings->selector_icon_size . 'px;' : '';

				if($selector_style) {
					$css .= $addon_id . ' .sppb-modal-selector span {';
					$css .= $selector_style;
					$css .= '}';
				}

				if($selector_icon_style) {
					$css .= $addon_id . ' .sppb-modal-selector span > i {';
					$css .= $selector_icon_style;
					$css .= '}';
				}

			}
		} else {
			if($selector_style) {
				$css .= $addon_id . ' .sppb-modal-selector {';
				$css .= $selector_style;
				$css .= '}';
			}
		}
		
		if ($modal_content_type != 'video') {
			if ($modal_content_type == 'image') {
				$cssHelper->setID('#sppb-modal-'. $this->addon->id .' .modal-selector-image img');

				$popupImage = $cssHelper->generateStyle(':self', $settings, ['modal_popup_width' => 'max-width', 'modal_popup_height' => 'height']);
				$css .= $popupImage;

				$cssHelper->setID($addon_id);
			} else {
				$cssHelper->setID('#sppb-modal-'. $this->addon->id .' .sppb-addon-modal-content');

				$popupImage = $cssHelper->generateStyle(':self', $settings, ['modal_popup_width' => 'max-width', 'modal_popup_height' => 'height']);
				$css .= $popupImage;

				$cssHelper->setID($addon_id);
			}
		}
		
		$css .= $cssHelper->generateStyle(':self', $settings, ['alignment' => 'text-align'], false);

		return $css;
	}
	public static function getTemplate() {

		$lodash = new Lodash('#sppb-addon-{{ data.id }}');
		$output = '
	    <#
	    let modalContentType = data.modal_content_type || "text"
		let buttonIconPosition = data.button_icon_position || "left"
		let modalUniqueId = "sppb-modal-"+ data.id
		let modalUrl = "#" + modalUniqueId
		let attribs = \'data-popup_type="inline" data-mainclass="mfp-no-margins mfp-with-zoom"\'

		let buttonClass = ( data.button_type )? "sppb-btn-" + data.button_type : "sppb-btn-default"
			buttonClass += ( data.button_size )? " sppb-btn-" + data.button_size : ""
			buttonClass += ( data.button_shape )? " sppb-btn-" + data.button_shape : " sppb-btn-rounded"
			buttonClass += ( data.button_appearance )? " sppb-btn-" + data.button_appearance : ""
			buttonClass += ( data.button_block )? " " + data.button_block + " centered" : ""

	    #>

		<style type="text/css">';

		$output .= $lodash->alignment('text-align', '', 'data.alignment');

		$buttonTypographyFallbacks = [
			'font'           => 'data.button_font_family',
			'size'           => 'data.button_fontsize',
			'letter_spacing' => 'data.button_letterspace',
			'weight'         => 'data.button_font_style?.weight',
			'italic'         => 'data.button_font_style?.italic',
			'underline'      => 'data.button_font_style?.underline',
			'uppercase'      => 'data.button_font_style?.uppercase',
		];

		$output .= $lodash->typography('#sppb-modal-{{ data.id }}-selector.sppb-btn-{{ data.button_type }}', 'data.button_typography', $buttonTypographyFallbacks);

		$output .= '<# if(data.button_type == "custom") { #>';
		$output .= $lodash->color('color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_color');
		$output .= $lodash->color('background-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom:hover', 'data.button_background_color_hover');
		$output .= $lodash->color('color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom:hover', 'data.button_color_hover');
		$output .= $lodash->spacing('padding', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_padding');

		$output .= '<# if (data.button_appearance == "outline") { #>';
		$output .= $lodash->border('border-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_background_color');
		$output .= $lodash->border('border-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom:hover', 'data.button_background_color_hover');
		$output .= '<# } else if(data.button_appearance == "3d") { #>';
		$output .= $lodash->border('border-bottom-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_background_color_hover');
		$output .= $lodash->color('background-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_background_color');
		$output .= '<# } else if(data.button_appearance == "gradient") { #>';
		$output .= '#sppb-addon-{{ data.id }} #sppb-modal-{{ data.id }}-selector.sppb-btn-custom { border: none; }';
		$output .= $lodash->color('background-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_background_gradient');
		$output .= $lodash->color('background-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom:hover', 'data.button_background_gradient_hover');
		$output .= '<# } else { #>';
		$output .= $lodash->color('background-color', '#sppb-modal-{{ data.id }}-selector.sppb-btn-custom', 'data.button_background_color');
		$output .= '<# } #>';
		$output .= '<# } #>';

		$output .= '<# if (modalContentType == "image") { #>';
		$output .= $lodash->unit('max-width', '#sppb-modal-{{ data.id }} .modal-selector-image img', 'data.modal_popup_width', 'px');
		$output .= $lodash->unit('height', '#sppb-modal-{{ data.id }} .modal-selector-image img', 'data.modal_popup_height', 'px');
		$output .= '<# } else if (modalContentType == "text") { #>';
		$output .= $lodash->unit('max-width', '#sppb-modal-{{ data.id }} .sppb-addon-modal-content', 'data.modal_popup_width', 'px');
		$output .= $lodash->unit('height', '#sppb-modal-{{ data.id }} .sppb-addon-modal-content', 'data.modal_popup_height', 'px');
		$output .= '<# } #>';

		$output .= '<# if( data.modal_selector == "icon") { #>';

		$output .= $lodash->color('color', '.sppb-modal-selector span', 'data.selector_icon_color');
		$output .= $lodash->color('background-color', '.sppb-modal-selector span', 'data.selector_icon_background');
		$output .= $lodash->border('border-color', '.sppb-modal-selector span', 'data.selector_icon_border_color');
		$output .= '<# if(!_.isEmpty(data.selector_icon_border_color)) { #>';
		$output .= '#sppb-addon-{{ data.id }} .sppb-modal-selector span { border-style:solid;}';
		$output .= '<# } #>';
		$output .= '#sppb-addon-{{ data.id }} .sppb-modal-selector span { display:inline-block; line-height:1;}';

		$output .= $lodash->unit('border-width', '.sppb-modal-selector span', 'data.selector_icon_border_width', 'px');
		$output .= $lodash->unit('border-radius', '.sppb-modal-selector span', 'data.selector_icon_border_radius', 'px');
		$output .= $lodash->unit('padding', '.sppb-modal-selector span', 'data.selector_icon_padding', 'px');

		$output .= $lodash->unit('font-size', '.sppb-modal-selector span > i', 'data.selector_icon_size', 'px');
		$output .= $lodash->unit('width', '.sppb-modal-selector span > i', 'data.selector_icon_size', 'px');
		$output .= $lodash->unit('height', '.sppb-modal-selector span > i', 'data.selector_icon_size', 'px');
		$output .= $lodash->unit('line-height', '.sppb-modal-selector span > i', 'data.selector_icon_size', 'px');

		$output .= '<# } #>';

		$output .= ' <# if( (data.modal_selector == "icon" || data.modal_selector == "image") && (data.selector_icon_name || data.selector_image)) { #>';
		$output .= $lodash->unit('font-size', 'sppb-modal-selector span.text', 'data.selector_text_size', 'px');
		$output .= $lodash->unit('font-weight', 'sppb-modal-selector span.text', 'data.selector_text_weight');
		$output .= $lodash->color('color', 'sppb-modal-selector span.text', 'data.selector_text_color');
		$output .= $lodash->spacing('margin', 'sppb-modal-selector span.text', 'data.selector_text_margin');
		$output .= '<# } #>';

		$output .= '
		<# if( (data.modal_selector == "icon" || data.modal_selector == "image") && (data.selector_icon_name || data.selector_image)) { #>
			#sppb-addon-{{ data.id }} .sppb-modal-selector span.text {
				font-weight: {{ data.selector_text_weight }};
				margin: {{ data.selector_text_margin }};
				color: {{ data.selector_text_color }};
			}';

		$output .= $lodash->unit('font-size', '.sppb-modal-selector span.text', 'data.selector_text_size', 'px');
		$output .= '<# } #>';
		
		$output .= '
	    </style>

	
		<div class="sppb-addon {{ data.class }}">
		<# if( modalContentType == "text") {#>
			<div id="{{ modalUniqueId }}" class="mfp-hide">
				<div style="max-width: {{ data.modal_popup_width }}px;" class="sppb-addon-modal-content mx-auto clearfix text-start">
					{{{ data.modal_content_text }}}
				</div>
			</div>
	    <#
		} else if( modalContentType == "video") {
			modalUrl = data.modal_content_video_url
			attribs = \'data-popup_type="iframe" data-mainclass="mfp-no-margins mfp-with-zoom"\'
		} else {
	    #>
			<div id="{{ modalUniqueId }}" class="mfp-hide popup-image-block modal-selector-image">
				<div class="modal-inner-block">
					<#
					var modal_content_image_alt_text = data.modal_content_image_alt_text || "";

					var modal_content_image = {}
					if (typeof data.modal_content_image !== "undefined" && typeof data.modal_content_image.src !== "undefined") {
						modal_content_image = data.modal_content_image
					} else {
						modal_content_image = {src: data.modal_content_image}
					}
					if(modal_content_image.src && modal_content_image.src.indexOf("https://") == -1 && modal_content_image.src.indexOf("http://") == -1){
					#>
						<img style="max-width:{{ data.modal_popup_width }}px;" class="mfp-img" src=\'{{ pagebuilder_base + modal_content_image.src }}\' alt=\'{{modal_content_image_alt_text}}\' >
					<# } else { #>
						<img style="max-width:{{ data.modal_popup_width }}px;" class="mfp-img" src=\'{{ modal_content_image.src }}\' alt=\'{{modal_content_image_alt_text}}\' >
					<# } #>
				</div>
			</div>
	    <# } #>

	    
			<#
			var selector_image = {}
			if (typeof data.selector_image !== "undefined" && typeof data.selector_image.src !== "undefined") {
				selector_image = data.selector_image
			} else {
				selector_image = {src: data.selector_image}
			}

			var selector_image_alt_text = data.selector_image_alt_text || "";

			if(data.modal_selector == "image") {
			#>
				<a class="sppb-modal-selector sppb-magnific-popup" {{{ attribs }}} href=\'{{ modalUrl }}\' id="{{ modalUniqueId }}">
					<# if(selector_image.src && selector_image.src.indexOf("https://") == -1 && selector_image.src.indexOf("http://") == -1){ #>
						<img src=\'{{ pagebuilder_base + selector_image.src }}\' alt=\'{{selector_image_alt_text}}\' >
					<# } else { #>
						<img src=\'{{ selector_image.src }}\' alt=\'{{selector_image_alt_text}}\' >
					<# } #>
					<# if(data.selector_text){ #>
						<span class="text">{{ data.selector_text }}</span>
					<# } #>
				</a>
			<# } else if (data.modal_selector == "icon"){
				let select_icon_arr = (typeof data.selector_icon_name !== "undefined" && data.selector_icon_name) ? data.selector_icon_name.split(" ") : "";
				let select_icon_name = select_icon_arr.length === 1 ? "fa "+data.selector_icon_name : data.selector_icon_name;
			#>
				<a class="sppb-modal-selector sppb-magnific-popup" href=\'{{ modalUrl }}\' {{{ attribs }}} id="{{ modalUniqueId }}">
					<span class="sppb-modal-icon-wrap">
						<# if(data.peicon_name){ #>
							<i class="pe {{ data.peicon_name }}"></i>
						<# } else { #>
							<i class="{{ select_icon_name }}"></i>
						<# } #>
						<# if(data.show_ripple_effect) { #>
							<span class="sppb-ripple-effect"></span>
						<# } #>
					</span>
					<# if(data.selector_text){ #>
						<span class="text">{{ data.selector_text }}</span>
					<# } #>
				</a>
			<# } else {
				let btn_peicon_arr = (typeof data.button_peicon !== "undefined" && data.button_peicon) ? data.button_peicon.split(" ") : "";
				let btn_peicon_name = btn_peicon_arr.length === 1 ? "pe "+data.button_peicon : data.button_peicon;
				
				let btn_icon_arr = (typeof data.button_icon !== "undefined" && data.button_icon) ? data.button_icon.split(" ") : "";
				let btn_icon_name = btn_icon_arr.length === 1 ? "fa "+data.button_icon : data.button_icon;
			#>
				<a class="sppb-btn {{ buttonClass }} sppb-magnific-popup sppb-modal-selector" {{{ attribs }}} href=\'{{ modalUrl }}\' id="{{ modalUniqueId }}"><# if( buttonIconPosition == "left" ) { #><# if(btn_peicon_name){ #><i class="{{ btn_peicon_name }} pe-va me-1"></i><# } else { #><i class="{{ btn_icon_name }} me-1"></i><# } #><# } #> {{ data.button_text }} <# if( buttonIconPosition == "right" ) { #><# if(data.button_peicon){ #><i style="margin-left:7px;margin-right:-1px;" class="{{ btn_peicon_name }} pe-va"></i><# } else { #><i style="margin-left:5px;margin-right:-1px;" class="{{ btn_icon_name }} pe-va"></i><# } #><# } #></a>
			<# } #>
	    </div>';

		return $output;
	}

}
