<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonPlyr extends SppagebuilderAddons{

	public function render() {
		
		$app = Factory::getApplication();
		
		$settings = $this->addon->settings;
		$addon_id = $this->addon->id;

		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
		
		$media = (isset($settings->media) && $settings->media) ? $settings->media : '';
		
		//$video = (isset($settings->video) && $settings->video) ? $settings->video : '';
		
		$mp4_video = (isset($settings->video) && $settings->video) ? $settings->video : '';
		$mp4_video_src = isset($mp4_video->src) ? $mp4_video->src : $mp4_video;
		
		//$video_poster = (isset($settings->video_poster) && $settings->video_poster) ? $settings->video_poster : '';
		
		$video_poster = (isset($settings->video_poster) && $settings->video_poster) ? $settings->video_poster : '';
		$video_poster_src = isset($video_poster->src) ? $video_poster->src : $video_poster;
		
		$captions = (isset($settings->captions) && $settings->captions) ? $settings->captions : '';
		$captions_lang_label = (isset($settings->captions_lang_label) && $settings->captions_lang_label) ? $settings->captions_lang_label : '';
		$captions_srclang = (isset($settings->captions_srclang) && $settings->captions_srclang) ? $settings->captions_srclang : '';
		
		
		//$audio = (isset($settings->audio) && $settings->audio) ? $settings->audio : '';
		
		$mp3_audio = (isset($settings->audio) && $settings->audio) ? $settings->audio : '';
		$mp3_audio_src = isset($mp3_audio->src) ? $mp3_audio->src : $mp3_audio;
		
		$youtube_vimeo_url = (isset($settings->youtube_vimeo_url) && $settings->youtube_vimeo_url) ? $settings->youtube_vimeo_url : '';
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? $settings->autoplay : '';
		
		$captions_toggle = (isset($settings->captions_toggle) && $settings->captions_toggle) ? $settings->captions_toggle : '';
		$tooltips = (isset($settings->tooltips) && $settings->tooltips) ? $settings->tooltips : '';
		
		
		
		$autoplay == '1' ? $autoplay = 'autoplay:true,' : $autoplay = '';
		$captions_toggle == '1' ? $captions_toggle = 'captions:{defaultActive:true},' : $captions_toggle = '';
		$tooltips == '1' ? $tooltips = 'tooltips:{controls:true,seek:true},' : $tooltips = '';
		
		$show_captions = '';
		$src_captions = '';
		$show_minimal = '';
		$src_video = '';
		$src_video_poster = '';
		$src_audio = '';
		$data_type = '';


	$class != '' ? $class = ' ' . $class : $class = '';
		
	if ($mp4_video_src && (strpos($mp4_video_src, "http://") !== false || strpos($mp4_video_src, "https://") !== false)) {
		$mp4_video = $mp4_video_src;
	} else {
		if (!empty($mp4_video)) {
			$mp4_video = Uri::base(true) . '/' . $mp4_video_src;
		}
	}


	if ($video_poster_src && (strpos($video_poster_src, "http://") !== false || strpos($video_poster_src, "https://") !== false)) {
		$video_poster = $video_poster_src;
	} else {
		if (!empty($video_poster)) {
			$video_poster = Uri::base(true) . '/' . $video_poster_src;
		}
	}

	
	if($captions) {
		if (false === strpos($captions, '://')) {
		    $src_captions = Uri::root() . $captions;
		} else {
			$src_captions = $captions;
		}
		$show_captions = '\'captions\', ';
	}

		
	if ($mp3_audio_src && (strpos($mp3_audio_src, "http://") !== false || strpos($mp3_audio_src, "https://") !== false)) {
		$mp3_audio = $mp3_audio_src;
	} else {
		if (!empty($mp3_audio)) {
			$mp3_audio = Uri::base(true) . '/' . $mp3_audio_src;
		}
	}
		

	if($youtube_vimeo_url) {

		$yv_video = parse_url($youtube_vimeo_url);
		
		switch($yv_video['host']) {
			case 'youtu.be':
				$id = trim($yv_video['path'],'/');
				$src_youtube = $id;
				$data_type = 'youtube';
			break;
			
			case 'www.youtube.com':
			case 'youtube.com':
				parse_str($yv_video['query'], $query);
				$id = $query['v'];
				$src_youtube = $id;
				$data_type = 'youtube';
			break;

			case 'vimeo.com':
			case 'www.vimeo.com':
			case 'player.vimeo.com':
				$id = trim($yv_video['path'],'/');
				$src_vimeo = $id;
				$data_type = 'vimeo';

		}
	}
	
		$output  = '<div class="sppb-addon sppb-addon-plyr'. $class .'">';

		$output .= ($title) ? '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>' : '';

		// Plyr Starts
		if ($media == '1') {		
			
			$output .= '<video id="plyr-media-player-'.$addon_id.'" class="w-100 object-fit-contain" poster="'. $video_poster .'" controls crossorigin>';
			$output .= '<source src="'. $mp4_video .'" type="video/mp4">';
			$output .= '<!-- Text track file -->';
			$output .= '<track kind="captions" label="'. $captions_lang_label .'" srclang="'. $captions_srclang .'" src="'. $src_captions .'" default>';
			$output .= '<!-- Fallback for browsers that don’t support the <video> element -->';
			$output .= '<a href="'. $mp4_video .'">'. Text::_('FLEX_DOWNLOAD') .'</a>';
			$output .= '</video>';
		}
		
		if ($media == '2') {	
			// Audio Player
			$output .= '<audio id="plyr-media-player-'.$addon_id.'" controls>';
			//$output .= '<source src="' . $mp3_audio . '" type="audio/mpeg">';
			$output .= '<source src="' . EditorUtils::stringifyMediaItem($mp3_audio) . '" type="audio/mpeg">';
			$output .= '<a href="' . $mp3_audio . '">'. Text::_('FLEX_DOWNLOAD') .'</a>';
			$output .= 'Your browser does not support the audio element.';
			$output .= '</audio>';
		}
		
		if ($media == '3') {	
			// Youtube 		
			if ($data_type == "youtube") {
				$output .= '<div id="plyr-media-player-'.$addon_id.'" data-video-id="'. $src_youtube .'" data-type="'. $data_type .'"></div>';
			}
			// Vimeo
			if ($data_type == "vimeo") {
				$output .= '<div id="plyr-media-player-'.$addon_id.'" data-video-id="'. $src_vimeo .'" data-type="vimeo"></div>';
			}
		
		}
		
		$output .= '</div>';
		
		// Since <audio> is doubled in front-end editor, we included it here, and <video>, YouTube and Vimeo under "public function js()" further below
		if ($media == '2') {
			
			//$output .= '<script type="text/javascript">var player = plyr.setup(\'#plyr-media-player-'.$addon_id.'\');</script>';
			$output .= '<script type="text/javascript">
			var player = plyr.setup(\'#plyr-media-player-'.$addon_id.'\', {
			'.$autoplay.'
			showPosterOnEnd: true,
			controls: [\'play-large\', \'play\', \'progress\', \'current-time\', \'mute\', \'volume\', '. $show_captions .'\'fullscreen\'],
			i18n: {
				play:"'. Text::_('FLEX_ADDON_PLYR_PLAY') .'",
				pause:"'. Text::_('FLEX_ADDON_PLYR_PAUSE') .'",
				toggleMute:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_MUTE') .'",
				toggleCaptions:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_CAPTIONS') .'",
				toggleFullscreen:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_FULLSCREEN') .'"
			},
			'.$captions_toggle.'
			'.$tooltips.'
			volume: 7,
			iconUrl:"'.Uri::base(true) . '/templates/'.$app->getTemplate().'/sppagebuilder/addons/plyr/assets/css/plyr.svg"
			});</script>';
			
		}

		$output = preg_replace('/[\n\t]+/m', '', $output); // Remove whitespace
		
		return $output;
	}
	
	
	public function stylesheets() {
		$app = Factory::getApplication();
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();	
		return array( $tmplPath.'/sppagebuilder/addons/plyr/assets/css/plyr.css');
	}
	

	public function scripts() {
		$app = Factory::getApplication();
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();	
		return array( $tmplPath.'/sppagebuilder/addons/plyr/assets/js/plyr.js');
	}
	
	public function js() {
		
		// To bring Plyr to front-end admin (SPPB front-end editor)
		$app = Factory::getApplication();	
		$settings = $this->addon->settings;
		$addon_id = $this->addon->id;

		$media = (isset($settings->media) && $settings->media) ? $settings->media : '';
		$captions = (isset($settings->captions) && $settings->captions) ? $settings->captions : '';
		$captions_toggle = (isset($settings->captions_toggle) && $settings->captions_toggle) ? $settings->captions_toggle : '';
		$tooltips = (isset($settings->tooltips) && $settings->tooltips) ? $settings->tooltips : '';
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? $settings->autoplay : '';
		
		$autoplay == '1' ? $autoplay = 'autoplay:true,' : $autoplay = '';
		$captions_toggle == '1' ? $captions_toggle = 'captions:{defaultActive:true},' : $captions_toggle = '';
		$tooltips == '1' ? $tooltips = 'tooltips:{controls:true,seek:true},' : $tooltips = '';
		
		$show_captions = '';
		$src_captions = '';
		$js = '';
		
		if($captions) {
			if (false === strpos($captions, '://')) {
				$src_captions = Uri::root() . $captions;
			} else {
				$src_captions = $captions;
			}
			$show_captions = '\'captions\', ';
		}

		// var player = plyr.setup("#plyr-media-player-'.$addon_id.'");

		if ($media != '2') {
			
			$js = '
			function r(f){/in/.test(document.readyState)?setTimeout("r("+f+")",9):f()}r(function(){	

				var player = plyr.setup("#plyr-media-player-'. $addon_id .'", {
				'. $autoplay .'
				showPosterOnEnd: true,
				controls: [\'play-large\', \'play\', \'progress\', \'current-time\', \'mute\', \'volume\', '. $show_captions .'\'fullscreen\'],
				i18n: {
					play:"'. Text::_('FLEX_ADDON_PLYR_PLAY') .'",
					pause:"'. Text::_('FLEX_ADDON_PLYR_PAUSE') .'",
					toggleMute:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_MUTE') .'",
					toggleCaptions:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_CAPTIONS') .'",
					toggleFullscreen:"'. Text::_('FLEX_ADDON_PLYR_TOGGLE_FULLSCREEN') .'"
				},
				'.$captions_toggle.'
				'.$tooltips.'
				volume: 7,
				iconUrl:"'.Uri::base(true) . '/templates/'.$app->getTemplate().'/sppagebuilder/addons/plyr/assets/css/plyr.svg"
				});
				
			});';
		}
			
		/*
		} else if ($media == '3') {
			$js = 'function r(f){/in/.test(document.readyState)?setTimeout("r("+f+")",9):f()}r(function(){var player = plyr.setup("#plyr-media-player-'.$addon_id.'")});';
		} 
		
		else {
			$js = 'function r(f){/in/.test(document.readyState)?setTimeout("r("+f+")",9):f()}r(function(){var player = plyr.setup("audio#plyr-media-player-'.$addon_id.'")});';
		}
		*/

		$js = preg_replace(array('/([\s])\1+/', '/[\n\t]+/m'), '', $js); // Removes whitespace
		return $js;
	}

}
