<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;


SpAddonsConfig::addonConfig([
	'type' => 'repeatable',
	'addon_name' => 'sp_lightbox',
	'title' => Text::_('FLEX_ADDON_IMAGELIGHTBOX'),
	'desc' => Text::_('FLEX_ADDON_IMAGELIGHTBOX_DESC'),
	'category' => 'Flex',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'sp_lightbox_item' => [
					'type'	=> 'repeatable',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ITEMS'),
					'std'   => [
                            [
                                'thumb' => ['src' => 'https://source.unsplash.com/aAd6zv2rdBI/400x200'],
								'full' => ['src' => 'https://source.unsplash.com/aAd6zv2rdBI/900x600'],
                            ],
                            [
                                'thumb' => ['src' => 'https://source.unsplash.com/d6NJmJ60B8M/400x200'],
								'full' => ['src' => 'https://source.unsplash.com/d6NJmJ60B8M/900x600'],
								'show_caption'  => 1,
								'title'  => 'A person swimming in the water near kaleidoscopic-colored coral reefs | Islands of NEOM, Saudi Arabia',
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/RySPDa0FdcQ/230x448'],
								'full' => ['src' => 'https://source.unsplash.com/RySPDa0FdcQ/600x800'],
								'show_caption'  => 1,
								'title'  => 'Caption: The sun is setting over a desert landscape',
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/yx7TJle8LhM/400x200'],
								'full' => ['src' => 'https://source.unsplash.com/yx7TJle8LhM/900x560'],
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/B5drkS_Z5RM/400x270'],
								'full' => ['src' => 'https://source.unsplash.com/B5drkS_Z5RM/900x600'],
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/t3dlLOhdEzs/450x236'],
								'full' => ['src' => 'https://source.unsplash.com/t3dlLOhdEzs/900x580'],
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/AMiglZWQSQQ/230x316'],
								'full' => ['src' => 'https://source.unsplash.com/AMiglZWQSQQ/660x820'],
								'show_caption'  => 1,
								'title'  => 'Delta Lake - Grand Teton National Park',
                            ],
													[
                            'thumb' => ['src' => 'https://source.unsplash.com/XJJIJ_DJWdE/400x320'],
								'full' => ['src' => 'https://source.unsplash.com/XJJIJ_DJWdE/900x480'],
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/yetQBOG_ZWg/400x260'],
								'full' => ['src' => 'https://source.unsplash.com/yetQBOG_ZWg/900x620'],
                            ],
                        ],

					'attr'  => [
						'title' => [
							'type'  => 'text',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE_DESC'),
							'std'   => 'Lightbox Item'
						],

						'thumb' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB_DESC'),
							'std'   => [
								'src'    => 'https://source.unsplash.com/aAd6zv2rdBI/400x200',
								'height' => '',
								'width'  => '',
							],
						],

						'full' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL_DESC'),
							'std'   => [
								'src'    => 'https://source.unsplash.com/aAd6zv2rdBI/800x400',
								'height' => '',
								'width'  => '',
							],
						],

						'caption_separator' => [
							'type' => 'separator',
						],
						
						'show_caption' => [
							'type'   => 'checkbox',
							'title'=>Text::_('FLEX_ADDON_IMAGELIGHTBOX_SHOW_CAPTION'),
							'desc'=>Text::_('FLEX_ADDON_IMAGELIGHTBOX_SHOW_CAPTION_DESC'),
							'values' => [
								1 => Text::_('JYES'),
								0 => Text::_('JNO'),
							],
							'std' => 1,
						],
					],
				],
			],
		],

		'options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
			'fields' => [
				'width' => [
					'type' => 'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_IMAGE_WIDTH'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_IMAGE_WIDTH_DESC'),
					//'responsive' => true,
					//'std' => ['xl' => 260],
					'min' => 20,
					'max' => 1000,
					'std'=> 180,
				],

				'spacing' => [
					'type' => 'slider',
					'title'=>Text::_('FLEX_THUMBNAIL_SPACING'),
					'desc'=>Text::_('FLEX_THUMBNAIL_SPACING_DESC'),
					//'responsive' => true,			
					//'min' => 0,
					'max' => 80,
					'std' => 12,
				],
				
				'class' => [
					'type' => 'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => '',
				],
			]
		],

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				],

				'heading_selector' => [
					'type'   => 'headings',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'std'   => 'h3',
				],

				'title_typography' => [
					'type'     => 'typography',
					'title'  	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'title_font_family',
						'size' => 'title_fontsize',
						'line_height' => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase' => 'title_font_style.uppercase',
						'italic' => 'title_font_style.italic',
						'underline' => 'title_font_style.underline',
						'weight' => 'title_font_style.weight',
					],
				],

				'title_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'title_margin_separator' => [
					'type' => 'separator',
				],

				'title_margin_top' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
					'max'        => 400,
					'responsive' => true,
				],

				'title_margin_bottom' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
					'max'        => 400,
					'responsive' => true,
				],
			],
		],
	],
]);
