<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Http\Http;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonFlickr extends SppagebuilderAddons
{

	public function render()
	{
		
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? ' ' . $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
		$count = (isset($settings->count) && $settings->count) ? $settings->count : 0;
		$height = (isset($settings->height) && $settings->height) ? $settings->height : '';
		$api_code = (isset($settings->api) && $settings->api) ? $settings->api : '2fc5721d612333f915b8ab6c9def835f';
		$images = $this->getImages();

		// Output
		$output  = '<div class="sppb-addon sppb-addon-flickr ' . $class . '">';
		$output .= ($title) ? '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>' : '';
		$output .= '<div class="sppb-addon-content">';
		$output .= '<ul class="sppb-flickr-gallery">';

		if ($api_code === '2fc5721d612333f915b8ab6c9def835f')
		{
			for ($i = 0; $i < $count; $i++)
			{
				$output .= '<li>';
				$output .= '<a target="_blank" rel="noopener noreferrer" href="' . str_replace('_m', '_b', $images[$i]->media->m) . '" class="sppb-flickr-gallery-btn">';
				$output .= '<img class="sppb-img-responsive" src="' . str_replace('_m', '_q', $images[$i]->media->m) . '" alt="' . $images[$i]->title . '" loading="lazy">';
				$output .= '</a>';
				$output .= '</li>';
			}
		}
		else
		{
			foreach ($images as $image)
			{
				$image_url = "https://farm" . $image->farm . ".staticflickr.com/" . $image->server . "/" . $image->id . "_" . $image->secret . "_b.jpg";

				$output .= '<li>';
				$output .= '<a target="_blank" rel="noopener noreferrer" href="' . $image_url . '" class="sppb-flickr-gallery-btn">';
				$output .= '<img class="sppb-img-responsive" src="' . substr_replace($image_url, "_q", -6, 2) . '" alt="' . $image->title . '" loading="lazy">';
				$output .= '</a>';
				$output .= '</li>';
			}
		}

		$output .= '</ul>';
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function css()
	{
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		//$cssHelper = new CSSHelper($addon_id);

		$thumb_per_row  = (isset($settings->thumb_per_row) && $settings->thumb_per_row) ? $settings->thumb_per_row : 4;
		$height = (isset($settings->height) && $settings->height) ? $settings->height : '';
		$width = round((100 / $thumb_per_row), 2);
		$settings->flickr_thumbnail_width = $width;

		$css = '';

		/*
		if ($thumb_per_row)
		{
			$thumbStyle = $cssHelper->generateStyle('.sppb-flickr-gallery li', $settings, ['flickr_thumbnail_width' => 'height: auto; width: %s'], '%');
			$css .= $thumbStyle;
		}
		*/
		
		if($thumb_per_row) {
			$css .= $addon_id . ' .sppb-flickr-gallery li {';
			$css .= 'width:'.$width.'%;';
			$css .= 'height:auto;';
			$css .= '}';
		}
		if($height) {
			$css .= $addon_id . ' .sppb-flickr-gallery li a img {';
			$css .= 'height:' . $height . 'px;object-fit:cover;';
			$css .= '}';
		}

		return $css;
	}

	public function stylesheets()
	{
		return array(Uri::base(true) . '/components/com_sppagebuilder/assets/css/magnific-popup.css');
	}

	public function scripts()
	{
		return array(Uri::base(true) . '/components/com_sppagebuilder/assets/js/jquery.magnific-popup.min.js');
	}

	public function js()
	{
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$js = 'jQuery(function($){
			$("' . $addon_id . ' ul li").magnificPopup({
				delegate: "a",
				type: "image",
				mainClass: "mfp-no-margins mfp-with-zoom",
				gallery:{
					enabled:true
				},
				image: {
					verticalFit: true
				},
				zoom: {
					enabled: true,
					duration: 300
				}
			});
		})';

		return $js;
	}

	private function getImages()
	{

		$settings = $this->addon->settings;
		$cache_path = JPATH_CACHE . '/com_sppagebuilder/addons/addon-' . $this->addon->id;
		$cache_file = $cache_path . '/flickr.json';

		if (!Folder::exists($cache_path))
		{
			Folder::create($cache_path, 0755);
		}

		if (File::exists($cache_file) && (filemtime($cache_file) > (time() - 60 * 30)))
		{
			$images = file_get_contents($cache_file);
		}
		else
		{
			$id = (isset($settings->id) && $settings->id) ? $settings->id : '';
			$api_code = (isset($settings->api) && $settings->api) ? $settings->api : '2fc5721d612333f915b8ab6c9def835f';
			$count = (isset($settings->count) && $settings->count) ? $settings->count : 0;

			if ($api_code == '2fc5721d612333f915b8ab6c9def835f')
			{
				$api = 'https://api.flickr.com/services/feeds/photos_public.gne?id=' . $id . '&format=json&nojsoncallback=1';
			}
			else
			{
				$api = 'https://api.flickr.com/services/rest/?method=flickr.photos.search&api_key=' . $api_code . '&user_id=' . $id . '&per_page=' . $count . '&format=json&nojsoncallback=1';
			}

			$http = new Http;

			$imagesResponse = $http->get($api);
			$images = $imagesResponse->body;

			if ($imagesResponse->code !== 200)
			{
				// throw new Exception($imagesResponse->error->message);
			}

			if (!empty($images))
			{
				File::write($cache_file, $images);
			}
		}

		$json = json_decode($images);

		if (isset($json->photos->photo))
		{
			return $json->photos->photo;
		}
		elseif (isset($json->items))
		{
			return $json->items;
		}

		return array();
	}
}
