<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'countdown',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_DESC'),
	'category'   => 'Content',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'date' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_DATE'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_DATE_DESC'),
					'placeholder' => '2025/06/12',
					'std'         => '2025/06/12',
				],

				'time' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_TIME'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_TIME_DESC'),
					'placeholder' => '20:23',
					'std'         => '20:23',
				],


				'label_typography_separator' => [
					'type' => 'separator',
				],

				'label_typography' => [
					'type'     => 'typography',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_LABELS'),
					'fallbacks'   => [
						'font' => 'label_font_family',
						'size' => 'label_font_size',
						'uppercase' => 'label_font_style.uppercase',
						'italic' => 'label_font_style.italic',
						'underline' => 'label_font_style.underline',
						'weight' => 'label_font_style.weight',
					],
				],
				
				'label_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_LABEL_COLOR'),
				],

				'label_margin' => [
					'type'       => 'margin',
					'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_COUNTER_LABEL_MARGIN'),
					'responsive' => true,
				],
			],
		],

		'counter' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_COUNTER'),
			'fields' => [
				'counter_width' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_WIDTH'),
					'max'        => 500,
					'responsive' => true,
					'std'        => ['xl' => 80],
					//'std'        => 80,
				],

				'counter_height' => [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_HEIGHT'),
					'placeholder' => '',
					'max'         => 500,
					'responsive' => true,
					'std'        => ['xl' => 80],
				],
				
				'counter_text_typography' => [
					'type'     => 'typography',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_NUMBERS'),
					'fallbacks'   => [
						'font' => 'counter_text_font_family',
						'size' => 'counter_font_size',
						'weight' => 'counter_text_font_weight',
					],
				],

				'counter_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_NUMBER_COLOR'),
					//'std'    => '#FFFFFF',
				],

				'counter_background_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					//'std'    => '#F14833',
				],

				'counter_border_separator' => [
					'type' => 'separator',
				],

				'counter_user_border' => [
					'type'  => 'checkbox',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER'),
					'std'   => 0,
					'group' => [
						'counter_border_width',
						'counter_border_style',
						'counter_border_color'
					],
				],

				'counter_border_width' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_WIDTH'),
					'std'        => ['xl' => 1],
					'max'        => 500,
					'responsive' => true,
					'depends'    => ['counter_user_border' => 1],
				],

				'counter_border_style' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_STYLE'),
					'values' => [
						'none'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_STYLE_NONE'),
						'solid'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_STYLE_SOLID'),
						'double' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_STYLE_DOUBLE'),
						'dotted' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_STYLE_DOTTED'),
						'dashed' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_STYLE_DASHED'),
					],
					'std'     => 'solid',
					'inline'  => true,
					'depends' => ['counter_user_border' => 1],
				],

				'counter_border_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'std'     => '#E5E5E5',
					'depends' => ['counter_user_border' => 1],
				],

				'counter_border_radius_separator' => [
					'type' => 'separator',
				],

				'counter_border_radius' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
					//'std'        => ['xl' => 4],
					'std'        => 4,
					'max'        => 500,
					//'responsive' => true,
				],
			],
		],
		
		'finished_text' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_FINISHED_TEXT'),
			'fields' => [
				'finish_text' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_FINISHED_TEXT'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_COUTNDOWN_FINISHED_TEXT_DESC'),
					'std'         => 'Finally we are here',
				],
				
				'finish_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('Finished Text Color'),
				],
				
				'finish_text_typography' => [
					'type' => 'typography',
					'title' => Text::_('Finished Text Typography'),
					//'desc' => Text::_('FLEX_COUTNDOWN_FINISHED_TEXT_FONT_SIZE_DESC'),
					'fallbacks' => [
						'font' => 'counter_text_font_family',
						'size' => 'counter_font_size',
						'weight' => 'counter_text_font_weight',
					],
					'depends' => [['finish_text', '!=', '']],
				],

			],
		],

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
				],

				'heading_selector' => [
					'type'   => 'headings',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'std'   => 'h3',
				],

				'title_typography' => [
					'type'     => 'typography',
					'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'title_font_family',
						'size' => 'title_fontsize',
						'line_height' => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase' => 'title_font_style.uppercase',
						'italic' => 'title_font_style.italic',
						'underline' => 'title_font_style.underline',
						'weight' => 'title_font_style.weight',
					],
				],

				'title_text_color' => [
					'type'   => 'color',
					'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'title_margin_top' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
					'max'        => 500,
					'responsive' => true,
				],

				'title_margin_bottom' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
					'max'        => 500,
					'responsive' => true,
				],
			],
		],
	],
]);