<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

class SppagebuilderAddonAnimated_number extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;

		$number = (isset($settings->number) && $settings->number) ? $settings->number : 0;
		$duration = (isset($settings->duration) && $settings->duration) ? $settings->duration : 0;
		$format = (isset($settings->use_number_format) && $settings->use_number_format) ? $settings->use_number_format : 0;
		$counter_title = (isset($settings->counter_title) && $settings->counter_title) ? $settings->counter_title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
	
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$number_position = (isset($settings->number_position) && $settings->number_position) ? 'animated-number-position-' . $settings->number_position : '';
		$numberClass = (isset($settings->number_class) && $settings->number_class) ? ' '. $settings->number_class : ' px-2';

		$output  = '<div class="sppb-addon sppb-addon-animated-number ' . $class . ' ' . $number_position . '">';
		$output .= '<div class="sppb-addon-content">';
		$output .= '<div class="sppb-animated-number'. $numberClass .'" data-format="'. $format .'" data-digit="' . $number . '" data-duration="' . $duration . '">0</div>';
		
		if ($counter_title) {
			//$output .= '<div class="sppb-animated-number-title">' . $counter_title . '</div>';
			$output .= '<'. $heading_selector .' class="sppb-animated-number-title">' . $counter_title . '</'. $heading_selector .'>';
		}
		
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function css() {
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;
		$cssHelper = new CSSHelper($addon_id);

		$number_before_after_text = (isset($settings->number_before_after_text) && $settings->number_before_after_text) ? $settings->number_before_after_text : '';
		$number_before_after_text_position = (isset($settings->number_before_after_text_position) && $settings->number_before_after_text_position) ? $settings->number_before_after_text_position : '';
		
		$number_position = (isset($settings->number_position) && $settings->number_position) ? $settings->number_position : '';
		
		$font_size = (isset($settings->font_size) && $settings->font_size) ? $settings->font_size : '';
		
		$title_font_size = (isset($settings->title_font_size) && $settings->title_font_size) ? $settings->title_font_size : '';
		
		
		// Additional (Flex)
		$background = (isset($settings->background) && $settings->background) ? $settings->background : '';
		$border_color = (isset($settings->border_color) && $settings->border_color) ? $settings->border_color : '';
		$border_width = (isset($settings->border_width) && $settings->border_width) ? $settings->border_width : '';
		$border_radius = (isset($settings->border_radius) && $settings->border_radius) ? $settings->border_radius : '';
		$numberClass = (isset($settings->number_class) && $settings->number_class) ? $settings->number_class : '';

		$css = '';
		$classStyle = '';
		$paddingbox = '';
		
		// Animated number font-size
		$css .= (isset($font_size) && $font_size) ? '' : $addon_id .' .sppb-animated-number {font-size:40px;}';
		// Title size
		$css .= (isset($title_font_size) && $title_font_size) ? '' : $addon_id .' .sppb-animated-number-title {font-size:22px;}';
	
		if ($numberClass == 'shadow') {
			$classStyle .= $addon_id .' .sppb-addon-animated-number .sppb-animated-number {box-shadow:0 0 15px rgba(0,0,0,0.2);text-shadow: 1px 2px 2px rgba(0,0,0,0.25);padding:20px;}';
		} else {
			if ( $background == '') {
			   $classStyle .= $addon_id .' .sppb-addon-animated-number .sppb-animated-number {padding:18px 0;}';
			} else {
			   $classStyle .= $addon_id .' .sppb-addon-animated-number .sppb-animated-number {padding:18px;}';
			}
		}

		if ($number_position == 'top' || $number_position == 'bottom') {
			$classStyle .= $addon_id .' .sppb-animated-number {margin:0 auto;}';
		} else {
			$classStyle .= $addon_id .' .sppb-animated-number-title {padding:0;}';
		}

		$borderStyle = $cssHelper->generateStyle('.sppb-addon-animated-number .sppb-animated-number', $settings, ['border_width' => 'border-style:solid;padding:15px;border-width', 'border_color' => 'border-color', 'border_radius' => 'border-radius'], ['border_width' => 'px', 'border_color' => false, 'border_radius' => 'px']);
		
		$backgroundStyle = $cssHelper->generateStyle('.sppb-addon-animated-number .sppb-animated-number', $settings, ['background' => 'background-color'], false);
		
		$css .= (isset($font_size) && $font_size) ? '' : $addon_id .' .sppb-animated-number {font-size:40px;}';

		$settings->alignment = CSSHelper::parseAlignment($settings, 'alignment');

		$alignmentStyle = $cssHelper->generateStyle('.sppb-addon.sppb-addon-animated-number', $settings, ['alignment' => 'text-align'], false);
		$numberStyle = $cssHelper->generateStyle('.sppb-animated-number', $settings, ['color' => 'color'], false);

		$numberTypographyFallbacks = [
			'font'        => 'number_font_family',
			'size'        => 'font_size',
			'line_height' => 'line_height',
			'weight'      => 'number_font_wight',
		];

		$numberTypography = $cssHelper->typography('.sppb-animated-number', $settings, 'number_typography', $numberTypographyFallbacks);
		
		$titleStyle = $cssHelper->generateStyle('.sppb-animated-number-title', $settings, ['title_color' => 'color', 'title_margin' => 'margin'], ['title_color' => false, 'title_margin' => false], ['title_margin' => 'spacing']);

		$numberTitleTypographyFallbacks = [
			'font'        => 'title_font_family',
			'size'        => 'title_font_size',
			'line_height' => 'title_line_height',
			'weight'      => 'title_fontstyle.weight',
			'italic'      => 'title_fontstyle.italic',
			'underline'   => 'title_fontstyle.underline',
			'uppercase'   => 'title_fontstyle.uppercase',
		];

		$numberTitleTypography = $cssHelper->typography('.sppb-animated-number-title', $settings, 'title_typography', $numberTitleTypographyFallbacks);

		$css .= $alignmentStyle;
		$css .= $numberStyle;
		$css .= $numberTypography;
		$css .= $titleStyle;
		$css .= $numberTitleTypography;
		
		$css .= $backgroundStyle;
		$css .= $borderStyle;
		$css .= $classStyle;

		if ($number_before_after_text_position === 'right')
		{
			if ($number_before_after_text)
			{
				$css .= $addon_id . ' .sppb-animated-number::after {';
				$css .= 'content:"' . $number_before_after_text . '";';
				$css .= 'display: inline-block;';
				$css .= '}';
			}
		}
		else
		{
			if ($number_before_after_text)
			{
				$css .= $addon_id . ' .sppb-animated-number::before {';
				$css .= 'content:"' . $number_before_after_text . '";';
				$css .= 'display: inline-block;';
				$css .= '}';
			}
		}
		return $css;
	}

	public static function getTemplate() {
		$lodash = new Lodash('#sppb-addon-{{ data.id }}');
		
		$output = '
		<#
			var addonId = "sppb-addon-" + data.id;
			var number_position = (!_.isEmpty(data.number_position) && data.number_position) ? "animated-number-position-"+data.number_position : "";
			
			var heading_selector = (!_.isEmpty(data.heading_selector) && data.heading_selector) ? data.heading_selector : "h3";
			
		#>
		<style type="text/css">
			<# if(data.number_before_after_text_position == "right") { #>
				#{{ addonId }} .sppb-animated-number::after{
					content:"{{data.number_before_after_text}}";
				}
			<# } else { #>
				#{{ addonId }} .sppb-animated-number::before{
					content:"{{data.number_before_after_text}}";
				}
			<# } #>
			';
		
		// Counter number font-size
		$output .= '<# if (data.font_size) { #>';
		$output .= '<# } else { #>#sppb-addon-{{ data.id }} .sppb-animated-number {font-size:40px}<# } #>';
		
		// Title font-size
		$output .= '<# if (data.title_font_size) { #>';
		$output .= '<# } else { #>#sppb-addon-{{ data.id }} .sppb-animated-number-title {font-size:18px}<# } #>';
		
		$output .= '<# if (data.number_class == "shadow") { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {box-shadow:0 0 15px rgba(0,0,0,0.2);text-shadow: 1px 2px 2px rgba(0,0,0,0.25);padding:0px;}';
		$output .= '<# } #>';
	
		$output .= '<# if (!_.isEmpty(data.border_width)) { #>';
			$output .= '<# if ( data.number_class == "padding" || data.background || data.border_width > 0 ) { #>';
				$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {padding:0px;}';
			$output .= '<# } #>';
		$output .= '<# } else { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {border-width:0}';
		$output .= '<# } #>';
		
		$output .= '<# if (!_.isEmpty(data.background || data.background != "")) { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {padding:18px;}';
		$output .= '<# } else { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {padding:18px 0;}';
		$output .= '<# } #>';
		
		$output .= '<# if (data.number_position == "left") { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number-title{padding-left:5px;}';
		$output .= '<# } else if (data.number_position == "right") { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number-title{padding-right:5px;}';
		$output .= '<# } else { #>';
			$output .= '#sppb-addon-{{ data.id }} .sppb-animated-number {margin:0 auto;}';
		$output .= '<# } #>';

		$output .= $lodash->unit('border-width', '.sppb-animated-number', 'data.border_width', 'px;border-style:solid;', false);
		$output .= $lodash->unit('border-color', '.sppb-animated-number', 'data.border_color', '', false);
		$output .= $lodash->unit('border-radius', '.sppb-animated-number', 'data.border_radius', 'px', false);
		$output .= $lodash->color('background-color', '.sppb-animated-number', 'data.background', false);

		// global
		$output .= $lodash->alignment('text-align', '.sppb-addon-animated-number', 'data.alignment');

		// number
		$numberTypographyFallbacks = [
			'font'           => 'data.number_font_family',
			'size'           => 'data.font_size',
			'line_height'    => 'data.line_height',
			'weight'         => 'data.number_font_wight'
		];

		$output .= $lodash->color('color', '.sppb-animated-number', 'data.color');
		$output .= $lodash->typography('.sppb-animated-number', 'data.number_typography', $numberTypographyFallbacks);

		// Title
		$titleTypographyFallbacks = [
			'font'           => 'data.title_font_family',
			'size'           => 'data.title_font_size',
			'line_height'    => 'data.title_line_height',
			'uppercase'      => 'data.title_fontstyle?.uppercase',
			'italic'         => 'data.title_fontstyle?.italic',
			'underline'      => 'data.title_fontstyle?.underline',
			'weight'         => 'data.title_fontstyle?.weight'
		];

		$output .= $lodash->spacing('margin', '.sppb-animated-number-title', 'data.title_margin');
		$output .= $lodash->color('color', '.sppb-animated-number-title', 'data.title_color');
		$output .= $lodash->typography('.sppb-animated-number-title', 'data.title_typography', $titleTypographyFallbacks);
		$output .= '
		</style>
		<div class="sppb-addon sppb-addon-animated-number {{ data.class }} {{number_position}}">
			<div class="sppb-addon-content">
				<div class="sppb-animated-number sp-inline-editable-element" data-id={{data.id}} data-fieldName="number" contenteditable="true" data-format="{{data.use_number_format}}"  data-digit="{{ data.number }}" data-duration="{{ data.duration }}">0</div>
				<# if(data.counter_title){ #>
					<{{ heading_selector }} class="sppb-animated-number-title sp-inline-editable-element" data-id={{data.id}} data-fieldName="counter_title" contenteditable="true">{{ data.counter_title }}</{{ heading_selector }}>
				<# } #>
			</div>
		</div>';

		return $output;
	}
}
