<?php
/**
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;

$url  	= Route::_(version_compare(JVERSION, '4.0.0', '<') ? ContentHelperRoute::getArticleRoute($displayData->id . ':' . $displayData->alias, $displayData->catid, $displayData->language) : Joomla\Component\Content\Site\Helper\RouteHelper::getArticleRoute($displayData->id . ':' . $displayData->alias, $displayData->catid, $displayData->language));
$root 	= Uri::base();
$root 	= new Uri($root);
$url  	= $root->getScheme() . '://' . $root->getHost() . $url;

$params = Factory::getApplication()->getTemplate(true)->params;

if( $params->get('social_share') ) { ?>
	<div class="helix-social-share">
		<div class="helix-social-share-blog helix-social-share-article">
			<ul>
				<?php if ($params->get('share_facebook', 1)) { ?>
				<li>
					<div class="facebook" data-toggle="tooltip" data-placement="top" title="<?php echo Text::_('HELIX_SHARE_FACEBOOK'); ?>">
						<a class="facebook px-2" onClick="window.open('http://www.facebook.com/sharer.php?u=<?php echo $url; ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://www.facebook.com/sharer.php?u=<?php echo $url; ?>"><i class="fab fa-brands fa-facebook-f"></i></a>
					</div>
				</li>
                <?php } ?>
				<?php if ($params->get('share_twitter', 1)) { ?>
				<li>
					<div class="twitter" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_('HELIX_SHARE_TWITTER'); ?>">
						<a class="twitter px-2" onClick="window.open('http://twitter.com/share?url=<?php echo $url; ?>&amp;text=<?php echo str_replace('  ', '%20', $displayData->title); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo $url; ?>&amp;text=<?php echo str_replace(' ', '%20', $displayData->title); ?>"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" fill="currentColor" class="pe-va" viewBox="0 0 15 21"><path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/></svg><!--<i class="fa-brands fa-x-twitter"></i>--></a>
					</div>
				</li>
                <?php } ?>
                <?php if ($params->get('share_linkedin', 1)) { ?>
				<li>
					<div class="linkedin">
						<a class="linkedin px-2" data-toggle="tooltip" data-placement="top" title="<?php echo Text::_('HELIX_SHARE_LINKEDIN'); ?>" onClick="window.open('http://www.linkedin.com/shareArticle?mini=true&url=<?php echo $url; ?>','Linkedin','width=585,height=666,left='+(screen.availWidth/2-292)+',top='+(screen.availHeight/2-333)+''); return false;" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo $url; ?>" ><i class="fab fa-brands fa-linkedin-in"></i></a>
					</div>
				</li>
                <?php } ?>
			</ul>
		</div>		
	</div>
<?php } ?>