<?php
/**
 * field tos
 *
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;

$_prefix = $viewData['prefix'];
$field = $viewData['field'];
$tos = $field['value'];

if(VmConfig::isSiteByApp()){
	vmJsApi::popup('#full-tos','#terms-of-service');

	$cart = VirtuemartCart::getCart();
	$cart->prepareVendor();
	if(empty($tos) and !VmConfig::get ('agree_to_tos_onorder', true)){
		if(is_array($cart->BT) and !empty($cart->BT['tos'])){
			$tos = $cart->BT['tos'];
		}
	}
}

$class = 'terms-of-service';
if(!empty($field['required'])){
	$class .= ' required';
}
echo VmHtml::checkbox ($_prefix.$field['name'], $tos, 1, 0, 'class="'.$class.'"', 'tos');

if ( VmConfig::isSiteByApp() ) {
?>
<div class="terms-of-service">
	<label for="tos">
		<a href="<?php echo Route::_ ('index.php?option=com_virtuemart&view=vendor&layout=tos&virtuemart_vendor_id=1', FALSE) ?>" class="terms-of-service" id="terms-of-service" rel="facebox" target="_blank">
			<!--<span class="vmicon vm2-termsofservice-icon"></span>-->
            <i class="fa-solid fa-file-lines"></i>
			<?php echo vmText::_ ('COM_VIRTUEMART_CART_TOS_READ_AND_ACCEPTED') ?>
		</a>
	</label>

	<div id="full-tos" class="row text-start text-wrap">
		<h2 class="full-tos-title text-start text-wrap col-12 col-md-6 pt-3 pb-2 px-0 px-sm-0 px-md-3 mx-0"><svg xmlns="http://www.w3.org/2000/svg" style="margin:-5px 10px 0 8px" width="25" height="25" fill="currentColor" class="pe-va major_color-lighten-10 opacity-50" viewBox="0 0 16 16"><path d="M5 10.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5m0-2a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5m0-2a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5m0-2a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5"/><path d="M3 0h10a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2v-1h1v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v1H1V2a2 2 0 0 1 2-2"/><path d="M1 5v-.5a.5.5 0 0 1 1 0V5h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1zm0 3v-.5a.5.5 0 0 1 1 0V8h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1zm0 3v-.5a.5.5 0 0 1 1 0v.5h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1z"/>
</svg><?php echo vmText::_ ('COM_VIRTUEMART_CART_TOS') ?></h2>
		<div class="text-start text-wrap col-12 col-md-6 py-2 px-0 px-sm-0 px-md-4" style="text-align:left;"><?php echo $cart->vendor->vendor_terms_of_service ?></div>
	</div>
</div>
<?php } ?>