<?php
/**
* Flex @package Helix Framework
* @author Aplikko http://www.aplikko.com
* @copyright Copyright (c) 2024 Aplikko
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;

if (VmConfig::get('oncheckout_show_steps', 1)) {
	echo '<div class="checkoutStep" id="checkoutStep2">' . vmText::_('COM_VIRTUEMART_USER_FORM_CART_STEP2') . '</div>';
}

if ($this->layoutName!=$this->cart->layout) {
$headerLevel = 1;
if($this->cart->getInCheckOut()){
	$buttonclass = 'button vm-button-correct';
} else {
	$buttonclass = 'default';
}
?>
<form method="post" id="shipmentForm" name="chooseShipmentRate" action="<?php echo Route::_('index.php'); ?>" class="form-validate">
	<?php
	} else {
		$headerLevel = 3;
		$buttonclass = 'vm-button-correct';
	}

	if($this->cart->virtuemart_shipmentmethod_id){
		
		echo '<h5 style="font-size:110%;">'.vmText::_('COM_VIRTUEMART_CART_SELECTED_SHIPMENT_SELECT').'</h5>';
		echo '<div style="margin-top:25px;" class="clear"></div><hr class="border border-top-0 border-dark border-opacity-50 d-block w-100 clearfix" /><div style="margin-top:35px;" class="clear"></div>';
		
	} else {
		echo '<h'.$headerLevel.' class="vm-shipment-header-select">'.vmText::_('COM_VIRTUEMART_CART_SELECT_SHIPMENT').'</h'.$headerLevel.'>';
	}

	if ($this->found_shipment_method ) {
		echo '<div class="select_vm_wrap">';
		if (VmConfig::get('oncheckout_opc') == 0) {
			echo '<div class="col-md-offset-2 col-sm-8 col-md-offset-2">';
		}
		echo '<fieldset class="vm-payment-shipment-select vm-shipment-select vm-select">';
		// if only one Shipment , should be checked by default
		foreach ($this->shipments_shipment_rates as $shipment_shipment_rates) {
			if (is_array($shipment_shipment_rates)) {
				foreach ($shipment_shipment_rates as $shipment_shipment_rate) {
					echo '<div class="vm-shipment-plugin-single">'.$shipment_shipment_rate.'</div>';
				}
			}
		}
		echo '</fieldset>';
		if (VmConfig::get('oncheckout_opc') == 0) {
			echo '</div>';
		}
		echo '</div>';
		//echo '<div style="margin-top:35px;" class="clear"></div><hr />';
	} else {
		echo '<h'.$headerLevel.'>'. $this->shipment_not_found_text .'</h'.$headerLevel.'>';
	}
	?>
  
 	<div class="control-buttons">
		<?php
		$dynUpdate = '';
		if( VmConfig::get('oncheckout_ajax',false)) {
			$dynUpdate=' data-dynamic-update="1" ';
		 } ?>
         
          <?php if ((VmConfig::get('oncheckout_opc') == 0) || (VmConfig::get('oncheckout_ajax') == false)) { ?>
         <div style="height:5px;" class="clear"></div><hr class="border border-top-0 border-dark border-opacity-50 d-block w-100 clearfix mb-3" />
		<button style="margin-left:5px;margin-right:5px;" name="updatecart" class="vm-button-correct" type="submit" <?php echo $dynUpdate ?> ><?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?></button>
        <?php } ?>
        
		<?php if ($this->layoutName!=$this->cart->layout) { ?> 
			<button style="padding:6px 17px;" class="<?php echo $buttonclass ?>" type="reset" onClick="window.location.href='<?php echo Route::_('index.php?option=com_virtuemart&view=cart&task=cancel'); ?>'" ><?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?></button>
		<?php  } ?>
	</div>

<?php if ($this->layoutName!=$this->cart->layout) { ?> 
    <input type="hidden" name="option" value="com_virtuemart" />
	<input type="hidden" name="view" value="cart" />
	<input type="hidden" name="task" value="updatecart" />
	<input type="hidden" name="controller" value="cart" />
</form>
<?php
}
?>

