<?php
/**
 * Flex @package Helix Framework
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

//no direct accees
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
?>

<dl class="search-results<?php echo $this->pageclass_sfx; ?>">
<?php foreach ($this->results as $result) : ?>
	
	<?php //foreach ($this->results as $i => $result) : ?>
        <?php $this->result = &$result; ?>
        <?php //$this->result->counter = $i + 1; ?>
	
	<dt class="result-title">
		<?php echo $this->pagination->limitstart + $result->count . '. ';?>
		<?php if ($result->href) : ?>
			<a href="<?php echo Route::_($result->href); ?>">
				<?php echo $result->title; ?>
			</a><i class="fa-solid fa-link"></i>
		<?php else:?>
            <?php echo $result->title; ?>
		<?php endif; ?>
	</dt>
	<?php if (isset($result->section) && $result->section != '') : ?>
		<dd class="result-category">
			<span class="small<?php echo $this->pageclass_sfx; ?>"><svg style="margin:-5px 7px 0 0;vertical-align:middle;" xmlns="http://www.w3.org/2000/svg" width="13" height="13" fill="rgba(50,50,50,.7)" class="bi bi-folder2-open" viewBox="0 0 16 16"><path d="M1 3.5A1.5 1.5 0 0 1 2.5 2h2.764c.958 0 1.76.56 2.311 1.184C7.985 3.648 8.48 4 9 4h4.5A1.5 1.5 0 0 1 15 5.5v.64c.57.265.94.876.856 1.546l-.64 5.124A2.5 2.5 0 0 1 12.733 15H3.266a2.5 2.5 0 0 1-2.481-2.19l-.64-5.124A1.5 1.5 0 0 1 1 6.14zM2 6h12v-.5a.5.5 0 0 0-.5-.5H9c-.964 0-1.71-.629-2.174-1.154C6.374 3.334 5.82 3 5.264 3H2.5a.5.5 0 0 0-.5.5zm-.367 1a.5.5 0 0 0-.496.562l.64 5.124A1.5 1.5 0 0 0 3.266 14h9.468a1.5 1.5 0 0 0 1.489-1.314l.64-5.124A.5.5 0 0 0 14.367 7H1.633z"/></svg><?php echo $this->escape($result->section); ?>
			</span>
		</dd>
	<?php endif; ?>
	<dd class="result-text my-3">
		<?php echo $result->text; ?>
	</dd>
	<?php if ($this->params->get('show_date')) : ?>
		<dd class="small result-created<?php echo $this->pageclass_sfx; ?>">
			<!--<i class="pe pe-7s-pen"></i>--><svg style="margin:-5px 7px 0 0;vertical-align:middle;" xmlns="http://www.w3.org/2000/svg" width="13" height="13" fill="rgba(50,50,50,.7)" class="bi bi-calendar2-check" viewBox="0 0 16 16"><path d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0z"/><path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5M2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1z"/><path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5z"/></svg><?php echo Text::sprintf('JGLOBAL_CREATED_DATE_ON', $result->created); ?>
		</dd>
	<?php endif; ?>
<?php endforeach; ?>
</dl>
<div class="pagination">
	<?php echo $this->pagination->getPagesLinks(); ?>
</div>
