<?php
/**
 * Flex @package Helix Framework
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Installer\Installer;

class plgSystemTmp_helix3InstallerScript {

    function postflight($type, $parent)
    {
        $db = Factory::getDBO();
        $status = new stdClass;
        $status->plugins = array();

        $src = $parent->getParent()->getPath('source');
        $manifest = $parent->getParent()->manifest;
        $plugins = $manifest->xpath('plugins/plugin');

        foreach ($plugins as $key => $plugin)
        {
            $name = (string)$plugin->attributes()->plugin;
            $group = (string)$plugin->attributes()->group;
            $path = $src.'/plugins/'.$group;

            if (Folder::exists($src.'/plugins/'.$group.'/'.$name))
            {
                $path = $src.'/plugins/'.$group.'/'.$name;
            }

			$installer = new Installer();
            $result = $installer->install($path);

            if ($result)
            {
                $db = Factory::getDBO();
                $query = $db->getQuery(true);
                $fields = array(
                    $db->quoteName('enabled') . ' = 1'
                );

                $conditions = array(
                    $db->quoteName('type') . ' = ' . $db->quote('plugin'),
                    $db->quoteName('element') . ' = ' . $db->quote($name),
                    $db->quoteName('folder') . ' = ' . $db->quote($group)
                );

                $query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
                $db->setQuery($query);
                $db->execute();
            }
        }

        $template_path = $src.'/template';

        if (Folder::exists( $template_path ))
        {
			$installer = new Installer;
            $installer->install($template_path);
        }

        $conf = Factory::getConfig();
        $conf->set('debug', false);
        $parent->getParent()->abort();
		
		?>
		<style type="text/css">
        .flex-installation-wrap{
          padding: 20px 0 40px;
          overflow: hidden;
        }
		.flex-installation-wrap .flex-installation-left p {
            text-align:center;
			margin:10px auto;
			color:#777;
        }
        .flex-installation-wrap .flex-installation-footer{
          margin-top: 30px;
        }
    
        .flex-installation-wrap .flex-installation-footer a{
          margin-right: 10px;
        }
        </style>

		<div class="container-fluid w-100 clearfix">
		  <div class="flex-installation-wrap row w-100">
			<div class="span4 flex-installation-left col-12 col-sm-5">
			  <img class="w-100" src="https://flex.aplikko.com/templates/flex/template_preview.png" alt="Flex" />
			  <p>Version 4.0</p>
			</div>
			<div class="span8 flex-installation-texts span4 col-12 col-sm-7">
			  <h2>FLEX - Most Flexible Joomla Template</h2>
			  <p>Flex is a bestseller, super flexible, multi-purpose Joomla template that can fit in any type of website you are building. It is clean, responsive, includes drag n' drop Layout and Page Builder and comes packed with powerful options! With stunning animations and eye-catchy layouts, Flex will help you draw attention of visitors at first sight.</p>
			  <hr />
			  <div style="margin-bottom:20px;" class="row">
				<h3>Flex is Joomla 5 compatible!</h3>
			  </div>
			</div>
			<hr style="margin-top:25px;" />
			<div class="flex-installation-wrap row w-100">
			  <div class="span4 flex-installation-left col-12 col-sm-5">
				<div class="ratio ratio-16x9">
				  <iframe class="col-12" width="100%" height="100%" src="https://www.youtube.com/embed/agMGyThdulE" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
				<hr />
				<div class="ratio ratio-16x9">
				  <iframe width="100%" height="100%" src="https://www.youtube.com/embed/VWcG8mpc208" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
				<p style="font-size:80%;margin:20px auto 0;">The Privacy Tool Suite by Joomla</p>
			  </div>
			  <div class="span8 flex-installation-right span8 col-12 col-sm-7">
				<div class="flex-installation-texts">
				  <h3>What is Joomla?</h3>
				  <p>Joomla is an open source content management system (CMS). It helps you build powerful dynamic websites and applications. It has an intuitive interface that helps you use its features and functionality to the fullest.</p>
				  <p>Joomla has gained huge popularity over the last decade and successfully grown into one of the most widely used content management systems globally. Since its inception in 2005, it has successfully captured the massive following and it certainly has over 99 + million downloads till date. <a href="https://www.joomla.org/3/" target="_blank">More info here</a>
				  </p>
				</div>
				<hr style="margin-top:25px;" />
				<div class="flex-installation-footer d-flex justify-content-center">
				  <div class="pagebuilder-links">
					<a style="padding:8px 22px" class="btn btn-success mb-3" href="index.php?option=com_templates&view=styles">Get Started with Flex</a>
					<a style="padding:8px 22px" class="btn btn-warning mb-3" href="http://documentation.aplikko.com/flex/index.html" target="_blank">Documentation</a>
				  </div>
				</div>
			  </div>
			</div>
		  </div>
		</div>
        <?php 
    }
	
	public function abort($msg = null, $type = null)
    {
        if ($msg)
        {
            Factory::getApplication()->enqueueMessage($msg, 'warning');
        }

        foreach ($this->packages as $package)
        {
            $package['installer']->abort(null, $type);
        }
    }

}