<?php 
	
	function fixar_customize_footer_tab($wp_customize, $theme_name){

		$wp_customize->add_section( 'fixar_footer_settings' , array(
		    'title'      => esc_html__( 'Footer', 'fixar' ),
		    'priority'   => 75,
		) );

		// Получаем все шаблоны Elementor
		$elementor_templates = array(
			'0' => esc_html__('None', 'fixar'),
		);
		
		// Проверяем, активен ли Elementor
		if (class_exists('\Elementor\Plugin')) {
			$templates = get_posts([
				'post_type' => 'elementor_library',
				'post_status' => 'publish',
				'posts_per_page' => -1,
				'orderby' => 'title',
				'order' => 'ASC',
			]);
			
			if (!empty($templates)) {
				foreach ($templates as $template) {
					$elementor_templates[$template->ID] = $template->post_title;
				}
			}
		}

		// Настройка для выбора шаблона Elementor для футера
		$wp_customize->add_setting( 'fixar_footer_elementor_template' , array(
			'default'     => '0',
			'transport'   => 'refresh',
			'sanitize_callback' => 'absint'
		) );
		
		$wp_customize->add_control(
			'fixar_footer_elementor_template',
			array(
				'label'    => esc_html__( 'Elementor Footer Template', 'fixar' ),
				'description' => esc_html__( 'Select an Elementor template to use as footer', 'fixar' ),
				'section'  => 'fixar_footer_settings',
				'settings' => 'fixar_footer_elementor_template',
				'type'     => 'select',
				'choices'  => $elementor_templates,
			)
		);

		// Настройка для фиксированного футера
		$wp_customize->add_setting( 'fixar_footer_fixed' , array(
            'default'     => '0',
            'transport'   => 'refresh',
		    'sanitize_callback' => 'esc_html'
        ) );
		
		$wp_customize->add_control(
            'fixar_footer_fixed',
            array(
                'label'    => esc_html__( 'Fixed', 'fixar' ),
                'section'  => 'fixar_footer_settings',
                'settings' => 'fixar_footer_fixed',
                'type'     => 'select',
                'choices'  => array(
                    '1'  => esc_html__( 'On', 'fixar' ),
                    '0' => esc_html__( 'Off', 'fixar' ),
                ),
            )
        );

		// Настройка для копирайта
		$wp_customize->add_setting( 'fixar_footer_settings_copyright' , array(
			'default'     => esc_html__('&copy; 2025 Fixar. All rights reserved.', 'fixar'),
			'transport'   => 'refresh',
			'sanitize_callback' => 'wp_kses_post'
		) );
		
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'fixar_footer_settings_copyright',
				array(
					'label'    => esc_html__( 'Copyright Text', 'fixar' ),
					'section'  => 'fixar_footer_settings',
					'settings' => 'fixar_footer_settings_copyright',
					'type'     => 'textarea',
				)
			)
		);
	}
?>