<?php 
global $product;
$product_id = $product->get_id();
?>
<div class="product-service-inner clearfix" data-product-id="<?php echo esc_attr($product_id); ?>">
    <div class="left-info">
        <?php if ( has_post_thumbnail( $product->get_id() ) ) {
            $attachment_ids[0] = get_post_thumbnail_id( $product->get_id() );
            $attachment = wp_get_attachment_image_src($attachment_ids[0], 'findgo-attachment' ); ?>   
            <figure class="image"> 
                <img src="<?php echo esc_attr($attachment[0]); ?>" />
            </figure>
        <?php } ?>
    </div>
    <div class="right-info">
        <?php
            /**
            * woocommerce_after_shop_loop_item_title hook
            *
            * @hooked woocommerce_template_loop_rating - 5
            * @hooked woocommerce_template_loop_price - 10
            */
            remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5);
            do_action( 'woocommerce_after_shop_loop_item_title');
        ?>
        <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <?php if ( has_excerpt() ) { ?>
            <div class="description"><?php echo findgo_substring( get_the_excerpt(), 22, '...' ); ?></div>
        <?php } else { ?>
            <div class="description"><?php echo findgo_substring( get_the_content(), 22, '...' ); ?></div>
        <?php } ?>
    </div>
</div>