<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$lcategories = array();
if ( isset($categories) && !empty($categories) ) {
    $lcategories = explode(',', $categories);
}

$lregions = array();
if ( isset($regions) && !empty($regions) ) {
    $lregions = explode(',', $regions);
}

$args = array(
	'type' => $types,
	'post_per_page' => $number,
	'categories' => $lcategories,
	'regions' => $lregions,
	'item' => 'grid',
);
$loop = findgo_get_listings($args);
?>
<div class="widget widget-listing style-<?php echo esc_attr($style) ?> <?php echo esc_attr($el_class); ?>">
	<?php if ($title!=''): ?>
        <h2 class="widget-title">
            <span><?php echo trim($title); ?></span>
        </h2>
    <?php endif; ?>
    <div class="widget-content ">
    	<?php if($style == 'carousel') { ?>
	    	<?php if ($loop->have_posts()): ?>
				<div class="slick-carousel" data-carousel="slick" data-items="<?php echo esc_attr($columns); ?>" data-smalldesktop='3' data-smallmedium="2" data-extrasmall="1" data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>">
					<?php $count = 0; while ( $loop->have_posts() ): $loop->the_post(); global $post; ?>
						<?php get_template_part( 'job_manager/loop/'.$item); ?>
					<?php $count++; endwhile; ?>
				</div>
	    	<?php endif; ?>
	    <?php } elseif($style == 'grid') { ?>
	    	<div class="row">
		    	<?php $count = 1; while ( $loop->have_posts() ): $loop->the_post(); global $post; ?>
		    		<div class="full-mb col-xs-6 col-sm-6 col-md-<?php echo esc_attr(12/$columns);?> <?php echo ($count%$columns == 1) ? ' md-clearfix ':''; echo ($count%2 == 1) ? ' sm-clearfix ':''; ?>">
		    			<?php get_template_part( 'job_manager/loop/'.$item); ?>
		    		</div>
		    	<?php $count++; endwhile; ?>
	    	</div>
	    <?php }else{ ?>
	    	<?php while ( $loop->have_posts() ): $loop->the_post(); global $post; ?>
				<?php get_template_part( 'job_manager/loop/list'); ?>
			<?php endwhile; ?>
	    <?php } ?>
    </div>
</div>
<?php wp_reset_postdata(); ?>